/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessWrapper;
import com.intellij.execution.process.RunnerMediator;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.NotNull;

public class RunnerWinProcess
extends ProcessWrapper {
    private RunnerWinProcess(@NotNull Process originalProcess) {
        if (originalProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalProcess", "com/intellij/execution/process/RunnerWinProcess", "<init>"));
        }
        super(originalProcess);
    }

    public void destroyGracefully(boolean softKill) {
        RunnerMediator.destroyProcess(this, softKill);
    }

    @NotNull
    public static Process create(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/RunnerWinProcess", "create"));
        }
        if (!SystemInfo.isWindows) {
            throw new RuntimeException("RunnerWinProcess works on Windows only!");
        }
        boolean success = RunnerMediator.injectRunnerCommand(commandLine);
        Process process = commandLine.createProcess();
        Process process2 = success ? new RunnerWinProcess(process) : process;
        if (process2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/RunnerWinProcess", "create"));
        }
        return process2;
    }
}

