/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.testframework.autotest.AutoTestManager;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdjustAutotestDelayActionGroup
extends ActionGroup {
    public static final int MAX_DELAY = 10;
    private final DataContext myDataContext;

    public AdjustAutotestDelayActionGroup(@NotNull JComponent parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/testframework/autotest/AdjustAutotestDelayActionGroup", "<init>"));
        }
        super("Set AutoTest Delay", true);
        this.myDataContext = DataManager.getInstance().getDataContext((Component)parent);
    }

    public void update(AnActionEvent e) {
        RunContentDescriptor descriptor = (RunContentDescriptor)LangDataKeys.RUN_CONTENT_DESCRIPTOR.getData(this.myDataContext);
        boolean visible = false;
        if (descriptor != null) {
            for (AnAction action : descriptor.getRestartActions()) {
                if (!(action instanceof ToggleAutoTestAction)) continue;
                visible = true;
                break;
            }
        }
        e.getPresentation().setVisible(visible);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] actions = new AnAction[10];
        for (int i = 0; i < 10; ++i) {
            actions[i] = new SetAutoTestDelayAction(i + 1);
        }
        if (actions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/autotest/AdjustAutotestDelayActionGroup", "getChildren"));
        }
        return actions;
    }

    private static class SetAutoTestDelayAction
    extends ToggleAction {
        private final int myDelay;

        public SetAutoTestDelayAction(int delay) {
            super(delay + "s");
            this.myDelay = delay * 1000;
        }

        public boolean isSelected(AnActionEvent e) {
            Project project2 = e.getProject();
            return project2 != null && AutoTestManager.getInstance(project2).getDelay() == this.myDelay;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            Project project2 = e.getProject();
            if (project2 != null) {
                AutoTestManager.getInstance(project2).setDelay(this.myDelay);
            }
        }
    }
}

