/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.ui.DefaultJreSelectorKt;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u000b2\u00020\u0001:\u0004\u000b\f\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\b0\nH&\u00a8\u0006\u000f"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector;", "", "()V", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "getDescriptionString", "", "getNameAndDescription", "Lcom/intellij/openapi/util/Pair;", "Companion", "ProjectSdkSelector", "SdkFromModuleDependencies", "SdkFromSourceRootDependencies", "execution-impl"})
public abstract class DefaultJreSelector {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract Pair<String, String> getNameAndDescription();

    public void addChangeListener(@NotNull Runnable listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getDescriptionString() {
        void description;
        void name;
        Pair<String, String> pair = this.getNameAndDescription();
        String string = ExtensionsKt.component1(pair);
        String string2 = ExtensionsKt.component2(pair);
        pair = null;
        StringBuilder stringBuilder = new StringBuilder().append(" (");
        String string3 = name;
        if (string3 == null) {
            string3 = "<no JRE>";
        }
        return stringBuilder.append(string3).append(" - ").append((String)description).append(")").toString();
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector projectSdk(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return Companion.projectSdk(project2);
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector fromModuleDependencies(@NotNull ModulesComboBox moduleComboBox, boolean productionOnly) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
        return Companion.fromModuleDependencies(moduleComboBox, productionOnly);
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector fromSourceRootsDependencies(@NotNull ModulesComboBox moduleComboBox, @NotNull EditorTextFieldWithBrowseButton classSelector) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
        Intrinsics.checkParameterIsNotNull((Object)((Object)classSelector), (String)"classSelector");
        return Companion.fromSourceRootsDependencies(moduleComboBox, classSelector);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0007\u001a#\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector$ProjectSdkSelector;", "Lcom/intellij/execution/ui/DefaultJreSelector;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getNameAndDescription", "Lcom/intellij/openapi/util/Pair;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "execution-impl"})
    public static final class ProjectSdkSelector
    extends DefaultJreSelector {
        @NotNull
        private final Project project;

        @Override
        @NotNull
        public Pair<String, String> getNameAndDescription() {
            return Pair.create((Object)ProjectRootManager.getInstance((Project)this.project).getProjectSdkName(), (Object)"project SDK");
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public ProjectSdkSelector(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            this.project = project2;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector$SdkFromModuleDependencies;", "Lcom/intellij/execution/ui/DefaultJreSelector;", "moduleComboBox", "Lcom/intellij/application/options/ModulesComboBox;", "productionOnly", "Lkotlin/Function0;", "", "(Lcom/intellij/application/options/ModulesComboBox;Lkotlin/jvm/functions/Function0;)V", "getModuleComboBox", "()Lcom/intellij/application/options/ModulesComboBox;", "getProductionOnly", "()Lkotlin/jvm/functions/Function0;", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "getNameAndDescription", "Lcom/intellij/openapi/util/Pair;", "", "execution-impl"})
    public static class SdkFromModuleDependencies
    extends DefaultJreSelector {
        @NotNull
        private final ModulesComboBox moduleComboBox;
        @NotNull
        private final Function0<Boolean> productionOnly;

        @Override
        @NotNull
        public Pair<String, String> getNameAndDescription() {
            Module module2 = this.moduleComboBox.getSelectedModule();
            if (module2 == null) {
                Pair pair = Pair.create(null, (Object)"module not specified");
                Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(null, \"module not specified\")");
                return pair;
            }
            Module module3 = module2;
            boolean productionOnly = (Boolean)this.productionOnly.invoke();
            Sdk jdkToRun = JavaParameters.getJdkToRunModule((Module)module3, (boolean)productionOnly);
            Sdk moduleJdk = ModuleRootManager.getInstance((Module)module3).getSdk();
            if (moduleJdk == null || jdkToRun == null) {
                Pair pair = Pair.create(null, (Object)"module not specified");
                Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(null, \"module not specified\")");
                return pair;
            }
            if (Intrinsics.areEqual((Object)moduleJdk.getHomeDirectory(), (Object)jdkToRun.getHomeDirectory())) {
                Pair pair = Pair.create((Object)moduleJdk.getName(), (Object)("SDK of '" + module3.getName() + "' module"));
                Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(moduleJdk.na\u2026'${module.name}' module\")");
                return pair;
            }
            Pair pair = Pair.create((Object)jdkToRun.getName(), (Object)("newest SDK from '" + module3.getName() + "' module" + (productionOnly ? "" : " test") + " dependencies"));
            Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(jdkToRun.nam\u2026e \" test\"} dependencies\")");
            return pair;
        }

        @Override
        public void addChangeListener(@NotNull Runnable listener2) {
            Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
            this.moduleComboBox.addActionListener(new ActionListener(listener2){
                final /* synthetic */ Runnable $listener;

                public final void actionPerformed(ActionEvent it) {
                    this.$listener.run();
                }
                {
                    this.$listener = runnable2;
                }
            });
        }

        @NotNull
        public final ModulesComboBox getModuleComboBox() {
            return this.moduleComboBox;
        }

        @NotNull
        public final Function0<Boolean> getProductionOnly() {
            return this.productionOnly;
        }

        public SdkFromModuleDependencies(@NotNull ModulesComboBox moduleComboBox, @NotNull Function0<Boolean> productionOnly) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
            Intrinsics.checkParameterIsNotNull(productionOnly, (String)"productionOnly");
            this.moduleComboBox = moduleComboBox;
            this.productionOnly = productionOnly;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector$SdkFromSourceRootDependencies;", "Lcom/intellij/execution/ui/DefaultJreSelector$SdkFromModuleDependencies;", "moduleComboBox", "Lcom/intellij/application/options/ModulesComboBox;", "classSelector", "Lcom/intellij/ui/EditorTextFieldWithBrowseButton;", "(Lcom/intellij/application/options/ModulesComboBox;Lcom/intellij/ui/EditorTextFieldWithBrowseButton;)V", "getClassSelector", "()Lcom/intellij/ui/EditorTextFieldWithBrowseButton;", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "execution-impl"})
    public static final class SdkFromSourceRootDependencies
    extends SdkFromModuleDependencies {
        @NotNull
        private final EditorTextFieldWithBrowseButton classSelector;

        @Override
        public void addChangeListener(@NotNull Runnable listener2) {
            Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
            super.addChangeListener(listener2);
            ((EditorTextField)((Object)this.classSelector.getChildComponent())).addDocumentListener((DocumentListener)new DocumentAdapter(listener2){
                final /* synthetic */ Runnable $listener;

                public void documentChanged(@Nullable DocumentEvent e) {
                    this.$listener.run();
                }
                {
                    this.$listener = $captured_local_variable$0;
                }
            });
        }

        @NotNull
        public final EditorTextFieldWithBrowseButton getClassSelector() {
            return this.classSelector;
        }

        public SdkFromSourceRootDependencies(final @NotNull ModulesComboBox moduleComboBox, final @NotNull EditorTextFieldWithBrowseButton classSelector) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
            Intrinsics.checkParameterIsNotNull((Object)((Object)classSelector), (String)"classSelector");
            super(moduleComboBox, (Function0<Boolean>)((Function0)new Function0<Boolean>(){

                public final boolean invoke() {
                    return DefaultJreSelectorKt.access$isClassInProductionSources(moduleComboBox, classSelector);
                }
            }));
            this.classSelector = classSelector;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector$Companion;", "", "()V", "fromModuleDependencies", "Lcom/intellij/execution/ui/DefaultJreSelector;", "moduleComboBox", "Lcom/intellij/application/options/ModulesComboBox;", "productionOnly", "", "fromSourceRootsDependencies", "classSelector", "Lcom/intellij/ui/EditorTextFieldWithBrowseButton;", "projectSdk", "project", "Lcom/intellij/openapi/project/Project;", "execution-impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DefaultJreSelector projectSdk(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            return new ProjectSdkSelector(project2);
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector fromModuleDependencies(@NotNull ModulesComboBox moduleComboBox, boolean productionOnly) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
            return new SdkFromModuleDependencies(moduleComboBox, (Function0<Boolean>)((Function0)new Function0<Boolean>(productionOnly){
                final /* synthetic */ boolean $productionOnly;

                public final boolean invoke() {
                    return this.$productionOnly;
                }
                {
                    this.$productionOnly = bl;
                    super(0);
                }
            }));
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector fromSourceRootsDependencies(@NotNull ModulesComboBox moduleComboBox, @NotNull EditorTextFieldWithBrowseButton classSelector) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
            Intrinsics.checkParameterIsNotNull((Object)((Object)classSelector), (String)"classSelector");
            return new SdkFromSourceRootDependencies(moduleComboBox, classSelector);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

