/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryNameAndLevelPanel;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class EditLibraryDialog
extends DialogWrapper {
    private JPanel myEditorPanel;
    private JPanel myPanel;
    private JPanel myNameAndLevelPanelWrapper;
    private final LibraryNameAndLevelPanel myNameAndLevelPanel;
    private LibraryCompositionSettings mySettings;
    private LibraryEditor myLibraryEditor;
    private LibraryRootsComponent myLibraryRootsComponent;
    private FormBuilder myBuilder;

    public EditLibraryDialog(Component parent, LibraryCompositionSettings settings, LibraryEditor libraryEditor) {
        super(parent, true);
        this.mySettings = settings;
        this.myLibraryEditor = libraryEditor;
        this.$$$setupUI$$$();
        this.myLibraryRootsComponent = new LibraryRootsComponent(null, libraryEditor);
        this.myLibraryRootsComponent.resetProperties();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myLibraryRootsComponent);
        boolean newLibrary = libraryEditor instanceof NewLibraryEditor;
        this.setTitle((newLibrary ? "Create" : "Edit") + " Library");
        this.myBuilder = LibraryNameAndLevelPanel.createFormBuilder();
        this.myNameAndLevelPanel = new LibraryNameAndLevelPanel(this.myBuilder, libraryEditor.getName(), newLibrary ? settings.getNewLibraryLevel() : null);
        this.init();
    }

    protected JComponent createCenterPanel() {
        JComponent editor = this.myLibraryRootsComponent.getComponent();
        this.myEditorPanel.add(editor);
        this.myNameAndLevelPanelWrapper.add(this.myBuilder.getPanel());
        return this.myPanel;
    }

    protected void doOKAction() {
        this.myLibraryEditor.setName(this.myNameAndLevelPanel.getLibraryName());
        this.myLibraryRootsComponent.applyProperties();
        if (this.myLibraryEditor instanceof NewLibraryEditor) {
            this.mySettings.setNewLibraryLevel(this.myNameAndLevelPanel.getLibraryLevel());
        }
        super.doOKAction();
    }

    @Nullable
    protected String getHelpId() {
        return "Edit_Library_dialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEditorPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myNameAndLevelPanelWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

