/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalJavaDocAction
extends AnAction {
    public ExternalJavaDocAction() {
        this.setInjectedContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        ExternalDocumentationProvider externalDocumentationProvider;
        DataContext dataContext = e.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element = ExternalJavaDocAction.getElement(dataContext, editor);
        if (element == null) {
            Messages.showMessageDialog((Project)project2, (String)IdeBundle.message((String)"message.please.select.element.for.javadoc", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.no.element.selected", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        PsiFile context = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiElement originalElement = ExternalJavaDocAction.getOriginalElement(context, editor);
        DocumentationManager.storeOriginalElement(project2, originalElement, element);
        DocumentationProvider provider = DocumentationManager.getProviderFromElement(element);
        if (provider instanceof ExternalDocumentationHandler && ((ExternalDocumentationHandler)provider).handleExternal(element, originalElement)) {
            return;
        }
        List urls = provider.getUrlFor(element, originalElement);
        if (urls != null && !urls.isEmpty()) {
            ExternalJavaDocAction.showExternalJavadoc(urls, (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext));
        } else if (provider instanceof ExternalDocumentationProvider && (externalDocumentationProvider = (ExternalDocumentationProvider)provider).canPromptToConfigureDocumentation(element)) {
            externalDocumentationProvider.promptToConfigureDocumentation(element);
        }
    }

    public static void showExternalJavadoc(@NotNull List<String> urls, Component component) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/ide/actions/ExternalJavaDocAction", "showExternalJavadoc"));
        }
        THashSet set = new THashSet(urls);
        if (set.size() > 1) {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>("Choose external documentation root", ArrayUtil.toStringArray((Collection)set)){

                public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                    BrowserUtil.browse((String)selectedValue);
                    return FINAL_CHOICE;
                }
            }).showInBestPositionFor(DataManager.getInstance().getDataContext(component));
        } else if (set.size() == 1) {
            BrowserUtil.browse((String)urls.get(0));
        }
    }

    @Nullable
    private static PsiElement getOriginalElement(PsiFile context, Editor editor) {
        return context != null && editor != null ? context.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    public void update(AnActionEvent event) {
        boolean enabled;
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element = ExternalJavaDocAction.getElement(dataContext, editor);
        PsiElement originalElement = ExternalJavaDocAction.getOriginalElement((PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext), editor);
        DocumentationManager.storeOriginalElement((Project)CommonDataKeys.PROJECT.getData(dataContext), originalElement, element);
        DocumentationProvider provider = DocumentationManager.getProviderFromElement(element);
        if (provider instanceof ExternalDocumentationProvider) {
            ExternalDocumentationProvider edProvider = (ExternalDocumentationProvider)provider;
            enabled = edProvider.hasDocumentationFor(element, originalElement) || edProvider.canPromptToConfigureDocumentation(element);
        } else {
            List urls = provider.getUrlFor(element, originalElement);
            boolean bl = enabled = urls != null && !urls.isEmpty();
        }
        if (editor != null) {
            presentation.setEnabled(enabled);
            if (ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace())) {
                presentation.setVisible(true);
            } else {
                presentation.setVisible(enabled);
            }
        } else {
            presentation.setEnabled(enabled);
            presentation.setVisible(true);
        }
    }

    private static PsiElement getElement(DataContext dataContext, Editor editor) {
        PsiReference reference;
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element == null && editor != null && (reference = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset())) != null) {
            element = reference.getElement();
        }
        return element;
    }
}

