/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenFileAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/OpenFileAction", "actionPerformed"));
        }
        final Project project2 = e.getProject();
        boolean showFiles = project2 != null || PlatformProjectOpenProcessor.getInstanceIfItExists() != null;
        final OpenProjectFileChooserDescriptor descriptor = showFiles ? new ProjectOrFileChooserDescriptor() : new ProjectOnlyFileChooserDescriptor();
        descriptor.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, showFiles);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project2, (VirtualFile)VfsUtil.getUserHomeDir(), (Consumer)new Consumer<List<VirtualFile>>(){

            public void consume(List<VirtualFile> files) {
                for (VirtualFile file2 : files) {
                    if (descriptor.isFileSelectable(file2)) continue;
                    String message = IdeBundle.message((String)"error.dir.contains.no.project", (Object[])new Object[]{file2.getPresentableUrl()});
                    Messages.showInfoMessage((Project)project2, (String)message, (String)IdeBundle.message((String)"title.cannot.open.project", (Object[])new Object[0]));
                    return;
                }
                OpenFileAction.doOpenFile(project2, files);
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/OpenFileAction", "update"));
        }
        if (NewWelcomeScreen.isNewWelcomeScreen(e)) {
            e.getPresentation().setIcon(AllIcons.Welcome.OpenProject);
        }
    }

    private static void doOpenFile(@Nullable Project project2, @NotNull List<VirtualFile> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/actions/OpenFileAction", "doOpenFile"));
        }
        for (VirtualFile file2 : result) {
            Project openedProject;
            if (file2.isDirectory()) {
                openedProject = ProjectAttachProcessor.canAttachToProject() ? PlatformProjectOpenProcessor.doOpenProject(file2, project2, false, -1, null, false) : ProjectUtil.openOrImport(file2.getPath(), project2, false);
                FileChooserUtil.setLastOpenedFile(openedProject, file2);
                return;
            }
            if ((project2 == null || !file2.equals(project2.getProjectFile())) && OpenProjectFileChooserDescriptor.isProjectFile(file2) && (openedProject = ProjectUtil.openOrImport(file2.getPath(), project2, false)) != null) {
                FileChooserUtil.setLastOpenedFile(openedProject, file2);
                return;
            }
            FileType type = FileTypeChooser.getKnownFileTypeOrAssociate(file2, project2);
            if (type == null) {
                return;
            }
            if (project2 != null) {
                OpenFileAction.openFile(file2, project2);
                continue;
            }
            PlatformProjectOpenProcessor processor2 = PlatformProjectOpenProcessor.getInstanceIfItExists();
            if (processor2 == null) continue;
            processor2.doOpenProject(file2, null, false);
        }
    }

    public static void openFile(String filePath, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/OpenFileAction", "openFile"));
        }
        VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (file2 != null && file2.isValid()) {
            OpenFileAction.openFile(file2, project2);
        }
    }

    public static void openFile(VirtualFile file2, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/OpenFileAction", "openFile"));
        }
        FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(project2, file2);
        if (providers.length == 0) {
            String message = IdeBundle.message((String)"error.files.of.this.type.cannot.be.opened", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
            Messages.showErrorDialog((Project)project2, (String)message, (String)IdeBundle.message((String)"title.cannot.open.file", (Object[])new Object[0]));
            return;
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project2, file2);
        FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor, true);
    }

    private static class ProjectOrFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        private final FileChooserDescriptor myStandardDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withHideIgnored(false);

        public ProjectOrFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.file.or.project", (Object[])new Object[0]));
        }

        @Override
        public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
            return file2.isDirectory() ? super.isFileVisible(file2, showHiddenFiles) : this.myStandardDescriptor.isFileVisible(file2, showHiddenFiles);
        }

        @Override
        public boolean isFileSelectable(VirtualFile file2) {
            return file2.isDirectory() ? super.isFileSelectable(file2) : this.myStandardDescriptor.isFileSelectable(file2);
        }

        public boolean isChooseMultiple() {
            return true;
        }
    }

    private static class ProjectOnlyFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        public ProjectOnlyFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.project", (Object[])new Object[0]));
        }
    }
}

