/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PinActiveTabAction
extends DumbAwareAction
implements Toggleable {
    public void actionPerformed(AnActionEvent e) {
        Handler handler2 = this.getHandler(e);
        if (handler2 == null) {
            return;
        }
        boolean selected = !handler2.isPinned;
        handler2.setPinned(selected);
        e.getPresentation().putClientProperty("selected", (Object)selected);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "update"));
        }
        Handler handler2 = this.getHandler(e);
        boolean enabled = handler2 != null;
        boolean selected = enabled && handler2.isPinned;
        e.getPresentation().setIcon(ActionPlaces.isToolbarPlace((String)e.getPlace()) ? AllIcons.General.Pin_tab : null);
        e.getPresentation().putClientProperty("selected", (Object)selected);
        String text = ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || handler2 != null && !handler2.isActiveTab ? (selected ? IdeBundle.message((String)"action.unpin.active.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.active.tab", (Object[])new Object[0])) : (selected ? IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.tab", (Object[])new Object[0]));
        e.getPresentation().setText(text);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    protected Handler getHandler(@NotNull AnActionEvent e) {
        VirtualFile selectedFile;
        Content content;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "getHandler"));
        }
        Project project2 = e.getProject();
        EditorWindow currentWindow = (EditorWindow)e.getData(EditorWindow.DATA_KEY);
        Content content2 = content = currentWindow != null ? null : this.getContentFromEvent(e);
        if (content != null && content.isPinnable()) {
            return PinActiveTabAction.createHandler(content);
        }
        EditorWindow window = currentWindow != null ? currentWindow : (project2 != null ? FileEditorManagerEx.getInstanceEx(project2).getCurrentWindow() : null);
        VirtualFile virtualFile = selectedFile = window == null ? null : this.getFileFromEvent(e, window);
        if (selectedFile != null) {
            return PinActiveTabAction.createHandler(window, selectedFile);
        }
        return null;
    }

    @Nullable
    protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "getFileFromEvent"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ide/actions/PinActiveTabAction", "getFileFromEvent"));
        }
        return PinActiveTabAction.getFileInWindow(e, window);
    }

    @Nullable
    protected Content getContentFromEvent(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "getContentFromEvent"));
        }
        Content content = PinActiveTabAction.getNonToolWindowContent(e);
        if (content == null) {
            content = PinActiveTabAction.getToolWindowContent(e);
        }
        return content != null && content.isValid() ? content : null;
    }

    @NotNull
    private static Handler createHandler(final Content content) {
        Handler handler2 = new Handler(content.isPinned(), content.getManager().getSelectedContent() == content){

            @Override
            void setPinned(boolean value) {
                content.setPinned(value);
            }
        };
        if (handler2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/PinActiveTabAction", "createHandler"));
        }
        return handler2;
    }

    @NotNull
    private static Handler createHandler(final EditorWindow window, final VirtualFile selectedFile) {
        Handler handler2 = new Handler(window.isFilePinned(selectedFile), selectedFile.equals(window.getSelectedFile())){

            @Override
            void setPinned(boolean value) {
                window.setFilePinned(selectedFile, value);
            }
        };
        if (handler2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/PinActiveTabAction", "createHandler"));
        }
        return handler2;
    }

    @Nullable
    private static Content getNonToolWindowContent(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "getNonToolWindowContent"));
        }
        Content result = null;
        Content[] contents = (Content[])e.getData(ViewContext.CONTENT_KEY);
        if (contents != null && contents.length == 1) {
            result = contents[0];
        }
        if (result != null && result.isPinnable()) {
            return result;
        }
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext(e.getDataContext(), true);
        Content content = result = contentManager != null ? contentManager.getSelectedContent() : null;
        if (result != null && result.isPinnable()) {
            return result;
        }
        return null;
    }

    @Nullable
    private static Content getToolWindowContent(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "getToolWindowContent"));
        }
        ToolWindow window = (ToolWindow)PlatformDataKeys.TOOL_WINDOW.getData(e.getDataContext());
        Content result = window != null ? window.getContentManager().getSelectedContent() : null;
        return result != null && result.isPinnable() ? result : null;
    }

    @Nullable
    private static VirtualFile getFileInWindow(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction", "getFileInWindow"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ide/actions/PinActiveTabAction", "getFileInWindow"));
        }
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file2 == null) {
            file2 = window.getSelectedFile();
        }
        if (file2 != null && window.isFileOpen(file2)) {
            return file2;
        }
        return null;
    }

    public static class EW
    extends PinActiveTabAction {
        @Override
        @Nullable
        protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction$EW", "getFileFromEvent"));
            }
            if (window == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ide/actions/PinActiveTabAction$EW", "getFileFromEvent"));
            }
            return window.getSelectedFile();
        }

        @Override
        protected Content getContentFromEvent(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction$EW", "getContentFromEvent"));
            }
            return null;
        }
    }

    public static class TW
    extends PinActiveTabAction {
        @Override
        @Nullable
        protected VirtualFile getFileFromEvent(@NotNull AnActionEvent e, @NotNull EditorWindow window) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction$TW", "getFileFromEvent"));
            }
            if (window == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ide/actions/PinActiveTabAction$TW", "getFileFromEvent"));
            }
            return null;
        }

        @Override
        protected Content getContentFromEvent(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PinActiveTabAction$TW", "getContentFromEvent"));
            }
            return PinActiveTabAction.getToolWindowContent(e);
        }
    }

    public static abstract class Handler {
        public final boolean isPinned;
        public final boolean isActiveTab;

        abstract void setPinned(boolean var1);

        public Handler(boolean isPinned, boolean isActiveTab) {
            this.isPinned = isPinned;
            this.isActiveTab = isActiveTab;
        }
    }
}

