/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;

public class SaveAsDirectoryBasedFormatAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null || ProjectUtil.isDirectoryBased(project2) || Messages.showOkCancelDialog((Project)project2, (String)"Project will be saved and reopened in new Directory-Based format.\nAre you sure you want to continue?", (String)"Save project to Directory-Based format", (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        VirtualFile baseDir = project2.getBaseDir();
        assert (baseDir != null);
        File ideaDir = new File(baseDir.getPath(), ".idea" + File.separatorChar);
        if (ideaDir.exists() && ideaDir.isDirectory() || SaveAsDirectoryBasedFormatAction.createDir(ideaDir)) {
            LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ideaDir);
            IProjectStore projectStore = (IProjectStore)ServiceKt.getStateStore((ComponentManager)project2);
            projectStore.clearStorages();
            projectStore.setPath(baseDir.getPath());
            project2.save();
            ProjectUtil.closeAndDispose(project2);
            ProjectUtil.openProject(baseDir.getPath(), null, false);
        } else {
            Messages.showErrorDialog((Project)project2, (String)String.format("Unable to create '.idea' directory (%s)", ideaDir), (String)"Error saving project!");
        }
    }

    private static boolean createDir(File ideaDir) {
        try {
            VfsUtil.createDirectories((String)ideaDir.getPath());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void update(AnActionEvent e) {
        Project project2 = e.getProject();
        e.getPresentation().setVisible(project2 != null && !ProjectUtil.isDirectoryBased(project2));
    }
}

