/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.AbstractFavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesRootNode;
import com.intellij.ide.favoritesTreeView.FavoritesTreeUtil;
import com.intellij.ide.favoritesTreeView.ProjectViewNodeWithChildrenList;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextArea;

public class TaskDefaultFavoriteListProvider
extends AbstractFavoritesListProvider {
    public static final String CURRENT_TASK = "Current task";

    public TaskDefaultFavoriteListProvider(Project project2) {
        super(project2, CURRENT_TASK);
    }

    @Override
    public FavoritesListNode createFavoriteListNode(Project project2) {
        return null;
    }

    @Override
    public int getWeight() {
        return 300;
    }

    public static List<AbstractTreeNode> getPathToUsualNode(AbstractTreeNode treeNode) {
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        for (AbstractTreeNode current = treeNode; current != null && !(current instanceof FavoritesRootNode); current = current.getParent()) {
            result.add(current);
        }
        Collections.reverse(result);
        return result;
    }

    public static List<AbstractTreeNode> getPathToUsualNode(AbstractTreeNode treeNode, Tree tree) {
        AbstractTreeNode parent = treeNode.getParent();
        if (parent instanceof ProjectViewNodeWithChildrenList) {
            List<AbstractTreeNode> pathToSelected = FavoritesTreeUtil.getLogicalPathToSelected(tree);
            if (pathToSelected.isEmpty()) {
                return pathToSelected;
            }
            return pathToSelected.subList(0, pathToSelected.size() - 1);
        }
        return Collections.emptyList();
    }

    private void showNotePopup(Project project2, final DnDAwareTree tree, final Consumer<String> after2, String initText) {
        final JTextArea textArea = new JTextArea(3, 50);
        textArea.setFont(UIUtil.getTreeFont());
        textArea.setText(initText);
        JBScrollPane pane = new JBScrollPane((Component)textArea);
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)pane, (JComponent)textArea).setCancelOnClickOutside(true).setAdText(KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.CTRL_ENTER.getShortcuts()) + " to finish").setTitle("Comment").setMovable(true).setRequestFocus(true).setResizable(true).setMayBeParent(true);
        final JBPopup popup = builder.createPopup();
        final JComponent content = popup.getContent();
        AnAction action = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                popup.closeOk(e.getInputEvent());
                this.unregisterCustomShortcutSet(content);
                after2.consume((Object)textArea.getText());
            }
        };
        action.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, content);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                popup.showInCenterOf((Component)((Object)tree));
            }
        }, ModalityState.NON_MODAL, project2.getDisposed());
    }
}

