/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.actions;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributesDefaults {
    private final String myDefaultName;
    private final TextRange myDefaultRange;
    private final Map<String, Pair<String, TextRange>> myNamesToValueAndRangeMap = new HashMap();
    private Properties myDefaultProperties = null;
    private boolean myFixedName;

    public AttributesDefaults(@NonNls @Nullable String defaultName, @Nullable TextRange defaultRange) {
        this.myDefaultName = defaultName;
        this.myDefaultRange = defaultRange;
    }

    public AttributesDefaults(@NonNls @Nullable String defaultName) {
        this(defaultName, null);
    }

    public AttributesDefaults() {
        this(null, null);
    }

    @Nullable
    public String getDefaultFileName() {
        return this.myDefaultName;
    }

    @Nullable
    public TextRange getDefaultFileNameSelection() {
        return this.myDefaultRange;
    }

    public void add(@NonNls @NotNull String attributeKey, @NonNls @NotNull String value, @Nullable TextRange selectionRange) {
        if (attributeKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeKey", "com/intellij/ide/fileTemplates/actions/AttributesDefaults", "add"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/fileTemplates/actions/AttributesDefaults", "add"));
        }
        this.myNamesToValueAndRangeMap.put(attributeKey, (Pair<String, TextRange>)Pair.create((Object)value, (Object)selectionRange));
    }

    public void add(@NonNls @NotNull String attributeKey, @NonNls @NotNull String value) {
        if (attributeKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeKey", "com/intellij/ide/fileTemplates/actions/AttributesDefaults", "add"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/fileTemplates/actions/AttributesDefaults", "add"));
        }
        this.add(attributeKey, value, null);
    }

    public void addPredefined(@NotNull String key, @NotNull String value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ide/fileTemplates/actions/AttributesDefaults", "addPredefined"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/fileTemplates/actions/AttributesDefaults", "addPredefined"));
        }
        if (this.myDefaultProperties == null) {
            this.myDefaultProperties = new Properties();
        }
        this.myDefaultProperties.setProperty(key, value);
    }

    public Properties getDefaultProperties() {
        return this.myDefaultProperties;
    }

    @Nullable
    public TextRange getRangeFor(@NonNls @NotNull String attributeKey) {
        if (attributeKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeKey", "com/intellij/ide/fileTemplates/actions/AttributesDefaults", "getRangeFor"));
        }
        Pair<String, TextRange> valueAndRange = this.myNamesToValueAndRangeMap.get(attributeKey);
        return valueAndRange == null ? null : (TextRange)valueAndRange.second;
    }

    @Nullable
    public String getDefaultValueFor(@NonNls @NotNull String attributeKey) {
        if (attributeKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeKey", "com/intellij/ide/fileTemplates/actions/AttributesDefaults", "getDefaultValueFor"));
        }
        Pair<String, TextRange> valueAndRange = this.myNamesToValueAndRangeMap.get(attributeKey);
        return valueAndRange == null ? null : (String)valueAndRange.first;
    }

    public boolean isFixedName() {
        return this.myFixedName;
    }

    public AttributesDefaults withFixedName(boolean fixedName) {
        this.myFixedName = fixedName;
        return this;
    }
}

