/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;

public final class FileClassMacro
extends Macro {
    @Override
    public String getName() {
        return "FileClass";
    }

    @Override
    public String getDescription() {
        return IdeBundle.message((String)"macro.class.name", (Object[])new Object[0]);
    }

    @Override
    public String expand(DataContext dataContext) {
        PsiFile javaFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (!(javaFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiClass[] classes = ((PsiJavaFile)javaFile).getClasses();
        if (classes.length == 1) {
            return classes[0].getQualifiedName();
        }
        String fileName = javaFile.getVirtualFile().getNameWithoutExtension();
        for (PsiClass aClass : classes) {
            String name = aClass.getName();
            if (!fileName.equals(name)) continue;
            return aClass.getQualifiedName();
        }
        return null;
    }
}

