/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RatesPanel
extends JPanel {
    public static int MAX_RATE = 5;
    private static final Icon STAR = AllIcons.Ide.Rating;
    private static final Icon STAR3 = AllIcons.Ide.Rating1;
    private static final Icon STAR4 = AllIcons.Ide.Rating2;
    private static final Icon STAR5 = AllIcons.Ide.Rating3;
    private static final Icon STAR6 = AllIcons.Ide.Rating4;
    private static final Icon[] STARs = new Icon[]{IconLoader.getDisabledIcon((Icon)STAR), STAR3, STAR3, STAR4, STAR4, STAR5, STAR5, STAR6, STAR6, STAR};
    private JLabel[] myLabels = new JLabel[MAX_RATE];

    public RatesPanel() {
        super(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        int myLabelsLength = this.myLabels.length;
        for (int i = 0; i < myLabelsLength; ++i) {
            this.myLabels[i] = new JLabel();
            this.myLabels[i].setOpaque(false);
            this.add((Component)this.myLabels[i], gc);
        }
    }

    public void setRate(String rating) {
        int i;
        Double dblRating = 0.0;
        if (rating != null) {
            try {
                dblRating = Double.valueOf(rating);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int intRating = dblRating.intValue();
        for (i = 0; i < intRating; ++i) {
            this.myLabels[i].setIcon(STAR);
        }
        if (intRating < MAX_RATE) {
            this.myLabels[intRating].setIcon(STARs[Double.valueOf(dblRating * 10.0).intValue() % 10]);
            for (i = 1 + intRating; i < MAX_RATE; ++i) {
                this.myLabels[i].setIcon(IconLoader.getDisabledIcon((Icon)STAR));
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return JBUI.size((int)55, (int)11);
    }
}

