/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import gnu.trove.THashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractProjectNode
extends ProjectViewNode<Project> {
    protected AbstractProjectNode(Project project2, Project value, ViewSettings viewSettings) {
        super(project2, (Object)value, viewSettings);
    }

    protected Collection<AbstractTreeNode> modulesAndGroups(Module[] modules) {
        THashMap groups = new THashMap();
        ArrayList<Module> nonGroupedModules = new ArrayList<Module>(Arrays.asList(modules));
        for (Module module2 : modules) {
            String[] path = ModuleManager.getInstance((Project)this.getProject()).getModuleGroupPath(module2);
            if (path == null) continue;
            String topLevelGroupName = path[0];
            ArrayList<Module> moduleList = (ArrayList<Module>)groups.get(topLevelGroupName);
            if (moduleList == null) {
                moduleList = new ArrayList<Module>();
                groups.put(topLevelGroupName, moduleList);
            }
            moduleList.add(module2);
            nonGroupedModules.remove(module2);
        }
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        try {
            for (String groupPath : groups.keySet()) {
                result.add(this.createModuleGroupNode(new ModuleGroup(new String[]{groupPath})));
            }
            for (Module module3 : nonGroupedModules) {
                result.add(this.createModuleGroup(module3));
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return new ArrayList<AbstractTreeNode>();
        }
        return result;
    }

    protected abstract AbstractTreeNode createModuleGroup(Module var1) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException;

    protected abstract AbstractTreeNode createModuleGroupNode(ModuleGroup var1) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException;

    public void update(PresentationData presentation) {
        presentation.setIcon(PlatformIcons.PROJECT_ICON);
        presentation.setPresentableText(this.getProject().getName());
    }

    public String getTestPresentation() {
        return "Project";
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/AbstractProjectNode", "contains"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        VirtualFile baseDir = this.getProject().getBaseDir();
        return index.isInContent(file2) || index.isInLibraryClasses(file2) || index.isInLibrarySource(file2) || baseDir != null && VfsUtil.isAncestor((VirtualFile)baseDir, (VirtualFile)file2, (boolean)false);
    }
}

