/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTreeAnchorizer
extends TreeAnchorizer {
    private static final Key<SmartPointerWrapper> PSI_ANCHORIZER_POINTER = Key.create((String)"PSI_ANCHORIZER_POINTER");

    public Object createAnchor(Object element) {
        if (element instanceof PsiElement) {
            final PsiElement psiElement = (PsiElement)element;
            return ApplicationManager.getApplication().runReadAction((Computable)new Computable<Object>(){

                public Object compute() {
                    SmartPointerWrapper pointer = (SmartPointerWrapper)psiElement.getUserData(PSI_ANCHORIZER_POINTER);
                    if (!psiElement.isValid()) {
                        return pointer != null ? pointer : psiElement;
                    }
                    if (pointer == null || pointer.myPointer.getElement() != psiElement) {
                        Project project2 = psiElement.getProject();
                        SmartPsiElementPointer psiElementPointer = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer(psiElement);
                        pointer = new SmartPointerWrapper(psiElementPointer);
                        psiElement.putUserData(PSI_ANCHORIZER_POINTER, (Object)pointer);
                    }
                    return pointer;
                }
            });
        }
        return super.createAnchor(element);
    }

    @Nullable
    public Object retrieveElement(final Object pointer) {
        if (pointer instanceof SmartPointerWrapper) {
            return ApplicationManager.getApplication().runReadAction((Computable)new Computable<Object>(){

                public Object compute() {
                    return ((SmartPointerWrapper)pointer).myPointer.getElement();
                }
            });
        }
        return super.retrieveElement(pointer);
    }

    public void freeAnchor(final Object element) {
        if (element instanceof SmartPointerWrapper) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    SmartPsiElementPointer pointer = ((SmartPointerWrapper)element).myPointer;
                    SmartPointerManager.getInstance((Project)pointer.getProject()).removePointer(pointer);
                }
            });
        }
    }

    private static class SmartPointerWrapper {
        private final SmartPsiElementPointer myPointer;

        private SmartPointerWrapper(@NotNull SmartPsiElementPointer pointer) {
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/ide/projectView/impl/nodes/PsiTreeAnchorizer$SmartPointerWrapper", "<init>"));
            }
            this.myPointer = pointer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SmartPointerWrapper)) {
                return false;
            }
            SmartPointerWrapper wrapper = (SmartPointerWrapper)o;
            return this.myPointer.equals(wrapper.myPointer);
        }

        public int hashCode() {
            return this.myPointer.hashCode();
        }
    }
}

