/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBGradientPaint;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaRadioButtonUI
extends MetalRadioButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaRadioButtonUI();
    }

    @Override
    public synchronized void paint(Graphics g2d, JComponent c) {
        Graphics2D g = (Graphics2D)g2d;
        Dimension size = c.getSize();
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        AbstractButton b = (AbstractButton)c;
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g, f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        this.paintIcon(c, g, viewRect, iconRect);
        this.drawText(b, g, text, textRect, fm);
    }

    protected void paintIcon(JComponent c, Graphics2D g, Rectangle viewRect, Rectangle iconRect) {
        Insets i = c.getInsets();
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        int rad = JBUI.scale((int)5);
        int x = iconRect.x + (rad - (rad % 2 == 1 ? 1 : 0)) / 2;
        int y = iconRect.y + (rad - (rad % 2 == 1 ? 1 : 0)) / 2;
        int w = iconRect.width - rad;
        int h = iconRect.height - rad;
        g.translate(x, y);
        JBGradientPaint ijGradient = new JBGradientPaint(c, new Color(4818404), new Color(4224201));
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        boolean focus = c.hasFocus();
        boolean selected = ((AbstractButton)c).isSelected();
        if (UIUtil.isUnderDarcula() || !selected) {
            g.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)ColorUtil.shift((Color)c.getBackground(), (double)1.5), (float)0.0f, (float)c.getHeight(), (Color)ColorUtil.shift((Color)c.getBackground(), (double)1.2)));
        } else {
            g.setPaint((Paint)ijGradient);
        }
        if (!UIUtil.isUnderDarcula() && selected) {
            GraphicsConfig fillOvalConf = new GraphicsConfig((Graphics)g);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g.fillOval(0, 1, w, h);
            fillOvalConf.restore();
        } else if (focus) {
            g.fillOval(0, JBUI.scale((int)1), w, h);
        } else {
            g.fillOval(0, JBUI.scale((int)1), w - JBUI.scale((int)1), h - JBUI.scale((int)1));
        }
        if (focus) {
            if (UIUtil.isRetina() || JBUI.isHiDPI()) {
                DarculaUIUtil.paintFocusOval(g, JBUI.scale((int)1), JBUI.scale((int)1) + 1, w - JBUI.scale((int)2), h - JBUI.scale((int)2));
            } else {
                DarculaUIUtil.paintFocusOval(g, 0, JBUI.scale((int)1), w, h);
            }
        } else if (UIUtil.isUnderDarcula()) {
            g.setPaint(UIUtil.getGradientPaint((float)(w / 2), (float)1.0f, (Color)Gray._160.withAlpha(90), (float)(w / 2), (float)h, (Color)Gray._100.withAlpha(90)));
            g.drawOval(0, JBUI.scale((int)1) + 1, w - 1, h - 1);
            g.setPaint(Gray._40.withAlpha(200));
            g.drawOval(0, JBUI.scale((int)1), w - 1, h - 1);
        } else {
            g.setPaint((Paint)(selected ? ijGradient : (c.isEnabled() ? Gray._30 : Gray._130)));
            if (!selected) {
                g.drawOval(0, JBUI.scale((int)1), w - 1, h - 1);
            }
        }
        if (selected) {
            boolean enabled = c.isEnabled();
            g.setColor(UIManager.getColor(enabled ? "RadioButton.darcula.selectionEnabledShadowColor" : "RadioButton.darcula.selectionDisabledShadowColor"));
            int yOff = 1 + JBUI.scale((int)1);
            g.fillOval(w / 2 - rad / 2, h / 2 - rad / 2 + yOff, rad, rad);
            g.setColor(UIManager.getColor(enabled ? "RadioButton.darcula.selectionEnabledColor" : "RadioButton.darcula.selectionDisabledColor"));
            g.fillOval(w / 2 - rad / 2, h / 2 - rad / 2 - 1 + yOff, rad, rad);
        }
        config.restore();
        g.translate(-x, -y);
    }

    protected void drawText(AbstractButton b, Graphics2D g, String text, Rectangle textRect, FontMetrics fm) {
        if (text != null) {
            View v = (View)b.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                int mnemIndex = b.getDisplayedMnemonicIndex();
                if (b.isEnabled()) {
                    g.setColor(b.getForeground());
                } else {
                    g.setColor(this.getDisabledTextColor());
                }
                SwingUtilities2.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    @Override
    public Icon getDefaultIcon() {
        return JBUI.emptyIcon((int)20).asUIResource();
    }
}

