/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StepSequence {
    private final List<ModuleWizardStep> myCommonSteps = new ArrayList<ModuleWizardStep>();
    private final List<Pair<ModuleWizardStep, Set<String>>> myCommonFinishingSteps = new ArrayList<Pair<ModuleWizardStep, Set<String>>>();
    private final MultiMap<String, ModuleWizardStep> mySpecificSteps = new MultiMap();
    @NonNls
    private List<String> myTypes = new ArrayList<String>();
    private List<ModuleWizardStep> mySelectedSteps;

    public StepSequence(ModuleWizardStep ... commonSteps) {
        this.myCommonSteps.addAll(Arrays.asList(commonSteps));
    }

    public void addCommonStep(@NotNull ModuleWizardStep step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/intellij/ide/util/newProjectWizard/StepSequence", "addCommonStep"));
        }
        this.myCommonSteps.add(step);
    }

    public void addCommonFinishingStep(@NotNull ModuleWizardStep step, @Nullable Set<String> suitableTypes) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/intellij/ide/util/newProjectWizard/StepSequence", "addCommonFinishingStep"));
        }
        this.myCommonFinishingSteps.add((Pair<ModuleWizardStep, Set<String>>)Pair.create((Object)step, suitableTypes));
    }

    public void addStepsForBuilder(@NotNull AbstractModuleBuilder builder, @NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/ide/util/newProjectWizard/StepSequence", "addStepsForBuilder"));
        }
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "com/intellij/ide/util/newProjectWizard/StepSequence", "addStepsForBuilder"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/ide/util/newProjectWizard/StepSequence", "addStepsForBuilder"));
        }
        String id = builder.getBuilderId();
        if (!this.mySpecificSteps.containsKey((Object)id)) {
            this.mySpecificSteps.put((Object)id, Arrays.asList(builder.createWizardSteps(wizardContext, modulesProvider)));
        }
    }

    public void addSpecificStep(String type, ModuleWizardStep step) {
        this.mySpecificSteps.putValue((Object)type, (Object)step);
    }

    public List<ModuleWizardStep> getSelectedSteps() {
        if (this.mySelectedSteps == null) {
            this.mySelectedSteps = new ArrayList<ModuleWizardStep>();
            this.mySelectedSteps.addAll(this.myCommonSteps);
            for (String string : this.myTypes) {
                Collection steps = this.mySpecificSteps.get((Object)string);
                this.mySelectedSteps.addAll(steps);
            }
            for (Pair pair : this.myCommonFinishingSteps) {
                Set types = (Set)pair.getSecond();
                if (types != null && !ContainerUtil.intersects(this.myTypes, (Collection)types)) continue;
                this.mySelectedSteps.add((ModuleWizardStep)pair.getFirst());
            }
            ContainerUtil.removeDuplicates(this.mySelectedSteps);
        }
        return this.mySelectedSteps;
    }

    @Nullable
    public ModuleWizardStep getNextStep(ModuleWizardStep step) {
        List<ModuleWizardStep> steps = this.getSelectedSteps();
        int i = steps.indexOf(step);
        return i < steps.size() - 1 ? steps.get(i + 1) : null;
    }

    @Nullable
    public ModuleWizardStep getPreviousStep(ModuleWizardStep step) {
        List<ModuleWizardStep> steps = this.getSelectedSteps();
        int i = steps.indexOf(step);
        return i > 0 ? steps.get(i - 1) : null;
    }

    public void setTypes(Collection<String> types) {
        this.myTypes.clear();
        this.myTypes.addAll(types);
        this.mySelectedSteps = null;
    }

    public void setType(@Nullable @NonNls String type) {
        this.setTypes(Collections.singletonList(type == null ? ModuleType.EMPTY.getId() : type));
    }

    public String getSelectedType() {
        return (String)ContainerUtil.getFirstItem(this.myTypes);
    }

    public List<ModuleWizardStep> getAllSteps() {
        ArrayList<ModuleWizardStep> result = new ArrayList<ModuleWizardStep>();
        result.addAll(this.myCommonSteps);
        result.addAll(this.mySpecificSteps.values());
        for (Pair<ModuleWizardStep, Set<String>> pair : this.myCommonFinishingSteps) {
            result.add((ModuleWizardStep)pair.getFirst());
        }
        ContainerUtil.removeDuplicates(result);
        return result;
    }
}

