/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources;

import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleSourceRoot
extends DetectedSourceRoot {
    private List<String> myLanguages;

    public JavaModuleSourceRoot(File directory, @Nullable String packagePrefix, @NotNull String language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ide/util/projectWizard/importSources/JavaModuleSourceRoot", "<init>"));
        }
        super(directory, packagePrefix);
        this.myLanguages = new ArrayList<String>();
        this.myLanguages.add(language);
    }

    private JavaModuleSourceRoot(File directory, String packagePrefix, List<String> languages) {
        super(directory, packagePrefix);
        this.myLanguages = languages;
    }

    @Override
    @NotNull
    public String getRootTypeName() {
        String string = StringUtil.join(this.myLanguages, (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/JavaModuleSourceRoot", "getRootTypeName"));
        }
        return string;
    }

    @Override
    public DetectedProjectRoot combineWith(@NotNull DetectedProjectRoot root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/ide/util/projectWizard/importSources/JavaModuleSourceRoot", "combineWith"));
        }
        if (root instanceof JavaModuleSourceRoot) {
            return this.combineWith((JavaModuleSourceRoot)root);
        }
        return null;
    }

    @NotNull
    public JavaModuleSourceRoot combineWith(@NotNull JavaModuleSourceRoot root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/ide/util/projectWizard/importSources/JavaModuleSourceRoot", "combineWith"));
        }
        ArrayList<String> union = new ArrayList<String>(this.myLanguages.size() + root.myLanguages.size());
        union.addAll(this.myLanguages);
        union.addAll(root.myLanguages);
        ContainerUtil.removeDuplicates(union);
        JavaModuleSourceRoot javaModuleSourceRoot = new JavaModuleSourceRoot(this.getDirectory(), this.getPackagePrefix(), union);
        if (javaModuleSourceRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/JavaModuleSourceRoot", "combineWith"));
        }
        return javaModuleSourceRoot;
    }
}

