/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources.impl;

import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.ide.util.importProject.JavaModuleInsight;
import com.intellij.ide.util.importProject.LibrariesDetectionStep;
import com.intellij.ide.util.importProject.ModulesDetectionStep;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetector;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.NullableFunction;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JavaProjectStructureDetector
extends JavaSourceRootDetector {
    @Override
    @NotNull
    protected String getLanguageName() {
        if ("Java" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/impl/JavaProjectStructureDetector", "getLanguageName"));
        }
        return "Java";
    }

    @Override
    @NotNull
    protected String getFileExtension() {
        if ("java" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/impl/JavaProjectStructureDetector", "getFileExtension"));
        }
        return "java";
    }

    @Override
    public List<ModuleWizardStep> createWizardSteps(ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, Icon stepIcon) {
        ArrayList<ModuleWizardStep> steps = new ArrayList<ModuleWizardStep>();
        JavaModuleInsight moduleInsight = new JavaModuleInsight((ProgressIndicator)new DelegatingProgressIndicator(), builder.getExistingModuleNames(), builder.getExistingProjectLibraryNames());
        steps.add(new LibrariesDetectionStep(builder, projectDescriptor, moduleInsight, stepIcon, "reference.dialogs.new.project.fromCode.page1"));
        steps.add(new ModulesDetectionStep(this, builder, projectDescriptor, moduleInsight, stepIcon, "reference.dialogs.new.project.fromCode.page2"));
        if (builder.getContext().isCreatingNewProject()) {
            steps.add(ProjectWizardStepFactory.getInstance().createProjectJdkStep(builder.getContext()));
        }
        return steps;
    }

    @Override
    @NotNull
    protected NullableFunction<CharSequence, String> getPackageNameFetcher() {
        NullableFunction<CharSequence, String> nullableFunction = new NullableFunction<CharSequence, String>(){

            public String fun(CharSequence charSequence) {
                return JavaSourceRootDetectionUtil.getPackageName(charSequence);
            }
        };
        if (nullableFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/impl/JavaProjectStructureDetector", "getPackageNameFetcher"));
        }
        return nullableFunction;
    }
}

