/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectionBasedPsiElementInternalAction<T extends PsiElement>
extends AnAction {
    @NotNull
    protected final Class<T> myClass;
    @NotNull
    protected final Class<? extends PsiFile> myFileClass;

    protected SelectionBasedPsiElementInternalAction(@NotNull Class<T> aClass, @NotNull Class<? extends PsiFile> fileClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "<init>"));
        }
        if (fileClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileClass", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "<init>"));
        }
        this.myClass = aClass;
        this.myFileClass = fileClass;
    }

    public final void actionPerformed(AnActionEvent e) {
        final Editor editor = SelectionBasedPsiElementInternalAction.getEditor(e);
        PsiFile file2 = SelectionBasedPsiElementInternalAction.getPsiFile(e);
        if (editor == null || file2 == null) {
            return;
        }
        List<T> expressions = this.getElement(editor, file2);
        PsiElement first = (PsiElement)ContainerUtil.getFirstItem(expressions);
        if (expressions.size() > 1) {
            IntroduceTargetChooser.showChooser(editor, expressions, new Pass<T>(){

                public void pass(@NotNull T expression) {
                    if (expression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/internal/SelectionBasedPsiElementInternalAction$1", "pass"));
                    }
                    SelectionBasedPsiElementInternalAction.this.performOnElement(editor, expression);
                }
            }, new Function<T, String>(){

                public String fun(@NotNull T expression) {
                    if (expression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/internal/SelectionBasedPsiElementInternalAction$2", "fun"));
                    }
                    return expression.getText();
                }
            });
        } else if (expressions.size() == 1 && first != null) {
            this.performOnElement(editor, first);
        } else if (expressions.isEmpty()) {
            this.showError(editor);
        }
    }

    protected void showError(final @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "showError"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                String errorHint = "Cannot find element of class " + SelectionBasedPsiElementInternalAction.this.myClass.getSimpleName() + " at selection/offset";
                HintManager.getInstance().showErrorHint(editor, errorHint);
            }
        });
    }

    private void performOnElement(final @NotNull Editor editor, @NotNull T first) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "performOnElement"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "performOnElement"));
        }
        TextRange textRange = first.getTextRange();
        editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
        final String informationHint = this.getInformationHint(first);
        if (informationHint != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    HintManager.getInstance().showInformationHint(editor, informationHint);
                }
            });
        } else {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    HintManager.getInstance().showErrorHint(editor, SelectionBasedPsiElementInternalAction.this.getErrorHint());
                }
            });
        }
    }

    @Nullable
    protected abstract String getInformationHint(@NotNull T var1);

    @NotNull
    protected abstract String getErrorHint();

    @NotNull
    protected List<T> getElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "getElement"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "getElement"));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            List list = ContainerUtil.list((Object[])new PsiElement[]{this.getElementFromSelection(file2, selectionModel)});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "getElement"));
            }
            return list;
        }
        List<T> list = this.getElementAtOffset(editor, file2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "getElement"));
        }
        return list;
    }

    @NotNull
    protected List<T> getElementAtOffset(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "getElementAtOffset"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "getElementAtOffset"));
        }
        List list = ContainerUtil.list((Object[])new PsiElement[]{PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)editor.getCaretModel().getOffset(), this.myClass, (boolean)false)});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "getElementAtOffset"));
        }
        return list;
    }

    @Nullable
    protected T getElementFromSelection(@NotNull PsiFile file2, @NotNull SelectionModel selectionModel) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "getElementFromSelection"));
        }
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "getElementFromSelection"));
        }
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        return (T)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)selectionStart, (int)selectionEnd, this.myClass);
    }

    public final void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        boolean enabled = ApplicationManagerEx.getApplicationEx().isInternal() && SelectionBasedPsiElementInternalAction.getEditor(e) != null && this.myFileClass.isInstance(SelectionBasedPsiElementInternalAction.getPsiFile(e));
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    @Nullable
    private static Editor getEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "getEditor"));
        }
        return (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
    }

    @Nullable
    private static PsiFile getPsiFile(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/SelectionBasedPsiElementInternalAction", "getPsiFile"));
        }
        return (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
    }
}

