/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class XmlEnclosingTagUnwrapper
implements Unwrapper {
    @Override
    public boolean isApplicableTo(PsiElement e) {
        return true;
    }

    @Override
    public void collectElementsToIgnore(PsiElement element, Set<PsiElement> result) {
    }

    @Override
    public String getDescription(PsiElement e) {
        return XmlBundle.message((String)"unwrap.enclosing.tag.name.action.name", (Object[])new Object[]{((XmlTag)e).getName()});
    }

    @Override
    public PsiElement collectAffectedElements(PsiElement element, List<PsiElement> toExtract) {
        TextRange range = element.getTextRange();
        ASTNode startTagNameEnd = XmlChildRole.START_TAG_END_FINDER.findChild(element.getNode());
        ASTNode endTagNameStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(element.getNode());
        int start = startTagNameEnd != null ? startTagNameEnd.getTextRange().getEndOffset() : range.getStartOffset();
        int end = endTagNameStart != null ? endTagNameStart.getTextRange().getStartOffset() : range.getEndOffset();
        for (PsiElement child : element.getChildren()) {
            TextRange childRange = child.getTextRange();
            if (childRange.getStartOffset() < start || childRange.getEndOffset() > end) continue;
            toExtract.add(child);
        }
        return element;
    }

    @Override
    public List<PsiElement> unwrap(Editor editor, PsiElement element) throws IncorrectOperationException {
        TextRange range = element.getTextRange();
        ASTNode startTagNameEnd = XmlChildRole.START_TAG_END_FINDER.findChild(element.getNode());
        ASTNode endTagNameStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(element.getNode());
        if (endTagNameStart != null) {
            editor.getDocument().replaceString(endTagNameStart.getTextRange().getStartOffset(), range.getEndOffset(), (CharSequence)"");
            editor.getDocument().replaceString(range.getStartOffset(), startTagNameEnd.getTextRange().getEndOffset(), (CharSequence)"");
        } else {
            editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)"");
        }
        return Collections.emptyList();
    }
}

