/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ConflictChange;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeBuilder;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeConflict;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeFragment;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeNoConflict;
import com.intellij.openapi.diff.impl.incrementalMerge.SimpleChange;
import com.intellij.openapi.diff.impl.incrementalMerge.TwoSideChange;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanel2;
import com.intellij.openapi.diff.impl.processing.DiffPolicy;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.diff.impl.util.ContextLogger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeList
implements UserDataHolder {
    private static final Logger LOG = Logger.getInstance(MergeList.class);
    public static final FragmentSide BRANCH_SIDE = FragmentSide.SIDE2;
    public static final FragmentSide BASE_SIDE = FragmentSide.SIDE1;
    public static final DataKey<MergeList> DATA_KEY = DataKey.create((String)"mergeList");
    public static final Condition<Change> NOT_CONFLICTS = new Condition<Change>(){

        public boolean value(Change change) {
            return !(change instanceof ConflictChange);
        }
    };
    @NotNull
    private final UserDataHolderBase myDataHolder;
    @NotNull
    private final ChangeList myBaseToLeftChangeList;
    @NotNull
    private final ChangeList myBaseToRightChangeList;
    @Nullable
    private final String myErrorMessage;

    private MergeList(@Nullable Project project2, @NotNull Document left, @NotNull Document base, @NotNull Document right, @Nullable String errorMessage) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "<init>"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "<init>"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "<init>"));
        }
        this.myDataHolder = new UserDataHolderBase();
        this.myBaseToLeftChangeList = new ChangeList(base, left, project2);
        this.myBaseToRightChangeList = new ChangeList(base, right, project2);
        this.myErrorMessage = errorMessage;
    }

    @NotNull
    public ChangeList getLeftChangeList() {
        ChangeList changeList = this.myBaseToLeftChangeList;
        if (changeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "getLeftChangeList"));
        }
        return changeList;
    }

    @NotNull
    public ChangeList getRightChangeList() {
        ChangeList changeList = this.myBaseToRightChangeList;
        if (changeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "getRightChangeList"));
        }
        return changeList;
    }

    @NotNull
    public static MergeList create(@Nullable Project project2, @NotNull Document left, @NotNull Document base, @NotNull Document right) {
        MergeList mergeList;
        List<Object> fragmentList;
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "create"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "create"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "create"));
        }
        String leftText = left.getText();
        String baseText = base.getText();
        String rightText = right.getText();
        Object[] data = new Object[]{"Left\n", leftText, "\nBase\n", baseText, "\nRight\n", rightText};
        ContextLogger logger = new ContextLogger(LOG, new ContextLogger.SimpleContext(data));
        try {
            fragmentList = MergeList.processText(leftText, baseText, rightText, logger);
            mergeList = new MergeList(project2, left, base, right, null);
        }
        catch (FilesTooBigForDiffException e) {
            fragmentList = Collections.emptyList();
            mergeList = new MergeList(project2, left, base, right, e.getMessage());
        }
        ArrayList<Change> leftChanges = new ArrayList<Change>();
        ArrayList<Change> rightChanges = new ArrayList<Change>();
        for (MergeFragment mergeFragment : fragmentList) {
            TwoSideChange conflict;
            TextRange rightRange;
            TextRange baseRange = mergeFragment.getBase();
            TextRange leftRange = mergeFragment.getLeft();
            if (MergeList.compareSubstring(leftText, leftRange, rightText, rightRange = mergeFragment.getRight())) {
                conflict = new MergeNoConflict(baseRange, leftRange, rightRange, mergeList);
                assert (conflict.getLeftChange() != null);
                assert (conflict.getRightChange() != null);
                leftChanges.add(conflict.getLeftChange());
                rightChanges.add(conflict.getRightChange());
                continue;
            }
            if (MergeList.compareSubstring(baseText, baseRange, leftText, leftRange)) {
                rightChanges.add(SimpleChange.fromRanges(baseRange, rightRange, mergeList.myBaseToRightChangeList));
                continue;
            }
            if (MergeList.compareSubstring(baseText, baseRange, rightText, rightRange)) {
                leftChanges.add(SimpleChange.fromRanges(baseRange, leftRange, mergeList.myBaseToLeftChangeList));
                continue;
            }
            conflict = new MergeConflict(baseRange, leftRange, rightRange, mergeList);
            assert (conflict.getLeftChange() != null);
            assert (conflict.getRightChange() != null);
            leftChanges.add(conflict.getLeftChange());
            rightChanges.add(conflict.getRightChange());
        }
        mergeList.myBaseToLeftChangeList.setChanges(leftChanges);
        mergeList.myBaseToRightChangeList.setChanges(rightChanges);
        MergeList mergeList2 = mergeList;
        if (mergeList2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "create"));
        }
        return mergeList2;
    }

    private static boolean compareSubstring(@NotNull String text1, @NotNull TextRange range1, @NotNull String text2, @NotNull TextRange range2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "compareSubstring"));
        }
        if (range1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range1", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "compareSubstring"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "compareSubstring"));
        }
        if (range2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range2", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "compareSubstring"));
        }
        if (range1.getLength() != range2.getLength()) {
            return false;
        }
        int index1 = range1.getStartOffset();
        int index2 = range2.getStartOffset();
        while (index1 < range1.getEndOffset()) {
            if (text1.charAt(index1) != text2.charAt(index2)) {
                return false;
            }
            ++index1;
            ++index2;
        }
        return true;
    }

    @NotNull
    private static List<MergeFragment> processText(@NotNull String leftText, @NotNull String baseText, @NotNull String rightText, @NotNull ContextLogger logger) throws FilesTooBigForDiffException {
        if (leftText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftText", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "processText"));
        }
        if (baseText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseText", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "processText"));
        }
        if (rightText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightText", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "processText"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "processText"));
        }
        DiffFragment[] leftFragments = DiffPolicy.DEFAULT_LINES.buildFragments(DiffString.create((String)baseText), DiffString.create((String)leftText));
        DiffFragment[] rightFragments = DiffPolicy.DEFAULT_LINES.buildFragments(DiffString.create((String)baseText), DiffString.create((String)rightText));
        int[] leftOffsets = new int[]{0, 0};
        int[] rightOffsets = new int[]{0, 0};
        int leftIndex = 0;
        int rightIndex = 0;
        MergeBuilder builder = new MergeBuilder(logger);
        while (leftIndex < leftFragments.length || rightIndex < rightFragments.length) {
            FragmentSide side;
            TextRange[] equalRanges = new TextRange[2];
            if (leftOffsets[0] < rightOffsets[0] && leftIndex < leftFragments.length) {
                side = FragmentSide.SIDE1;
                MergeList.getEqualRanges(leftFragments[leftIndex], leftOffsets, equalRanges);
                ++leftIndex;
            } else {
                if (rightIndex >= rightFragments.length) break;
                side = FragmentSide.SIDE2;
                MergeList.getEqualRanges(rightFragments[rightIndex], rightOffsets, equalRanges);
                ++rightIndex;
            }
            if (equalRanges[0] != null && equalRanges[1] != null) {
                builder.add(equalRanges[0], equalRanges[1], side);
                continue;
            }
            logger.assertTrue(equalRanges[0] == null && equalRanges[1] == null);
        }
        List<MergeFragment> list = builder.finish(leftText.length(), baseText.length(), rightText.length());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "processText"));
        }
        return list;
    }

    private static void getEqualRanges(@NotNull DiffFragment fragment, @NotNull int[] leftOffsets, @NotNull TextRange[] equalRanges) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "getEqualRanges"));
        }
        if (leftOffsets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftOffsets", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "getEqualRanges"));
        }
        if (equalRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equalRanges", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "getEqualRanges"));
        }
        int baseLength = MergeList.getTextLength(fragment.getText1());
        int versionLength = MergeList.getTextLength(fragment.getText2());
        if (fragment.isEqual()) {
            equalRanges[0] = new TextRange(leftOffsets[0], leftOffsets[0] + baseLength);
            equalRanges[1] = new TextRange(leftOffsets[1], leftOffsets[1] + versionLength);
        } else {
            equalRanges[0] = null;
            equalRanges[1] = null;
        }
        leftOffsets[0] = leftOffsets[0] + baseLength;
        leftOffsets[1] = leftOffsets[1] + versionLength;
    }

    private static int getTextLength(@Nullable DiffString text1) {
        return text1 != null ? text1.length() : 0;
    }

    public static MergeList create(@NotNull DiffRequest data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "create"));
        }
        DiffContent[] contents = data.getContents();
        return MergeList.create(data.getProject(), contents[0].getDocument(), contents[1].getDocument(), contents[2].getDocument());
    }

    public void setMarkups(Editor left, Editor base, Editor right) {
        this.myBaseToLeftChangeList.setMarkup(base, left);
        this.myBaseToRightChangeList.setMarkup(base, right);
        this.addActions(FragmentSide.SIDE1);
        this.addActions(FragmentSide.SIDE2);
    }

    public Iterator<Change> getAllChanges() {
        return ContainerUtil.concatIterators((Iterator[])new Iterator[]{this.myBaseToLeftChangeList.getChanges().iterator(), this.myBaseToRightChangeList.getChanges().iterator()});
    }

    public void addListener(ChangeList.Listener listener2) {
        this.myBaseToLeftChangeList.addListener(listener2);
        this.myBaseToRightChangeList.addListener(listener2);
    }

    public void removeListener(ChangeList.Listener listener2) {
        this.myBaseToLeftChangeList.removeListener(listener2);
        this.myBaseToRightChangeList.removeListener(listener2);
    }

    private void addActions(@NotNull FragmentSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "addActions"));
        }
        ChangeList changeList = this.getChanges(side);
        FragmentSide originalSide = BRANCH_SIDE;
        for (int i = 0; i < changeList.getCount(); ++i) {
            final Change change = changeList.getChange(i);
            if (!change.canHasActions(originalSide)) continue;
            Icon arrowIcon = side == FragmentSide.SIDE1 ? AllIcons.Diff.ArrowRight : AllIcons.Diff.Arrow;
            DumbAwareAction applyAction = new DumbAwareAction(DiffBundle.message((String)"merge.dialog.apply.change.action.name", (Object[])new Object[0]), null, arrowIcon){

                public void actionPerformed(@Nullable AnActionEvent e) {
                    MergeList.apply(change);
                }
            };
            DumbAwareAction ignoreAction = new DumbAwareAction(DiffBundle.message((String)"merge.dialog.ignore.change.action.name", (Object[])new Object[0]), null, AllIcons.Diff.Remove){

                public void actionPerformed(@Nullable AnActionEvent e) {
                    change.removeFromList();
                }
            };
            change.getChangeSide(originalSide).getHighlighterHolder().setActions(new AnAction[]{applyAction, ignoreAction});
        }
    }

    private static void apply(Change change) {
        Change.apply(change, BRANCH_SIDE);
    }

    @NotNull
    public ChangeList getChanges(@NotNull FragmentSide changesSide) {
        if (changesSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changesSide", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "getChanges"));
        }
        if (changesSide == FragmentSide.SIDE1) {
            ChangeList changeList = this.myBaseToLeftChangeList;
            if (changeList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "getChanges"));
            }
            return changeList;
        }
        ChangeList changeList = this.myBaseToRightChangeList;
        if (changeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "getChanges"));
        }
        return changeList;
    }

    public void removeChanges(@Nullable Change leftChange, @Nullable Change rightChange) {
        if (leftChange != null) {
            this.myBaseToLeftChangeList.remove(leftChange);
        }
        if (rightChange != null) {
            this.myBaseToRightChangeList.remove(rightChange);
        }
    }

    public Document getBaseDocument() {
        Document document = this.myBaseToLeftChangeList.getDocument(BASE_SIDE);
        LOG.assertTrue(document == this.myBaseToRightChangeList.getDocument(BASE_SIDE));
        return document;
    }

    @Nullable
    public static MergeList fromDataContext(DataContext dataContext) {
        MergeList mergeList = (MergeList)DATA_KEY.getData(dataContext);
        if (mergeList != null) {
            return mergeList;
        }
        MergePanel2 mergePanel = MergePanel2.fromDataContext(dataContext);
        return mergePanel == null ? null : mergePanel.getMergeList();
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "getUserData"));
        }
        return (T)this.myDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "putUserData"));
        }
        this.myDataHolder.putUserData(key, value);
    }

    @NotNull
    public FragmentSide getSideOf(@NotNull ChangeList source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "getSideOf"));
        }
        if (this.myBaseToLeftChangeList == source) {
            FragmentSide fragmentSide = FragmentSide.SIDE1;
            if (fragmentSide == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "getSideOf"));
            }
            return fragmentSide;
        }
        FragmentSide fragmentSide = FragmentSide.SIDE2;
        if (fragmentSide == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList", "getSideOf"));
        }
        return fragmentSide;
    }

    public void updateMarkup() {
        this.myBaseToLeftChangeList.updateMarkup();
        this.myBaseToRightChangeList.updateMarkup();
    }

    @Nullable
    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    public void startBulkUpdate() {
        Document document1 = this.myBaseToLeftChangeList.getDocument(BRANCH_SIDE);
        Document document2 = this.myBaseToRightChangeList.getDocument(BRANCH_SIDE);
        Document document3 = this.myBaseToLeftChangeList.getDocument(BASE_SIDE);
        assert (document3 == this.myBaseToRightChangeList.getDocument(BASE_SIDE));
        ((DocumentEx)document1).setInBulkUpdate(true);
        ((DocumentEx)document2).setInBulkUpdate(true);
        ((DocumentEx)document3).setInBulkUpdate(true);
    }

    public void finishBulkUpdate() {
        Document document1 = this.myBaseToLeftChangeList.getDocument(BRANCH_SIDE);
        Document document2 = this.myBaseToRightChangeList.getDocument(BRANCH_SIDE);
        Document document3 = this.myBaseToLeftChangeList.getDocument(BASE_SIDE);
        assert (document3 == this.myBaseToRightChangeList.getDocument(BASE_SIDE));
        ((DocumentEx)document1).setInBulkUpdate(false);
        ((DocumentEx)document2).setInBulkUpdate(false);
        ((DocumentEx)document3).setInBulkUpdate(false);
    }
}

