/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.IndentStrategy;
import com.intellij.openapi.editor.LanguageIndentStrategy;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentSelectionAction
extends EditorAction {
    public IndentSelectionAction() {
        super((EditorActionHandler)new Handler());
    }

    public void update(Editor editor, Presentation presentation, DataContext dataContext) {
        presentation.setEnabled(IndentSelectionAction.originalIsEnabled(editor, true));
    }

    public void updateForKeyboardAccess(Editor editor, Presentation presentation, DataContext dataContext) {
        presentation.setEnabled(this.isEnabled(editor, dataContext));
    }

    protected boolean isEnabled(Editor editor, DataContext dataContext) {
        return IndentSelectionAction.originalIsEnabled(editor, true);
    }

    protected static boolean originalIsEnabled(Editor editor, boolean wantSelection) {
        return (!wantSelection || IndentSelectionAction.hasSuitableSelection(editor)) && !editor.isOneLineMode();
    }

    private static boolean hasSuitableSelection(Editor editor) {
        if (!editor.getSelectionModel().hasSelection()) {
            return false;
        }
        Document document = editor.getDocument();
        int selectionStart = editor.getSelectionModel().getSelectionStart();
        int selectionEnd = editor.getSelectionModel().getSelectionEnd();
        return !CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)document.getCharsSequence().subSequence(selectionStart, selectionEnd));
    }

    private static void indentSelection(Editor editor, Project project2) {
        int endIndex;
        Document document;
        int startIndex;
        int oldSelectionStart = editor.getSelectionModel().getSelectionStart();
        int oldSelectionEnd = editor.getSelectionModel().getSelectionEnd();
        if (!editor.getSelectionModel().hasSelection()) {
            oldSelectionEnd = oldSelectionStart = editor.getCaretModel().getOffset();
        }
        if ((startIndex = (document = editor.getDocument()).getLineNumber(oldSelectionStart)) == -1) {
            startIndex = document.getLineCount() - 1;
        }
        if ((endIndex = document.getLineNumber(oldSelectionEnd)) > 0 && document.getLineStartOffset(endIndex) == oldSelectionEnd && editor.getSelectionModel().hasSelection()) {
            --endIndex;
        }
        if (endIndex == -1) {
            endIndex = document.getLineCount() - 1;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        int blockIndent = CodeStyleSettingsManager.getSettings((Project)project2).getIndentOptionsByFile((PsiFile)file2).INDENT_SIZE;
        IndentSelectionAction.doIndent(endIndex, startIndex, document, project2, editor, blockIndent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doIndent(int endIndex, int startIndex, Document document, Project project2, Editor editor, int blockIndent) {
        boolean bulkMode;
        int caretOffset = editor.getCaretModel().getOffset();
        boolean bl = bulkMode = endIndex - startIndex > 50;
        if (bulkMode) {
            ((DocumentEx)document).setInBulkUpdate(true);
        }
        try {
            PsiFile file2;
            IndentStrategy indentStrategy;
            ArrayList<Integer> nonModifiableLines = new ArrayList<Integer>();
            if (project2 != null && !LanguageIndentStrategy.isDefault((IndentStrategy)(indentStrategy = LanguageIndentStrategy.getIndentStrategy((PsiFile)(file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document)))))) {
                for (int i = startIndex; i <= endIndex; ++i) {
                    if (IndentSelectionAction.canIndent(document, file2, i, indentStrategy)) continue;
                    nonModifiableLines.add(i);
                }
            }
            for (int i = startIndex; i <= endIndex; ++i) {
                if (nonModifiableLines.contains(i)) continue;
                caretOffset = EditorActionUtil.indentLine(project2, editor, i, blockIndent, caretOffset);
            }
        }
        finally {
            if (bulkMode) {
                ((DocumentEx)document).setInBulkUpdate(false);
            }
        }
        editor.getCaretModel().moveToOffset(caretOffset);
    }

    static boolean canIndent(Document document, PsiFile file2, int line, @NotNull IndentStrategy indentStrategy) {
        PsiElement element;
        if (indentStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentStrategy", "com/intellij/openapi/editor/actions/IndentSelectionAction", "canIndent"));
        }
        int offset = document.getLineStartOffset(line);
        if (file2 != null && (element = file2.findElementAt(offset)) != null) {
            return indentStrategy.canIndent(element);
        }
        return true;
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (this.isEnabled(editor, caret, dataContext)) {
                IndentSelectionAction.indentSelection(editor, project2);
            }
        }
    }
}

