/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.ex.util.SegmentArray;
import org.jetbrains.annotations.NotNull;

public class SegmentArrayWithData
extends SegmentArray {
    private short[] myData = new short[64];

    public void setElementAt(int i, int startOffset, int endOffset, int data) {
        SegmentArrayWithData.dataRangeCheck(data);
        this.setElementAt(i, startOffset, endOffset);
        this.myData = SegmentArrayWithData.reallocateArray(this.myData, i + 1);
        this.myData[i] = (short)data;
    }

    private static void dataRangeCheck(int data) {
        if (data < Short.MIN_VALUE || data > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("data out of short range: " + data);
        }
    }

    @Override
    public void remove(int startIndex, int endIndex) {
        this.myData = this.remove(this.myData, startIndex, endIndex);
        super.remove(startIndex, endIndex);
    }

    public void replace(int startIndex, int endIndex, @NotNull SegmentArrayWithData newData) {
        if (newData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newData", "com/intellij/openapi/editor/ex/util/SegmentArrayWithData", "replace"));
        }
        int oldLen = endIndex - startIndex;
        int newLen = newData.getSegmentCount();
        int delta = newLen - oldLen;
        if (delta < 0) {
            this.remove(endIndex + delta, endIndex);
        } else if (delta > 0) {
            SegmentArrayWithData deltaData = new SegmentArrayWithData();
            for (int i = oldLen; i < newLen; ++i) {
                deltaData.setElementAt(i - oldLen, newData.getSegmentStart(i), newData.getSegmentEnd(i), newData.getSegmentData(i));
            }
            this.insert(deltaData, startIndex + oldLen);
        }
        int common = Math.min(newLen, oldLen);
        this.replace(startIndex, newData, common);
    }

    protected void replace(int startOffset, @NotNull SegmentArrayWithData data, int len) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/editor/ex/util/SegmentArrayWithData", "replace"));
        }
        System.arraycopy(data.myData, 0, this.myData, startOffset, len);
        super.replace(startOffset, data, len);
    }

    public void insert(@NotNull SegmentArrayWithData segmentArray, int startIndex) {
        if (segmentArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentArray", "com/intellij/openapi/editor/ex/util/SegmentArrayWithData", "insert"));
        }
        this.myData = this.insert(this.myData, segmentArray.myData, startIndex, segmentArray.getSegmentCount());
        super.insert(segmentArray, startIndex);
    }

    @NotNull
    private short[] insert(@NotNull short[] array, @NotNull short[] insertArray, int startIndex, int insertLength) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/openapi/editor/ex/util/SegmentArrayWithData", "insert"));
        }
        if (insertArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertArray", "com/intellij/openapi/editor/ex/util/SegmentArrayWithData", "insert"));
        }
        short[] newArray = SegmentArrayWithData.reallocateArray(array, this.mySegmentCount + insertLength);
        if (startIndex < this.mySegmentCount) {
            System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
        }
        System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
        if (newArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/SegmentArrayWithData", "insert"));
        }
        return newArray;
    }

    @NotNull
    private short[] remove(@NotNull short[] array, int startIndex, int endIndex) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/openapi/editor/ex/util/SegmentArrayWithData", "remove"));
        }
        if (endIndex < this.mySegmentCount) {
            System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
        }
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/SegmentArrayWithData", "remove"));
        }
        return array;
    }

    public short getSegmentData(int index) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong index: " + index);
        }
        return this.myData[index];
    }

    public void setSegmentData(int index, int data) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong index: " + index);
        }
        SegmentArrayWithData.dataRangeCheck(data);
        this.myData[index] = (short)data;
    }

    @NotNull
    private static short[] reallocateArray(@NotNull short[] array, int index) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/openapi/editor/ex/util/SegmentArrayWithData", "reallocateArray"));
        }
        if (index < array.length) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/SegmentArrayWithData", "reallocateArray"));
            }
            return array;
        }
        short[] newArray = new short[SegmentArrayWithData.calcCapacity(array.length, index)];
        System.arraycopy(array, 0, newArray, 0, array.length);
        if (newArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/SegmentArrayWithData", "reallocateArray"));
        }
        return newArray;
    }
}

