/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.ClipDetector;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.RangeIterator;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import gnu.trove.Equality;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;

public class BorderEffect {
    private final Graphics myGraphics;
    private final int myStartOffset;
    private final int myEndOffset;
    private final TextRange myRange;
    private final EditorImpl myEditor;
    private final ClipDetector myClipDetector;
    private static final Equality<TextAttributes> SAME_COLOR_BOXES = new Equality<TextAttributes>(){

        public boolean equals(TextAttributes attributes1, TextAttributes attributes2) {
            Color effectColor = attributes1.getEffectColor();
            EffectType effectType = attributes1.getEffectType();
            return effectColor != null && effectColor.equals(attributes2.getEffectColor()) && (EffectType.BOXED == effectType || EffectType.ROUNDED_BOX == effectType) && effectType == attributes2.getEffectType();
        }
    };
    private static final Condition<TextAttributes> BOX_FILTER = new Condition<TextAttributes>(){

        public boolean value(TextAttributes attributes) {
            return BorderEffect.isBorder(attributes);
        }
    };

    public BorderEffect(EditorImpl editor, Graphics graphics, int clipStartOffset, int clipEndOffset) {
        this.myEditor = editor;
        this.myGraphics = graphics;
        this.myStartOffset = clipStartOffset;
        this.myEndOffset = clipEndOffset;
        this.myRange = new TextRange(this.myStartOffset, this.myEndOffset);
        this.myClipDetector = new ClipDetector(editor, graphics.getClipBounds());
    }

    private static boolean isBorder(TextAttributes textAttributes) {
        return textAttributes != null && textAttributes.getEffectColor() != null && (EffectType.BOXED == textAttributes.getEffectType() || EffectType.ROUNDED_BOX == textAttributes.getEffectType());
    }

    private void paintBorder(RangeHighlighterEx rangeHighlighter, TextAttributes textAttributes) {
        this.paintBorder(textAttributes.getEffectColor(), rangeHighlighter.getAffectedAreaStartOffset(), rangeHighlighter.getAffectedAreaEndOffset(), textAttributes.getEffectType());
    }

    private void paintBorder(Color color, int startOffset, int endOffset, EffectType effectType) {
        this.paintBorder(this.myGraphics, this.myEditor, startOffset, endOffset, color, effectType);
    }

    public void paintHighlighters(MarkupModelEx markupModel) {
        markupModel.processRangeHighlightersOverlappingWith(this.myStartOffset, this.myEndOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx rangeHighlighter) {
                TextAttributes textAttributes = rangeHighlighter.getTextAttributes();
                if (BorderEffect.isBorder(textAttributes)) {
                    BorderEffect.this.paintBorder(rangeHighlighter, textAttributes);
                }
                return true;
            }
        });
    }

    public void paintHighlighters(EditorHighlighter highlighter) {
        int startOffset = this.startOfLineByOffset(this.myStartOffset);
        if (startOffset < 0 || startOffset >= this.myEditor.getDocument().getTextLength()) {
            return;
        }
        RangeIterator iterator = new RangeIterator(new FoldingOrNewLineGaps(this.myEditor), SAME_COLOR_BOXES, highlighter.createIterator(startOffset), BOX_FILTER);
        iterator.init(this.myRange);
        while (!iterator.atEnd()) {
            iterator.advance();
            this.paintBorder(this.myGraphics, this.myEditor, iterator.getStart(), iterator.getEnd(), iterator.getTextAttributes().getEffectColor(), iterator.getTextAttributes().getEffectType());
        }
    }

    private int startOfLineByOffset(int offset) {
        int line = this.myEditor.offsetToLogicalLine(offset);
        if (line >= this.myEditor.getDocument().getLineCount()) {
            return -1;
        }
        return this.myEditor.getDocument().getLineStartOffset(line);
    }

    private void paintBorder(Graphics g, EditorImpl editor, int startOffset, int endOffset, Color color, EffectType effectType) {
        Color savedColor = g.getColor();
        g.setColor(color);
        this.paintBorder(g, editor, startOffset, endOffset, effectType);
        g.setColor(savedColor);
    }

    private void paintBorder(Graphics g, EditorImpl editor, int startOffset, int endOffset, EffectType effectType) {
        if (!this.myClipDetector.rangeCanBeVisible(startOffset, endOffset)) {
            return;
        }
        Point startPoint = BorderEffect.offsetToXY(editor, startOffset);
        Point endPoint = BorderEffect.offsetToXY(editor, endOffset);
        int height = endPoint.y - startPoint.y;
        int startX = startPoint.x;
        int startY = startPoint.y;
        int endX = endPoint.x;
        int lineHeight = editor.getLineHeight();
        if (height == 0) {
            int width;
            int n = width = endX == startX ? 1 : endX - startX - 1;
            if (effectType == EffectType.ROUNDED_BOX) {
                UIUtil.drawRectPickedOut((Graphics2D)((Graphics2D)g), (int)startX, (int)startY, (int)width, (int)(lineHeight - 1));
            } else {
                g.drawRect(startX, startY, width, lineHeight - 1);
            }
            return;
        }
        int startLine = editor.offsetToVisualLine(startOffset);
        int endLine = editor.offsetToVisualLine(endOffset);
        int maxWidth = Math.max(endX, editor.getMaxWidthInVisualLineRange(startLine, endLine - 1, false));
        BorderGraphics border = new BorderGraphics(g, startX, startY, effectType);
        border.horizontalTo(maxWidth);
        border.verticalRel(height - 1);
        border.horizontalTo(endX);
        if (endX > 0) {
            border.verticalRel(lineHeight);
            border.horizontalTo(0);
            border.verticalRel(-height + 1);
        } else if (height > lineHeight) {
            border.verticalRel(-height + lineHeight + 1);
        }
        border.horizontalTo(startX);
        border.verticalTo(startY);
    }

    private static Point offsetToXY(EditorImpl editor, int offset) {
        return editor.logicalPositionToXY(editor.offsetToLogicalPosition(offset));
    }

    public static void paintFoldedEffect(Graphics g, int foldingXStart, int y, int foldingXEnd, int lineHeight, Color effectColor, EffectType effectType) {
        if (effectColor == null || effectType != EffectType.BOXED) {
            return;
        }
        g.setColor(effectColor);
        g.drawRect(foldingXStart, y, foldingXEnd - foldingXStart, lineHeight - 1);
    }

    public static class BorderGraphics {
        private final Graphics myGraphics;
        private int myX;
        private int myY;
        private EffectType myEffectType;

        public BorderGraphics(Graphics graphics, int startX, int stIntY, EffectType effectType) {
            this.myGraphics = graphics;
            this.myX = startX;
            this.myY = stIntY;
            this.myEffectType = effectType;
        }

        public void horizontalTo(int x) {
            this.lineTo(x, this.myY);
        }

        public void horizontalRel(int width) {
            this.lineTo(this.myX + width, this.myY);
        }

        private void lineTo(int x, int y) {
            if (this.myEffectType == EffectType.ROUNDED_BOX) {
                UIUtil.drawLinePickedOut((Graphics)this.myGraphics, (int)this.myX, (int)this.myY, (int)x, (int)y);
            } else {
                UIUtil.drawLine((Graphics)this.myGraphics, (int)this.myX, (int)this.myY, (int)x, (int)y);
            }
            this.myX = x;
            this.myY = y;
        }

        public void verticalRel(int height) {
            this.lineTo(this.myX, this.myY + height);
        }

        public void verticalTo(int y) {
            this.lineTo(this.myX, y);
        }
    }

    private static class FoldingOrNewLineGaps
    implements RangeIterator.Gaps {
        private final RangeIterator.FoldingGaps myFoldingGaps;
        private final CharSequence myChars;

        public FoldingOrNewLineGaps(CharSequence chars, RangeIterator.FoldingGaps foldingGaps) {
            this.myChars = chars;
            this.myFoldingGaps = foldingGaps;
        }

        public FoldingOrNewLineGaps(EditorImpl editor) {
            this(editor.getDocument().getCharsSequence(), new RangeIterator.FoldingGaps(editor.getFoldingModel()));
        }

        @Override
        public boolean isGapAt(int offset) {
            return this.myChars.charAt(offset) == '\n' || this.myFoldingGaps.isGapAt(offset);
        }
    }
}

