/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.Patches;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntHashSet;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontInfo {
    private static final Logger LOG = Logger.getInstance(FontInfo.class);
    private static final boolean USE_ALTERNATIVE_CAN_DISPLAY_PROCEDURE = SystemInfo.isAppleJvm && Registry.is((String)"ide.mac.fix.font.fallback");
    private static final FontRenderContext DUMMY_CONTEXT = new FontRenderContext(null, false, false);
    private final TIntHashSet mySymbolsToBreakDrawingIteration = new TIntHashSet();
    private final Font myFont;
    private final int mySize;
    @JdkConstants.FontStyle
    private final int myStyle;
    private final boolean myUseLigatures;
    private final TIntHashSet mySafeCharacters = new TIntHashSet();
    private FontMetrics myFontMetrics = null;
    private boolean myHasGlyphsToBreakDrawingIteration;
    private boolean myCheckedForProblemGlyphs;
    private static final Comparator<File> BY_NAME = new Comparator<File>(){

        @Override
        public int compare(File file1, File file2) {
            return file1.getName().compareTo(file2.getName());
        }
    };

    public FontInfo(String familyName, int size, @JdkConstants.FontStyle int style) {
        this(familyName, size, style, false);
    }

    public FontInfo(String familyName, int size, @JdkConstants.FontStyle int style, boolean useLigatures) {
        this(familyName, size, style, style, useLigatures);
    }

    FontInfo(String familyName, int size, @JdkConstants.FontStyle int style, @JdkConstants.FontStyle int realStyle, boolean useLigatures) {
        this.mySize = size;
        this.myStyle = style;
        this.myUseLigatures = useLigatures;
        Font font = new Font(familyName, style, size);
        this.myFont = useLigatures ? FontInfo.getFontWithLigaturesEnabled(font, realStyle) : font;
    }

    @NotNull
    private static Font getFontWithLigaturesEnabled(Font font, @JdkConstants.FontStyle int fontStyle) {
        if (Patches.JDK_BUG_ID_7162125) {
            String familyName = font.getFamily();
            File fontFile = FontInfo.findFileForFont(familyName, fontStyle);
            if (fontFile == null) {
                LOG.info(font + "(style=" + fontStyle + ") not located");
                Font font2 = font;
                if (font2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FontInfo", "getFontWithLigaturesEnabled"));
                }
                return font2;
            }
            LOG.info(font + "(style=" + fontStyle + ") located at " + fontFile);
            try {
                font = Font.createFont(0, fontFile).deriveFont(fontStyle, font.getSize());
            }
            catch (Exception e) {
                LOG.warn("Couldn't load font", (Throwable)e);
                Font font3 = font;
                if (font3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FontInfo", "getFontWithLigaturesEnabled"));
                }
                return font3;
            }
        }
        Font font4 = font.deriveFont(Collections.singletonMap(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON));
        if (font4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FontInfo", "getFontWithLigaturesEnabled"));
        }
        return font4;
    }

    @Nullable
    private static File findFileForFont(@NotNull String familyName, int style) {
        if (familyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyName", "com/intellij/openapi/editor/impl/FontInfo", "findFileForFont"));
        }
        File fontFile = FontInfo.doFindFileForFont(familyName, style);
        if (fontFile == null && style != 0) {
            fontFile = FontInfo.doFindFileForFont(familyName, 0);
        }
        if (fontFile == null) {
            fontFile = FontInfo.doFindFileForFont(familyName, -1);
        }
        return fontFile;
    }

    @Nullable
    private static File doFindFileForFont(@NotNull String familyName, final int style) {
        List regulars;
        File[] localFiles;
        if (familyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyName", "com/intellij/openapi/editor/impl/FontInfo", "doFindFileForFont"));
        }
        final String normalizedFamilyName = familyName.toLowerCase(Locale.getDefault()).replace(" ", "");
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File file2, String name) {
                String normalizedName = name.toLowerCase(Locale.getDefault());
                return !(!normalizedName.startsWith(normalizedFamilyName) || !normalizedName.endsWith(".otf") && !normalizedName.endsWith(".ttf") || style != -1 && style != FontInfo.getFontStyle(normalizedName));
            }
        };
        ArrayList<File> files = new ArrayList<File>();
        File[] userFiles = new File(System.getProperty("user.home"), "Library/Fonts").listFiles(filter);
        if (userFiles != null) {
            files.addAll(Arrays.asList(userFiles));
        }
        if ((localFiles = new File("/Library/Fonts").listFiles(filter)) != null) {
            files.addAll(Arrays.asList(localFiles));
        }
        if (files.isEmpty()) {
            return null;
        }
        if (style == 0 && !(regulars = ContainerUtil.filter(files, (Condition)new Condition<File>(){

            public boolean value(File file2) {
                return file2.getName().toLowerCase(Locale.getDefault()).contains("regular");
            }
        })).isEmpty()) {
            return Collections.min(regulars, BY_NAME);
        }
        return Collections.min(files, BY_NAME);
    }

    private static int getFontStyle(@NotNull String fontFileNameLowercase) {
        if (fontFileNameLowercase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFileNameLowercase", "com/intellij/openapi/editor/impl/FontInfo", "getFontStyle"));
        }
        String baseName = fontFileNameLowercase.substring(0, fontFileNameLowercase.length() - 4);
        if (baseName.endsWith("-it")) {
            return 2;
        }
        if (baseName.endsWith("-boldit")) {
            return 3;
        }
        return ComplementaryFontsRegistry.getFontStyle(fontFileNameLowercase);
    }

    private void parseProblemGlyphs() {
        this.myCheckedForProblemGlyphs = true;
        BufferedImage buffer = UIUtil.createImage((int)20, (int)20, (int)1);
        Graphics graphics = buffer.getGraphics();
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        FontRenderContext context = ((Graphics2D)graphics).getFontRenderContext();
        char[] charBuffer = new char[1];
        for (char c = '\u0000'; c < '\u0080'; c = (char)(c + '\u0001')) {
            if (!this.myFont.canDisplay(c)) continue;
            charBuffer[0] = c;
            GlyphVector vector = this.myFont.createGlyphVector(context, charBuffer);
            float y = vector.getGlyphMetrics(0).getAdvanceY();
            if (Math.round(y) == 0) continue;
            this.mySymbolsToBreakDrawingIteration.add((int)c);
        }
        this.myHasGlyphsToBreakDrawingIteration = !this.mySymbolsToBreakDrawingIteration.isEmpty();
    }

    public boolean hasGlyphsToBreakDrawingIteration() {
        if (!this.myCheckedForProblemGlyphs) {
            this.parseProblemGlyphs();
        }
        return this.myHasGlyphsToBreakDrawingIteration;
    }

    @NotNull
    public TIntHashSet getSymbolsToBreakDrawingIteration() {
        if (!this.myCheckedForProblemGlyphs) {
            this.parseProblemGlyphs();
        }
        TIntHashSet tIntHashSet = this.mySymbolsToBreakDrawingIteration;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FontInfo", "getSymbolsToBreakDrawingIteration"));
        }
        return tIntHashSet;
    }

    public boolean canDisplay(int codePoint) {
        try {
            if (codePoint < 128) {
                return true;
            }
            if (this.mySafeCharacters.contains(codePoint)) {
                return true;
            }
            if (this.canDisplayImpl(codePoint)) {
                this.mySafeCharacters.add(codePoint);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean canDisplayImpl(int codePoint) {
        if (!Character.isValidCodePoint(codePoint)) {
            return false;
        }
        if (USE_ALTERNATIVE_CAN_DISPLAY_PROCEDURE) {
            return this.myFont.createGlyphVector(DUMMY_CONTEXT, new String(new int[]{codePoint}, 0, 1)).getGlyphCode(0) > 0;
        }
        return this.myFont.canDisplay(codePoint);
    }

    public Font getFont() {
        return this.myFont;
    }

    public int charWidth(char c) {
        FontMetrics metrics = this.fontMetrics();
        return FontLayoutService.getInstance().charWidth(metrics, c);
    }

    private FontMetrics fontMetrics() {
        if (this.myFontMetrics == null) {
            Graphics2D graphics = FontInfo.createReferenceGraphics();
            graphics.setFont(this.myFont);
            this.myFontMetrics = graphics.getFontMetrics();
        }
        return this.myFontMetrics;
    }

    public static Graphics2D createReferenceGraphics() {
        Graphics2D graphics = (Graphics2D)UIUtil.createImage((int)1, (int)1, (int)1).getGraphics();
        EditorUIUtil.setupAntialiasing(graphics);
        return graphics;
    }

    void reset() {
        this.myFontMetrics = null;
    }

    public int getSize() {
        return this.mySize;
    }

    @JdkConstants.FontStyle
    public int getStyle() {
        return this.myStyle;
    }

    public boolean areLigaturesEnabled() {
        return this.myUseLigatures;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontInfo fontInfo = (FontInfo)o;
        return this.myFont.equals(fontInfo.myFont);
    }

    public int hashCode() {
        return this.myFont.hashCode();
    }
}

