/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import gnu.trove.Equality;

class RangeIterator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.RangeIterator");
    private static final int NO_NEXT = -1;
    private int myRangeEnd;
    private final HighlighterIterator mySource;
    private final Equality<TextAttributes> myEquality;
    private final Gaps myGaps;
    private final Condition<TextAttributes> myFilter;
    private boolean mySourceOutOfRange = false;
    private int myStart;
    private int myEnd;
    private TextAttributes myTextAttributes;
    private int myNextExpanded;

    public RangeIterator(Gaps foldingModel, Equality<TextAttributes> equality, HighlighterIterator source, Condition<TextAttributes> filter) {
        this.mySource = source;
        this.myGaps = foldingModel;
        this.myEquality = equality;
        this.myFilter = filter;
    }

    public void init(TextRange range) {
        int rangeStart = range.getStartOffset();
        this.myRangeEnd = range.getEndOffset();
        while (!this.mySource.atEnd()) {
            boolean sourceBeforeRange;
            boolean bl = sourceBeforeRange = rangeStart > this.mySource.getEnd();
            if (!sourceBeforeRange) break;
            this.mySource.advance();
        }
        while (!(this.mySource.atEnd() || this.checkOutOfRange() || this.myFilter.value((Object)this.mySource.getTextAttributes()))) {
            this.mySource.advance();
        }
        if (this.mySource.atEnd() || this.mySourceOutOfRange) {
            this.myNextExpanded = -1;
        } else {
            this.myNextExpanded = this.findExpanded(this.mySource.getStart());
            if (this.myNextExpanded == -1) {
                this.myStart = -1;
            }
        }
    }

    private boolean checkOutOfRange() {
        if (this.mySourceOutOfRange) {
            return true;
        }
        this.mySourceOutOfRange = this.mySource.getStart() > this.myRangeEnd;
        return this.mySourceOutOfRange;
    }

    private void doAdvanceFrom(int start) {
        this.myEnd = this.myStart = start;
        this.doAdvance();
        this.myNextExpanded = this.mySource.atEnd() ? -1 : this.findExpanded(Math.max(this.myEnd, this.mySource.getStart()));
    }

    private void doAdvance() {
        this.myStart = this.findExpanded(this.myStart);
        this.myEnd = this.findFolding(this.myStart, this.mySource.getEnd(), true);
        this.myTextAttributes = this.mySource.getTextAttributes();
        while (this.myEnd == this.mySource.getEnd()) {
            if (!this.advanceSource()) {
                return;
            }
            if (this.mySource.getStart() != this.myEnd) {
                return;
            }
            if (!this.myEquality.equals((Object)this.myTextAttributes, (Object)this.mySource.getTextAttributes())) {
                return;
            }
            this.myEnd = this.findFolding(this.myEnd, this.mySource.getEnd(), true);
        }
    }

    private boolean advanceSource() {
        if (this.mySource.atEnd()) {
            return false;
        }
        do {
            this.mySource.advance();
        } while (!this.mySource.atEnd() && !this.checkOutOfRange() && !this.myFilter.value((Object)this.mySource.getTextAttributes()));
        return !this.mySource.atEnd();
    }

    private int findExpanded(int start) {
        start = this.findFolding(start, this.mySource.getEnd(), false);
        while (start == this.mySource.getEnd()) {
            if (!this.advanceSource()) {
                return -1;
            }
            start = this.findFolding(this.mySource.getStart(), this.mySource.getEnd(), false);
        }
        return start;
    }

    private int findFolding(int start, int end, boolean collapsed) {
        int position;
        for (position = start; position < end && this.myGaps.isGapAt(position) != collapsed; ++position) {
        }
        return position;
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public TextAttributes getTextAttributes() {
        LOG.assertTrue(this.myFilter.value((Object)this.myTextAttributes));
        return this.myTextAttributes;
    }

    public void advance() {
        this.doAdvanceFrom(this.myNextExpanded);
    }

    public boolean atEnd() {
        return this.myStart == -1 || this.mySourceOutOfRange || this.mySource.atEnd() && (this.myNextExpanded == -1 || this.myNextExpanded == this.mySource.getEnd());
    }

    public static class FoldingGaps
    implements Gaps {
        private final FoldingModel myFoldingModel;

        public FoldingGaps(FoldingModel foldingModel) {
            this.myFoldingModel = foldingModel;
        }

        @Override
        public boolean isGapAt(int offset) {
            return this.myFoldingModel.isOffsetCollapsed(offset);
        }
    }

    public static interface Gaps {
        public boolean isGapAt(int var1);
    }
}

