/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.event;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.EventDispatcher;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EditorEventMulticasterImpl
implements EditorEventMulticasterEx {
    private final EventDispatcher<DocumentListener> myDocumentMulticaster = EventDispatcher.create(DocumentListener.class);
    private final EventDispatcher<EditReadOnlyListener> myEditReadOnlyMulticaster = EventDispatcher.create(EditReadOnlyListener.class);
    private final EventDispatcher<EditorMouseListener> myEditorMouseMulticaster = EventDispatcher.create(EditorMouseListener.class);
    private final EventDispatcher<EditorMouseMotionListener> myEditorMouseMotionMulticaster = EventDispatcher.create(EditorMouseMotionListener.class);
    private final EventDispatcher<ErrorStripeListener> myErrorStripeMulticaster = EventDispatcher.create(ErrorStripeListener.class);
    private final EventDispatcher<CaretListener> myCaretMulticaster = EventDispatcher.create(CaretListener.class);
    private final EventDispatcher<SelectionListener> mySelectionMulticaster = EventDispatcher.create(SelectionListener.class);
    private final EventDispatcher<VisibleAreaListener> myVisibleAreaMulticaster = EventDispatcher.create(VisibleAreaListener.class);
    private final EventDispatcher<PropertyChangeListener> myPropertyChangeMulticaster = EventDispatcher.create(PropertyChangeListener.class);
    private final EventDispatcher<FocusChangeListener> myFocusChangeListenerMulticaster = EventDispatcher.create(FocusChangeListener.class);

    public void registerDocument(@NotNull DocumentEx document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "registerDocument"));
        }
        document.addDocumentListener((DocumentListener)this.myDocumentMulticaster.getMulticaster());
        document.addEditReadOnlyListener((EditReadOnlyListener)this.myEditReadOnlyMulticaster.getMulticaster());
    }

    public void registerEditor(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "registerEditor"));
        }
        editor.addEditorMouseListener((EditorMouseListener)this.myEditorMouseMulticaster.getMulticaster());
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)this.myEditorMouseMotionMulticaster.getMulticaster());
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).addErrorMarkerListener((ErrorStripeListener)this.myErrorStripeMulticaster.getMulticaster(), ((EditorImpl)editor).getDisposable());
        editor.getCaretModel().addCaretListener((CaretListener)this.myCaretMulticaster.getMulticaster());
        editor.getSelectionModel().addSelectionListener((SelectionListener)this.mySelectionMulticaster.getMulticaster());
        editor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this.myVisibleAreaMulticaster.getMulticaster());
        editor.addPropertyChangeListener((PropertyChangeListener)this.myPropertyChangeMulticaster.getMulticaster());
        editor.addFocusListener((FocusChangeListener)this.myFocusChangeListenerMulticaster.getMulticaster());
    }

    public void addDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addDocumentListener"));
        }
        this.myDocumentMulticaster.addListener((EventListener)listener2);
    }

    public void addDocumentListener(@NotNull DocumentListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addDocumentListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addDocumentListener"));
        }
        this.myDocumentMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "removeDocumentListener"));
        }
        this.myDocumentMulticaster.removeListener((EventListener)listener2);
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addEditorMouseListener"));
        }
        this.myEditorMouseMulticaster.addListener((EventListener)listener2);
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addEditorMouseListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addEditorMouseListener"));
        }
        this.myEditorMouseMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "removeEditorMouseListener"));
        }
        this.myEditorMouseMulticaster.removeListener((EventListener)listener2);
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addEditorMouseMotionListener"));
        }
        this.myEditorMouseMotionMulticaster.addListener((EventListener)listener2);
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addEditorMouseMotionListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addEditorMouseMotionListener"));
        }
        this.myEditorMouseMotionMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "removeEditorMouseMotionListener"));
        }
        this.myEditorMouseMotionMulticaster.removeListener((EventListener)listener2);
    }

    public void addCaretListener(@NotNull CaretListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addCaretListener"));
        }
        this.myCaretMulticaster.addListener((EventListener)listener2);
    }

    public void addCaretListener(@NotNull CaretListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addCaretListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addCaretListener"));
        }
        this.myCaretMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "removeCaretListener"));
        }
        this.myCaretMulticaster.removeListener((EventListener)listener2);
    }

    public void addSelectionListener(@NotNull SelectionListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addSelectionListener"));
        }
        this.mySelectionMulticaster.addListener((EventListener)listener2);
    }

    public void addSelectionListener(@NotNull SelectionListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addSelectionListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addSelectionListener"));
        }
        this.mySelectionMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeSelectionListener(@NotNull SelectionListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "removeSelectionListener"));
        }
        this.mySelectionMulticaster.removeListener((EventListener)listener2);
    }

    @Override
    public void addErrorStripeListener(@NotNull ErrorStripeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addErrorStripeListener"));
        }
        this.myErrorStripeMulticaster.addListener((EventListener)listener2);
    }

    @Override
    public void addErrorStripeListener(@NotNull ErrorStripeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addErrorStripeListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addErrorStripeListener"));
        }
        this.myErrorStripeMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    public void removeErrorStripeListener(@NotNull ErrorStripeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "removeErrorStripeListener"));
        }
        this.myErrorStripeMulticaster.removeListener((EventListener)listener2);
    }

    public void addVisibleAreaListener(@NotNull VisibleAreaListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addVisibleAreaListener"));
        }
        this.myVisibleAreaMulticaster.addListener((EventListener)listener2);
    }

    public void removeVisibleAreaListener(@NotNull VisibleAreaListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "removeVisibleAreaListener"));
        }
        this.myVisibleAreaMulticaster.removeListener((EventListener)listener2);
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addEditReadOnlyListener"));
        }
        this.myEditReadOnlyMulticaster.addListener((EventListener)listener2);
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "removeEditReadOnlyListener"));
        }
        this.myEditReadOnlyMulticaster.removeListener((EventListener)listener2);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addPropertyChangeListener"));
        }
        this.myPropertyChangeMulticaster.addListener((EventListener)listener2);
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "removePropertyChangeListener"));
        }
        this.myPropertyChangeMulticaster.removeListener((EventListener)listener2);
    }

    @Override
    public void addFocusChangeListner(@NotNull FocusChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addFocusChangeListner"));
        }
        this.myFocusChangeListenerMulticaster.addListener((EventListener)listener2);
    }

    @Override
    public void addFocusChangeListner(@NotNull FocusChangeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addFocusChangeListner"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "addFocusChangeListner"));
        }
        this.myFocusChangeListenerMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    public void removeFocusChangeListner(@NotNull FocusChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/event/EditorEventMulticasterImpl", "removeFocusChangeListner"));
        }
        this.myFocusChangeListenerMulticaster.removeListener((EventListener)listener2);
    }

    public Map<Class, List> getListeners() {
        LinkedHashMap<Class, List> myCopy = new LinkedHashMap<Class, List>();
        myCopy.put(DocumentListener.class, new ArrayList(this.myDocumentMulticaster.getListeners()));
        myCopy.put(EditReadOnlyListener.class, new ArrayList(this.myEditReadOnlyMulticaster.getListeners()));
        myCopy.put(EditorMouseListener.class, new ArrayList(this.myEditorMouseMulticaster.getListeners()));
        myCopy.put(EditorMouseMotionListener.class, new ArrayList(this.myEditorMouseMotionMulticaster.getListeners()));
        myCopy.put(ErrorStripeListener.class, new ArrayList(this.myErrorStripeMulticaster.getListeners()));
        myCopy.put(CaretListener.class, new ArrayList(this.myCaretMulticaster.getListeners()));
        myCopy.put(SelectionListener.class, new ArrayList(this.mySelectionMulticaster.getListeners()));
        myCopy.put(VisibleAreaListener.class, new ArrayList(this.myVisibleAreaMulticaster.getListeners()));
        myCopy.put(PropertyChangeListener.class, new ArrayList(this.myPropertyChangeMulticaster.getListeners()));
        myCopy.put(FocusChangeListener.class, new ArrayList(this.myFocusChangeListenerMulticaster.getListeners()));
        return myCopy;
    }
}

