/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemRunConfigurationMenu
extends DefaultActionGroup
implements DumbAware {
    public void update(AnActionEvent e) {
        for (AnAction action : this.getChildActionsOrStubs()) {
            if (!(action instanceof ExecuteExternalSystemRunConfigurationAction)) continue;
            this.remove(action);
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1 || !(selectedNodes.get(0) instanceof RunConfigurationNode)) {
            return;
        }
        RunnerAndConfigurationSettings settings = ((RunConfigurationNode)selectedNodes.get(0)).getSettings();
        if (settings == null || project2 == null) {
            return;
        }
        Executor[] executors = ExecutorRegistry.getInstance().getRegisteredExecutors();
        int i = executors.length;
        while (--i >= 0) {
            ProgramRunner runner = RunnerRegistry.getInstance().getRunner(executors[i].getId(), (RunProfile)settings.getConfiguration());
            ExecuteExternalSystemRunConfigurationAction action = new ExecuteExternalSystemRunConfigurationAction(executors[i], runner != null, project2, settings);
            this.addAction(action, Constraints.FIRST);
        }
        super.update(e);
    }

    private static class ExecuteExternalSystemRunConfigurationAction
    extends AnAction {
        private final Executor myExecutor;
        private final boolean myEnabled;
        private final Project myProject;
        private final RunnerAndConfigurationSettings mySettings;

        public ExecuteExternalSystemRunConfigurationAction(Executor executor, boolean enabled, Project project2, RunnerAndConfigurationSettings settings) {
            super(executor.getActionName(), null, executor.getIcon());
            this.myExecutor = executor;
            this.myEnabled = enabled;
            this.myProject = project2;
            this.mySettings = settings;
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/action/ExternalSystemRunConfigurationMenu$ExecuteExternalSystemRunConfigurationAction", "actionPerformed"));
            }
            if (this.myEnabled) {
                ProgramRunnerUtil.executeConfiguration(this.myProject, this.mySettings, this.myExecutor);
                RunManagerEx runManagerEx = RunManagerEx.getInstanceEx(this.myProject);
                runManagerEx.setSelectedConfiguration(this.mySettings);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/action/ExternalSystemRunConfigurationMenu$ExecuteExternalSystemRunConfigurationAction", "update"));
            }
            super.update(e);
            e.getPresentation().setEnabled(this.myEnabled);
        }
    }
}

