/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action.task;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.keymap.impl.ui.EditKeymapsDialog;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AssignRunConfigurationShortcutAction
extends ExternalSystemAction {
    @Override
    protected boolean isEnabled(AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1) {
            return false;
        }
        return selectedNodes.get(0) instanceof RunConfigurationNode;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/action/task/AssignRunConfigurationShortcutAction", "actionPerformed"));
        }
        Project project2 = this.getProject(e);
        assert (project2 != null);
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1 || !(selectedNodes.get(0) instanceof RunConfigurationNode)) {
            return;
        }
        RunnerAndConfigurationSettings settings = ((RunConfigurationNode)selectedNodes.get(0)).getSettings();
        assert (settings != null);
        ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)settings.getConfiguration();
        String actionIdPrefix = ExternalSystemKeymapExtension.getActionPrefix(project2, runConfiguration.getSettings().getExternalProjectPath());
        String actionId = actionIdPrefix + settings.getName();
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action == null) {
            ExternalSystemKeymapExtension.getOrRegisterAction(project2, settings);
        }
        new EditKeymapsDialog(project2, actionId).show();
    }
}

