/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskLocation;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class AbstractExternalSystemRunConfigurationProducer
extends RunConfigurationProducer<ExternalSystemRunConfiguration> {
    public AbstractExternalSystemRunConfigurationProducer(@NotNull AbstractExternalSystemTaskConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemRunConfigurationProducer", "<init>"));
        }
        super((ConfigurationType)type);
    }

    public boolean shouldReplace(ConfigurationFromContext self, ConfigurationFromContext other) {
        return true;
    }

    protected boolean setupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Location location = context.getLocation();
        if (!(location instanceof ExternalSystemTaskLocation)) {
            return false;
        }
        ExternalSystemTaskLocation taskLocation = (ExternalSystemTaskLocation)location;
        ExternalSystemTaskExecutionSettings taskExecutionSettings = configuration.getSettings();
        ExternalTaskExecutionInfo task = taskLocation.getTaskInfo();
        taskExecutionSettings.setExternalProjectPath(task.getSettings().getExternalProjectPath());
        taskExecutionSettings.setTaskNames(task.getSettings().getTaskNames());
        configuration.setName(AbstractExternalSystemTaskConfigurationType.generateName(location.getProject(), taskExecutionSettings));
        return true;
    }

    public boolean isConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        Location contextLocation = context.getLocation();
        if (contextLocation == null) {
            return false;
        }
        if (!(contextLocation instanceof ExternalSystemTaskLocation)) {
            return false;
        }
        ExternalSystemTaskLocation taskLocation = (ExternalSystemTaskLocation)contextLocation;
        ExternalSystemTaskExecutionSettings contextTaskExecutionSettings = taskLocation.getTaskInfo().getSettings();
        ExternalSystemTaskExecutionSettings taskExecutionSettings = configuration.getSettings();
        if (!StringUtil.equals((CharSequence)contextTaskExecutionSettings.getExternalProjectPath(), (CharSequence)configuration.getSettings().getExternalProjectPath())) {
            return false;
        }
        return contextTaskExecutionSettings.getTaskNames().equals(taskExecutionSettings.getTaskNames());
    }
}

