/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public final class GotoProjectDirectory
extends FileChooserAction {
    private static final Icon ourIcon = PlatformUtils.isJetBrainsProduct() ? AllIcons.Nodes.IdeaProject : IconLoader.getIcon((String)ApplicationInfoEx.getInstanceEx().getSmallIconUrl());

    @Override
    protected void actionPerformed(final FileSystemTree fileSystemTree, AnActionEvent e) {
        final VirtualFile projectPath = GotoProjectDirectory.getProjectDir(e);
        if (projectPath != null) {
            fileSystemTree.select(projectPath, new Runnable(){

                @Override
                public void run() {
                    fileSystemTree.expand(projectPath, null);
                }
            });
        }
    }

    @Override
    protected void update(FileSystemTree fileSystemTree, AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setIcon(ourIcon);
        VirtualFile projectPath = GotoProjectDirectory.getProjectDir(e);
        presentation.setEnabled(projectPath != null && fileSystemTree.isUnderRoots(projectPath));
    }

    @Nullable
    private static VirtualFile getProjectDir(AnActionEvent e) {
        VirtualFile projectFileDir = (VirtualFile)e.getData(PlatformDataKeys.PROJECT_FILE_DIRECTORY);
        return projectFileDir != null && projectFileDir.isValid() ? projectFileDir : null;
    }
}

