/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.SaveAndSyncHandlerImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.ex.FileDrop;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.fileChooser.ex.PathField;
import com.intellij.openapi.fileChooser.ex.TextFieldAction;
import com.intellij.openapi.fileChooser.impl.FileChooserFactoryImpl;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooserDialogImpl
extends DialogWrapper
implements FileChooserDialog,
PathChooserDialog,
FileLookup {
    @NonNls
    public static final String FILE_CHOOSER_SHOW_PATH_PROPERTY = "FileChooser.ShowPath";
    public static final String RECENT_FILES_KEY = "file.chooser.recent.files";
    public static final String DRAG_N_DROP_HINT = "<html><center><small><font color=gray>Drag and drop a file into the space above to quickly locate it in the tree</font></small></center></html>";
    private final FileChooserDescriptor myChooserDescriptor;
    protected FileSystemTreeImpl myFileSystemTree;
    private Project myProject;
    private VirtualFile[] myChosenFiles;
    private JPanel myNorthPanel;
    private TextFieldAction myTextFieldAction;
    protected FileTextFieldImpl myPathTextField;
    private JComponent myPathTextFieldWrapper;
    private MergingUpdateQueue myUiUpdater;
    private boolean myTreeIsUpdating;
    public static DataKey<PathField> PATH_FIELD = DataKey.create((String)"PathField");
    private final Map<String, LocalFileSystem.WatchRequest> myRequests;

    public FileChooserDialogImpl(@NotNull FileChooserDescriptor descriptor, @Nullable Project project2) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl", "<init>"));
        }
        super(project2, true);
        this.myChosenFiles = VirtualFile.EMPTY_ARRAY;
        this.myRequests = new HashMap();
        this.myChooserDescriptor = descriptor;
        this.myProject = project2;
        this.setTitle(FileChooserDialogImpl.getChooserTitle(descriptor));
    }

    public FileChooserDialogImpl(@NotNull FileChooserDescriptor descriptor, @NotNull Component parent) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl", "<init>"));
        }
        this(descriptor, parent, null);
    }

    public FileChooserDialogImpl(@NotNull FileChooserDescriptor descriptor, @NotNull Component parent, @Nullable Project project2) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl", "<init>"));
        }
        super(parent, true);
        this.myChosenFiles = VirtualFile.EMPTY_ARRAY;
        this.myRequests = new HashMap();
        this.myChooserDescriptor = descriptor;
        this.myProject = project2;
        this.setTitle(FileChooserDialogImpl.getChooserTitle(descriptor));
    }

    private static String getChooserTitle(FileChooserDescriptor descriptor) {
        String title = descriptor.getTitle();
        return title != null ? title : UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]);
    }

    @NotNull
    public VirtualFile[] choose(@Nullable Project project2, VirtualFile ... toSelect) {
        if (toSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSelect", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl", "choose"));
        }
        this.init();
        if (this.myProject == null && project2 != null) {
            this.myProject = project2;
        }
        if (toSelect.length == 1) {
            this.restoreSelection(toSelect[0]);
        } else if (toSelect.length == 0) {
            this.restoreSelection(null);
        } else {
            this.selectInTree(toSelect, true);
        }
        this.show();
        if (this.myChosenFiles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl", "choose"));
        }
        return this.myChosenFiles;
    }

    @NotNull
    public VirtualFile[] choose(@Nullable VirtualFile toSelect, @Nullable Project project2) {
        if (toSelect == null) {
            VirtualFile[] virtualFileArray = this.choose(project2, new VirtualFile[0]);
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl", "choose"));
            }
            return virtualFileArray;
        }
        VirtualFile[] virtualFileArray = this.choose(project2, toSelect);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl", "choose"));
        }
        return virtualFileArray;
    }

    public void choose(@Nullable VirtualFile toSelect, @NotNull Consumer<List<VirtualFile>> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl", "choose"));
        }
        this.init();
        this.restoreSelection(toSelect);
        this.show();
        if (this.myChosenFiles.length > 0) {
            callback.consume(Arrays.asList(this.myChosenFiles));
        } else if (callback instanceof FileChooser.FileChooserConsumer) {
            ((FileChooser.FileChooserConsumer)callback).cancelled();
        }
    }

    protected void restoreSelection(@Nullable VirtualFile toSelect) {
        VirtualFile lastOpenedFile = FileChooserUtil.getLastOpenedFile(this.myProject);
        final VirtualFile file2 = FileChooserUtil.getFileToSelect(this.myChooserDescriptor, this.myProject, toSelect, lastOpenedFile);
        if (file2 != null && file2.isValid()) {
            this.myFileSystemTree.select(file2, new Runnable(){

                @Override
                public void run() {
                    if (!file2.equals(FileChooserDialogImpl.this.myFileSystemTree.getSelectedFile())) {
                        VirtualFile parent = file2.getParent();
                        if (parent != null) {
                            FileChooserDialogImpl.this.myFileSystemTree.select(parent, null);
                        }
                    } else if (file2.isDirectory()) {
                        FileChooserDialogImpl.this.myFileSystemTree.expand(file2, null);
                    }
                }
            });
        }
    }

    protected void storeSelection(@Nullable VirtualFile file2) {
        FileChooserUtil.setLastOpenedFile(this.myProject, file2);
        if (file2 != null && file2.getFileSystem() instanceof LocalFileSystem) {
            this.saveRecent(file2.getPath());
        }
    }

    protected void saveRecent(String path) {
        ArrayList<String> files = new ArrayList<String>(Arrays.asList(this.getRecentFiles()));
        files.remove(path);
        files.add(0, path);
        while (files.size() > 30) {
            files.remove(files.size() - 1);
        }
        PropertiesComponent.getInstance().setValues(RECENT_FILES_KEY, ArrayUtil.toStringArray(files));
    }

    @NotNull
    private String[] getRecentFiles() {
        String[] recent = PropertiesComponent.getInstance().getValues(RECENT_FILES_KEY);
        if (recent != null) {
            if (recent.length > 0 && this.myPathTextField.getField().getText().replace('\\', '/').equals(recent[0])) {
                String[] pathes = new String[recent.length - 1];
                System.arraycopy(recent, 1, pathes, 0, recent.length - 1);
                if (pathes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl", "getRecentFiles"));
                }
                return pathes;
            }
            if (recent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl", "getRecentFiles"));
            }
            return recent;
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl", "getRecentFiles"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    protected JComponent createHistoryButton() {
        JLabel label = new JLabel(AllIcons.Actions.Get);
        label.setToolTipText("Recent files");
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl$2", "onClick"));
                }
                FileChooserDialogImpl.this.showRecentFilesPopup();
                return true;
            }
        }.installOn((Component)label);
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                FileChooserDialogImpl.this.showRecentFilesPopup();
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(!IdeEventQueue.getInstance().isPopupActive());
            }
        }.registerCustomShortcutSet(40, 0, (JComponent)this.myPathTextField.getField());
        return label;
    }

    private void showRecentFilesPopup() {
        final JBList files = new JBList(this.getRecentFiles()){

            public Dimension getPreferredSize() {
                return new Dimension(FileChooserDialogImpl.this.myPathTextField.getField().getWidth(), super.getPreferredSize().height);
            }
        };
        files.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                String path = value.toString();
                this.append(path);
                VirtualFile file2 = LocalFileSystem.getInstance().findFileByIoFile(new File(path));
                if (file2 != null) {
                    this.setIcon(IconUtil.getIcon((VirtualFile)file2, (int)2, null));
                }
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)files).setItemChoosenCallback(new Runnable(){

            @Override
            public void run() {
                FileChooserDialogImpl.this.myPathTextField.getField().setText(files.getSelectedValue().toString());
            }
        }).createPopup().showUnderneathOf((Component)this.myPathTextField.getField());
    }

    protected DefaultActionGroup createActionGroup() {
        this.registerFileChooserShortcut("$Delete", "FileChooser.Delete");
        this.registerFileChooserShortcut("Synchronize", "FileChooser.Refresh");
        return (DefaultActionGroup)ActionManager.getInstance().getAction("FileChooserToolbar");
    }

    private void registerFileChooserShortcut(@NonNls String baseActionId, @NonNls String fileChooserActionId) {
        JTree tree = this.myFileSystemTree.getTree();
        AnAction syncAction = ActionManager.getInstance().getAction(fileChooserActionId);
        AnAction original = ActionManager.getInstance().getAction(baseActionId);
        syncAction.registerCustomShortcutSet(original.getShortcutSet(), (JComponent)tree, this.myDisposable);
    }

    @Nullable
    protected final JComponent createTitlePane() {
        String description = this.myChooserDescriptor.getDescription();
        if (StringUtil.isEmptyOrSpaces((String)description)) {
            return null;
        }
        JLabel label = new JLabel(description);
        label.setBorder(BorderFactory.createCompoundBorder((Border)new SideBorder(UIUtil.getPanelBackground().darker(), 8), (Border)JBUI.Borders.empty((int)0, (int)5, (int)10, (int)5)));
        return label;
    }

    protected JComponent createCenterPanel() {
        MyPanel panel = new MyPanel();
        this.myUiUpdater = new MergingUpdateQueue("FileChooserUpdater", 200, false, (JComponent)panel);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myUiUpdater);
        new UiNotifyConnector((Component)panel, (Activatable)this.myUiUpdater);
        panel.setBorder((Border)JBUI.Borders.empty());
        this.createTree();
        DefaultActionGroup group = this.createActionGroup();
        ActionToolbar toolBar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        toolBar.setTargetComponent((JComponent)panel);
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.add((Component)toolBar.getComponent(), "Center");
        this.myTextFieldAction = new TextFieldAction(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                FileChooserDialogImpl.this.toggleShowTextField();
            }
        };
        toolbarPanel.add((Component)((Object)this.myTextFieldAction), "East");
        JPanel extraToolbarPanel = this.createExtraToolbarPanel();
        if (extraToolbarPanel != null) {
            toolbarPanel.add((Component)extraToolbarPanel, "South");
        }
        this.myPathTextFieldWrapper = new JPanel(new BorderLayout());
        this.myPathTextFieldWrapper.setBorder((Border)JBUI.Borders.emptyBottom((int)2));
        this.myPathTextField = new FileTextFieldImpl.Vfs(FileChooserFactoryImpl.getMacroMap(), this.getDisposable(), (FileLookup.LookupFilter)new LocalFsFinder.FileChooserFilter(this.myChooserDescriptor, this.myFileSystemTree)){

            @Override
            protected void onTextChanged(String newValue) {
                FileChooserDialogImpl.this.myUiUpdater.cancelAllUpdates();
                FileChooserDialogImpl.this.updateTreeFromPath(newValue);
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myPathTextField);
        this.myPathTextFieldWrapper.add((Component)this.myPathTextField.getField(), "Center");
        if (this.getRecentFiles().length > 0) {
            this.myPathTextFieldWrapper.add((Component)this.createHistoryButton(), "East");
        }
        this.myNorthPanel = new JPanel(new BorderLayout());
        this.myNorthPanel.add((Component)toolbarPanel, "North");
        this.updateTextFieldShowing();
        panel.add((Component)this.myNorthPanel, "North");
        this.registerMouseListener((ActionGroup)group);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myFileSystemTree.getTree());
        panel.add((Component)scrollPane, "Center");
        panel.setPreferredSize((Dimension)JBUI.size((int)400));
        panel.add((Component)new JLabel(DRAG_N_DROP_HINT, 0), "South");
        ApplicationManager.getApplication().getMessageBus().connect(this.getDisposable()).subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener.Adapter(){

            public void applicationActivated(IdeFrame ideFrame) {
                DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_MODAL, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((SaveAndSyncHandlerImpl)SaveAndSyncHandler.getInstance()).maybeRefresh(ModalityState.current());
                    }
                });
            }
        });
        return panel;
    }

    @Nullable
    protected JPanel createExtraToolbarPanel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        if (FileChooserDialogImpl.isToShowTextField()) {
            return this.myPathTextField != null ? this.myPathTextField.getField() : null;
        }
        return this.myFileSystemTree != null ? this.myFileSystemTree.getTree() : null;
    }

    public final void dispose() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myRequests.values());
        super.dispose();
    }

    private boolean isTextFieldActive() {
        return this.myPathTextField.getField().getRootPane() != null;
    }

    protected void doOKAction() {
        List<VirtualFile> selectedFiles;
        VirtualFile[] files;
        if (!this.isOKActionEnabled()) {
            return;
        }
        if (this.isTextFieldActive()) {
            String text = this.myPathTextField.getTextFieldText();
            FileLookup.LookupFile file2 = this.myPathTextField.getFile();
            if (text == null || file2 == null || !file2.exists()) {
                this.setErrorText("Specified path cannot be found");
                return;
            }
        }
        if ((files = VfsUtilCore.toVirtualFileArray(FileChooserUtil.getChosenFiles(this.myChooserDescriptor, selectedFiles = Arrays.asList(this.getSelectedFilesInt())))).length == 0) {
            this.myChosenFiles = VirtualFile.EMPTY_ARRAY;
            this.close(1);
            return;
        }
        try {
            this.myChooserDescriptor.validateSelectedFiles(files);
        }
        catch (Exception e) {
            Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage(), (String)this.getTitle());
            return;
        }
        this.myChosenFiles = files;
        this.storeSelection(files[files.length - 1]);
        super.doOKAction();
    }

    public final void doCancelAction() {
        this.myChosenFiles = VirtualFile.EMPTY_ARRAY;
        super.doCancelAction();
    }

    protected JTree createTree() {
        Tree internalTree = this.createInternalTree();
        this.myFileSystemTree = new FileSystemTreeImpl(this.myProject, this.myChooserDescriptor, internalTree, null, null, null);
        internalTree.setRootVisible(this.myChooserDescriptor.isTreeRootVisible());
        internalTree.setShowsRootHandles(true);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myFileSystemTree);
        this.myFileSystemTree.addOkAction(new Runnable(){

            @Override
            public void run() {
                FileChooserDialogImpl.this.doOKAction();
            }
        });
        JTree tree = this.myFileSystemTree.getTree();
        tree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        tree.getSelectionModel().addTreeSelectionListener(new FileTreeSelectionListener());
        tree.addTreeExpansionListener(new FileTreeExpansionListener());
        this.setOKActionEnabled(false);
        this.myFileSystemTree.addListener(new FileSystemTree.Listener(){

            public void selectionChanged(List<VirtualFile> selection) {
                FileChooserDialogImpl.this.updatePathFromTree(selection, false);
            }
        }, this.myDisposable);
        new FileDrop(tree, new FileDrop.Target(){

            @Override
            public FileChooserDescriptor getDescriptor() {
                return FileChooserDialogImpl.this.myChooserDescriptor;
            }

            @Override
            public boolean isHiddenShown() {
                return FileChooserDialogImpl.this.myFileSystemTree.areHiddensShown();
            }

            @Override
            public void dropFiles(List<VirtualFile> files) {
                if (!FileChooserDialogImpl.this.myChooserDescriptor.isChooseMultiple() && files.size() > 0) {
                    FileChooserDialogImpl.this.selectInTree(new VirtualFile[]{files.get(0)}, true);
                } else {
                    FileChooserDialogImpl.this.selectInTree(VfsUtilCore.toVirtualFileArray(files), true);
                }
            }
        });
        return tree;
    }

    @NotNull
    protected Tree createInternalTree() {
        Tree tree = new Tree();
        if (tree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl", "createInternalTree"));
        }
        return tree;
    }

    protected final void registerMouseListener(ActionGroup group) {
        this.myFileSystemTree.registerMouseListener(group);
    }

    private VirtualFile[] getSelectedFilesInt() {
        if (this.myTreeIsUpdating || !this.myUiUpdater.isEmpty()) {
            VirtualFile file2;
            FileLookup.LookupFile toFind;
            if (this.isTextFieldActive() && !StringUtil.isEmpty((String)this.myPathTextField.getTextFieldText()) && (toFind = this.myPathTextField.getFile()) instanceof LocalFsFinder.VfsFile && toFind.exists() && (file2 = ((LocalFsFinder.VfsFile)toFind).getFile()) != null) {
                return new VirtualFile[]{file2};
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        return this.myFileSystemTree.getSelectedFiles();
    }

    private static boolean isToShowTextField() {
        return PropertiesComponent.getInstance().getBoolean(FILE_CHOOSER_SHOW_PATH_PROPERTY, true);
    }

    private static void setToShowTextField(boolean toShowTextField) {
        PropertiesComponent.getInstance().setValue(FILE_CHOOSER_SHOW_PATH_PROPERTY, Boolean.toString(toShowTextField));
    }

    public void toggleShowTextField() {
        FileChooserDialogImpl.setToShowTextField(!FileChooserDialogImpl.isToShowTextField());
        this.updateTextFieldShowing();
    }

    private void updateTextFieldShowing() {
        this.myTextFieldAction.update();
        this.myNorthPanel.remove(this.myPathTextFieldWrapper);
        if (FileChooserDialogImpl.isToShowTextField()) {
            ArrayList<VirtualFile> selection = new ArrayList<VirtualFile>();
            if (this.myFileSystemTree.getSelectedFile() != null) {
                selection.add(this.myFileSystemTree.getSelectedFile());
            }
            this.updatePathFromTree(selection, true);
            this.myNorthPanel.add((Component)this.myPathTextFieldWrapper, "Center");
        } else {
            this.setErrorText(null);
        }
        this.myPathTextField.getField().requestFocus();
        this.myNorthPanel.revalidate();
        this.myNorthPanel.repaint();
    }

    private void updatePathFromTree(List<VirtualFile> selection, boolean now) {
        if (!FileChooserDialogImpl.isToShowTextField() || this.myTreeIsUpdating) {
            return;
        }
        String text = "";
        if (selection.size() > 0) {
            text = VfsUtil.getReadableUrl((VirtualFile)selection.get(0));
        } else {
            List roots = this.myChooserDescriptor.getRoots();
            if (!this.myFileSystemTree.getTree().isRootVisible() && roots.size() == 1) {
                text = VfsUtil.getReadableUrl((VirtualFile)((VirtualFile)roots.get(0)));
            }
        }
        this.myPathTextField.setText(text, now, new Runnable(){

            @Override
            public void run() {
                FileChooserDialogImpl.this.myPathTextField.getField().selectAll();
                FileChooserDialogImpl.this.setErrorText(null);
            }
        });
    }

    private void updateTreeFromPath(final String text) {
        if (!FileChooserDialogImpl.isToShowTextField()) {
            return;
        }
        if (this.myPathTextField.isPathUpdating()) {
            return;
        }
        if (text == null) {
            return;
        }
        this.myUiUpdater.queue(new Update("treeFromPath.1"){

            public void run() {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        final LocalFsFinder.VfsFile toFind = (LocalFsFinder.VfsFile)FileChooserDialogImpl.this.myPathTextField.getFile();
                        if (toFind == null || !toFind.exists()) {
                            return;
                        }
                        FileChooserDialogImpl.this.myUiUpdater.queue(new Update("treeFromPath.2"){

                            public void run() {
                                FileChooserDialogImpl.this.selectInTree(toFind.getFile(), text);
                            }
                        });
                    }
                });
            }
        });
    }

    private void selectInTree(VirtualFile vFile, String fromText) {
        if (vFile != null && vFile.isValid()) {
            if (fromText == null || fromText.equalsIgnoreCase(this.myPathTextField.getTextFieldText())) {
                this.selectInTree(new VirtualFile[]{vFile}, false);
            }
        } else {
            this.reportFileNotFound();
        }
    }

    private void selectInTree(final VirtualFile[] array, final boolean requestFocus) {
        this.myTreeIsUpdating = true;
        final List<VirtualFile> fileList = Arrays.asList(array);
        if (!Arrays.asList(this.myFileSystemTree.getSelectedFiles()).containsAll(fileList)) {
            this.myFileSystemTree.select(array, new Runnable(){

                @Override
                public void run() {
                    if (!FileChooserDialogImpl.this.myFileSystemTree.areHiddensShown() && !Arrays.asList(FileChooserDialogImpl.this.myFileSystemTree.getSelectedFiles()).containsAll(fileList)) {
                        FileChooserDialogImpl.this.myFileSystemTree.showHiddens(true);
                        FileChooserDialogImpl.this.selectInTree(array, requestFocus);
                        return;
                    }
                    FileChooserDialogImpl.this.myTreeIsUpdating = false;
                    FileChooserDialogImpl.this.setErrorText(null);
                    if (requestFocus) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                FileChooserDialogImpl.this.myFileSystemTree.getTree().requestFocus();
                            }
                        });
                    }
                }
            });
        } else {
            this.myTreeIsUpdating = false;
            this.setErrorText(null);
        }
    }

    private void reportFileNotFound() {
        this.myTreeIsUpdating = false;
        this.setErrorText(null);
    }

    protected String getDimensionServiceKey() {
        return "FileChooserDialogImpl";
    }

    protected String getHelpId() {
        return "select.path.dialog";
    }

    protected final class MyPanel
    extends JPanel
    implements DataProvider {
        public MyPanel() {
            super(new BorderLayout(0, 0));
        }

        public Object getData(String dataId) {
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                return FileChooserDialogImpl.this.myFileSystemTree.getSelectedFiles();
            }
            if (PATH_FIELD.is(dataId)) {
                return new PathField(){

                    @Override
                    public void toggleVisible() {
                        FileChooserDialogImpl.this.toggleShowTextField();
                    }
                };
            }
            if (FileSystemTree.DATA_KEY.is(dataId)) {
                return FileChooserDialogImpl.this.myFileSystemTree;
            }
            return FileChooserDialogImpl.this.myChooserDescriptor.getUserData(dataId);
        }
    }

    private final class FileTreeSelectionListener
    implements TreeSelectionListener {
        private FileTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] paths = e.getPaths();
            boolean enabled = true;
            for (TreePath treePath : paths) {
                if (!e.isAddedPath(treePath)) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (!(userObject instanceof FileNodeDescriptor)) {
                    enabled = false;
                    break;
                }
                FileElement descriptor = ((FileNodeDescriptor)((Object)userObject)).getElement();
                VirtualFile file2 = descriptor.getFile();
                enabled = file2 != null && FileChooserDialogImpl.this.myChooserDescriptor.isFileSelectable(file2);
            }
            FileChooserDialogImpl.this.setOKActionEnabled(enabled);
        }
    }

    private final class FileTreeExpansionListener
    implements TreeExpansionListener {
        private FileTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            VirtualFile file2;
            DefaultMutableTreeNode node;
            Object userObject;
            Object[] path = event.getPath().getPath();
            if (path.length == 2 && (userObject = (node = (DefaultMutableTreeNode)path[1]).getUserObject()) instanceof FileNodeDescriptor && (file2 = ((FileNodeDescriptor)((Object)userObject)).getElement().getFile()) != null && file2.isDirectory()) {
                String rootPath = file2.getPath();
                if (FileChooserDialogImpl.this.myRequests.get(rootPath) == null) {
                    LocalFileSystem.WatchRequest watchRequest = LocalFileSystem.getInstance().addRootToWatch(rootPath, true);
                    FileChooserDialogImpl.this.myRequests.put(rootPath, watchRequest);
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }
}

