/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.QuickListPanel;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.PairProcessor;
import com.intellij.util.ui.ListItemEditor;
import com.intellij.util.ui.ListModelEditor;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

class QuickListsUi
implements ConfigurableUi<List<QuickList>> {
    public static final String EMPTY = "empty";
    public static final String PANEL = "panel";
    private final KeymapListener keymapListener;
    private final ListItemEditor<QuickList> itemEditor = new ListItemEditor<QuickList>(){

        @Override
        @NotNull
        public Class<QuickList> getItemClass() {
            if (QuickList.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/QuickListsUi$1", "getItemClass"));
            }
            return QuickList.class;
        }

        @Override
        public QuickList clone(@NotNull QuickList item, boolean forInPlaceEditing) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/openapi/keymap/impl/ui/QuickListsUi$1", "clone"));
            }
            return new QuickList(item.getName(), item.getDescription(), item.getActionIds());
        }

        @Override
        public boolean isEmpty(@NotNull QuickList item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/openapi/keymap/impl/ui/QuickListsUi$1", "isEmpty"));
            }
            return item.getName().isEmpty() && item.getDescription() == null && item.getActionIds().length == 0;
        }

        @Override
        @NotNull
        public String getName(@NotNull QuickList item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/openapi/keymap/impl/ui/QuickListsUi$1", "getName"));
            }
            String string = item.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/QuickListsUi$1", "getName"));
            }
            return string;
        }

        @Override
        public boolean isRemovable(@NotNull QuickList item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/openapi/keymap/impl/ui/QuickListsUi$1", "isRemovable"));
            }
            return QuickListsManager.getInstance().getSchemeManager().isMetadataEditable((ExternalizableScheme)item);
        }
    };
    private final ListModelEditor<QuickList> editor = new ListModelEditor<QuickList>(this.itemEditor);
    private JComponent component;
    private final QuickListPanel itemPanel;
    private final JPanel itemPanelWrapper;

    public QuickListsUi() {
        this.keymapListener = (KeymapListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(KeymapListener.CHANGE_TOPIC);
        final CardLayout cardLayout = new CardLayout();
        this.editor.disableUpDownActions();
        this.editor.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                QuickList item = (QuickList)((Object)QuickListsUi.this.editor.getSelected());
                if (item == null) {
                    cardLayout.show(QuickListsUi.this.itemPanelWrapper, QuickListsUi.EMPTY);
                    QuickListsUi.this.itemPanel.setItem(null);
                } else {
                    cardLayout.show(QuickListsUi.this.itemPanelWrapper, QuickListsUi.PANEL);
                    QuickListsUi.this.itemPanel.setItem(QuickListsUi.this.editor.getMutable(item));
                }
            }
        });
        this.itemPanel = new QuickListPanel(this.editor.getModel());
        this.itemPanel.myName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                QuickList item = ((QuickListsUi)QuickListsUi.this).itemPanel.item;
                if (item != null) {
                    String name = ((QuickListsUi)QuickListsUi.this).itemPanel.myName.getText();
                    boolean changed = !item.getName().equals(name);
                    item.setName(name);
                    if (changed) {
                        QuickListsUi.this.editor.getList().repaint();
                    }
                }
            }
        });
        this.itemPanelWrapper = new JPanel(cardLayout);
        JLabel descLabel = new JLabel("<html>Quick Lists allow you to define commonly used groups of actions (for example, refactoring or VCS actions) and to assign keyboard shortcuts to such groups.</html>");
        descLabel.setBorder(new EmptyBorder(0, 25, 0, 25));
        this.itemPanelWrapper.add((Component)descLabel, EMPTY);
        this.itemPanelWrapper.add((Component)this.itemPanel.getPanel(), PANEL);
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setFirstComponent(this.editor.createComponent());
        splitter.setSecondComponent((JComponent)this.itemPanelWrapper);
        this.component = splitter;
    }

    public void reset(@NotNull List<QuickList> settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/keymap/impl/ui/QuickListsUi", "reset"));
        }
        this.editor.reset(settings);
    }

    public boolean isModified(@NotNull List<QuickList> settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/keymap/impl/ui/QuickListsUi", "isModified"));
        }
        this.itemPanel.apply();
        return this.editor.isModified();
    }

    public void apply(@NotNull List<QuickList> settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/keymap/impl/ui/QuickListsUi", "apply"));
        }
        this.itemPanel.apply();
        this.editor.ensureNonEmptyNames("Quick list should have non empty name");
        this.editor.processModifiedItems(new PairProcessor<QuickList, QuickList>(){

            public boolean process(QuickList newItem, QuickList oldItem) {
                if (!oldItem.getName().equals(newItem.getName())) {
                    QuickListsUi.this.keymapListener.quickListRenamed(oldItem, newItem);
                }
                return true;
            }
        });
        if (this.isModified(settings)) {
            List<QuickList> result = this.editor.apply();
            this.keymapListener.processCurrentKeymapChanged(result.toArray(new QuickList[result.size()]));
            QuickListsManager.getInstance().setQuickLists(result);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.component;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/QuickListsUi", "getComponent"));
        }
        return jComponent;
    }
}

