/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.icons.AllIcons;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ProgressBar
extends JComponent {
    private double myFraction = 0.0;
    private Icon myProgressIcon = AllIcons.General.Progress;

    public ProgressBar() {
        this.updateUI();
    }

    public void setProgressIcon(@NotNull Icon progressIcon) {
        if (progressIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIcon", "com/intellij/openapi/progress/util/ProgressBar", "setProgressIcon"));
        }
        this.myProgressIcon = progressIcon;
        this.repaint();
    }

    public double getFraction() {
        return this.myFraction;
    }

    public void setFraction(double fraction) {
        this.myFraction = fraction;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myFraction == 0.0 || this.myProgressIcon == null) {
            return;
        }
        if (this.myFraction > 1.0) {
            this.myFraction = 1.0;
        }
        int bricksTotal = (this.getWidth() - 4) / (this.myProgressIcon.getIconWidth() + 2);
        int bricksToDraw = (int)((double)bricksTotal * this.myFraction + 0.5);
        int rWidth = (this.myProgressIcon.getIconWidth() + 2) * bricksTotal + 1;
        int rHeight = this.myProgressIcon.getIconHeight() + 3;
        g.drawRoundRect(0, (this.getHeight() - rHeight) / 2, rWidth, rHeight, 2, 2);
        int offset = 2;
        for (int i = 0; i < bricksToDraw; ++i) {
            this.myProgressIcon.paintIcon(this, g, offset, 2 + (this.getHeight() - rHeight) / 2);
            offset += this.myProgressIcon.getIconWidth() + 2;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.myProgressIcon.getIconHeight() + 4);
    }
}

