/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class OrderRootsEnumeratorImpl
implements OrderRootsEnumerator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.OrderRootsEnumeratorImpl");
    private final OrderEnumeratorBase myOrderEnumerator;
    private final OrderRootType myRootType;
    private final NotNullFunction<OrderEntry, OrderRootType> myRootTypeProvider;
    private boolean myUsingCache;
    private NotNullFunction<OrderEntry, VirtualFile[]> myCustomRootProvider;
    private boolean myWithoutSelfModuleOutput;

    public OrderRootsEnumeratorImpl(OrderEnumeratorBase orderEnumerator, @NotNull OrderRootType rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "<init>"));
        }
        this.myOrderEnumerator = orderEnumerator;
        this.myRootType = rootType;
        this.myRootTypeProvider = null;
    }

    public OrderRootsEnumeratorImpl(OrderEnumeratorBase orderEnumerator, @NotNull NotNullFunction<OrderEntry, OrderRootType> rootTypeProvider) {
        if (rootTypeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTypeProvider", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "<init>"));
        }
        this.myOrderEnumerator = orderEnumerator;
        this.myRootTypeProvider = rootTypeProvider;
        this.myRootType = null;
    }

    @NotNull
    public VirtualFile[] getRoots() {
        if (this.myUsingCache) {
            this.checkCanUseCache();
            OrderRootsCache cache = this.myOrderEnumerator.getCache();
            if (cache != null) {
                int flags = this.myOrderEnumerator.getFlags();
                VirtualFile[] cached = cache.getCachedRoots(this.myRootType, flags);
                if (cached == null) {
                    VirtualFile[] virtualFileArray = cache.setCachedRoots(this.myRootType, flags, this.computeRootsUrls()).getFiles();
                    if (virtualFileArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "getRoots"));
                    }
                    return virtualFileArray;
                }
                if (cached == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "getRoots"));
                }
                return cached;
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(this.computeRoots());
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "getRoots"));
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getUrls() {
        if (this.myUsingCache) {
            this.checkCanUseCache();
            OrderRootsCache cache = this.myOrderEnumerator.getCache();
            if (cache != null) {
                int flags = this.myOrderEnumerator.getFlags();
                String[] cached = cache.getCachedUrls(this.myRootType, flags);
                if (cached == null) {
                    String[] stringArray = cache.setCachedRoots(this.myRootType, flags, this.computeRootsUrls()).getUrls();
                    if (stringArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "getUrls"));
                    }
                    return stringArray;
                }
                if (cached == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "getUrls"));
                }
                return cached;
            }
        }
        String[] stringArray = ArrayUtil.toStringArray(this.computeRootsUrls());
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "getUrls"));
        }
        return stringArray;
    }

    private void checkCanUseCache() {
        LOG.assertTrue(this.myRootTypeProvider == null, (Object)"Caching not supported for OrderRootsEnumerator with root type provider");
        LOG.assertTrue(this.myCustomRootProvider == null, (Object)"Caching not supported for OrderRootsEnumerator with 'usingCustomRootProvider' option");
        LOG.assertTrue(!this.myWithoutSelfModuleOutput, (Object)"Caching not supported for OrderRootsEnumerator with 'withoutSelfModuleOutput' option");
    }

    private Collection<VirtualFile> computeRoots() {
        final LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        this.myOrderEnumerator.forEach(new PairProcessor<OrderEntry, List<OrderEnumerationHandler>>(){

            public boolean process(OrderEntry orderEntry, List<OrderEnumerationHandler> customHandlers) {
                OrderRootType type = OrderRootsEnumeratorImpl.this.getRootType(orderEntry);
                if (orderEntry instanceof ModuleSourceOrderEntry) {
                    OrderRootsEnumeratorImpl.this.collectModuleRoots(type, ((ModuleSourceOrderEntry)orderEntry).getRootModel(), result, true, !OrderRootsEnumeratorImpl.this.myOrderEnumerator.isProductionOnly(), customHandlers);
                } else if (orderEntry instanceof ModuleOrderEntry) {
                    ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                    Module module2 = moduleOrderEntry.getModule();
                    if (module2 != null) {
                        ModuleRootModel rootModel = OrderRootsEnumeratorImpl.this.myOrderEnumerator.getRootModel(module2);
                        boolean productionOnTests = orderEntry instanceof ModuleOrderEntryImpl && ((ModuleOrderEntryImpl)orderEntry).isProductionOnTestDependency();
                        boolean includeTests = !OrderRootsEnumeratorImpl.this.myOrderEnumerator.isProductionOnly() && OrderRootsEnumeratorImpl.this.myOrderEnumerator.shouldIncludeTestsFromDependentModulesToTestClasspath(customHandlers) || productionOnTests;
                        OrderRootsEnumeratorImpl.this.collectModuleRoots(type, rootModel, result, !productionOnTests, includeTests, customHandlers);
                    }
                } else {
                    if (OrderRootsEnumeratorImpl.this.myCustomRootProvider != null) {
                        Collections.addAll(result, (Object[])OrderRootsEnumeratorImpl.this.myCustomRootProvider.fun((Object)orderEntry));
                        return true;
                    }
                    if (OrderRootsEnumeratorImpl.this.myOrderEnumerator.addCustomRootsForLibrary(orderEntry, type, result, customHandlers)) {
                        return true;
                    }
                    Collections.addAll(result, orderEntry.getFiles(type));
                }
                return true;
            }
        });
        return result;
    }

    @NotNull
    private Collection<String> computeRootsUrls() {
        final LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.myOrderEnumerator.forEach(new PairProcessor<OrderEntry, List<OrderEnumerationHandler>>(){

            public boolean process(OrderEntry orderEntry, List<OrderEnumerationHandler> customHandlers) {
                OrderRootType type = OrderRootsEnumeratorImpl.this.getRootType(orderEntry);
                if (orderEntry instanceof ModuleSourceOrderEntry) {
                    OrderRootsEnumeratorImpl.this.collectModuleRootsUrls(type, ((ModuleSourceOrderEntry)orderEntry).getRootModel(), result, true, !OrderRootsEnumeratorImpl.this.myOrderEnumerator.isProductionOnly());
                } else if (orderEntry instanceof ModuleOrderEntry) {
                    ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                    Module module2 = moduleOrderEntry.getModule();
                    if (module2 != null) {
                        ModuleRootModel rootModel = OrderRootsEnumeratorImpl.this.myOrderEnumerator.getRootModel(module2);
                        boolean productionOnTests = orderEntry instanceof ModuleOrderEntryImpl && ((ModuleOrderEntryImpl)orderEntry).isProductionOnTestDependency();
                        boolean includeTests = !OrderRootsEnumeratorImpl.this.myOrderEnumerator.isProductionOnly() && OrderRootsEnumeratorImpl.this.myOrderEnumerator.shouldIncludeTestsFromDependentModulesToTestClasspath(customHandlers) || productionOnTests;
                        OrderRootsEnumeratorImpl.this.collectModuleRootsUrls(type, rootModel, result, !productionOnTests, includeTests);
                    }
                } else {
                    if (OrderRootsEnumeratorImpl.this.myOrderEnumerator.addCustomRootUrlsForLibrary(orderEntry, type, result, customHandlers)) {
                        return true;
                    }
                    Collections.addAll(result, orderEntry.getUrls(type));
                }
                return true;
            }
        });
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "computeRootsUrls"));
        }
        return linkedHashSet;
    }

    @NotNull
    public PathsList getPathsList() {
        PathsList list = new PathsList();
        this.collectPaths(list);
        PathsList pathsList = list;
        if (pathsList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "getPathsList"));
        }
        return pathsList;
    }

    public void collectPaths(@NotNull PathsList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "collectPaths"));
        }
        list.addVirtualFiles(this.getRoots());
    }

    @NotNull
    public OrderRootsEnumerator usingCache() {
        this.myUsingCache = true;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "usingCache"));
        }
        return orderRootsEnumeratorImpl;
    }

    @NotNull
    public OrderRootsEnumerator withoutSelfModuleOutput() {
        this.myWithoutSelfModuleOutput = true;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "withoutSelfModuleOutput"));
        }
        return orderRootsEnumeratorImpl;
    }

    @NotNull
    public OrderRootsEnumerator usingCustomRootProvider(@NotNull NotNullFunction<OrderEntry, VirtualFile[]> provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "usingCustomRootProvider"));
        }
        this.myCustomRootProvider = provider;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl", "usingCustomRootProvider"));
        }
        return orderRootsEnumeratorImpl;
    }

    private void collectModuleRoots(OrderRootType type, ModuleRootModel rootModel, Collection<VirtualFile> result, boolean includeProduction, boolean includeTests, List<OrderEnumerationHandler> customHandlers) {
        CompilerModuleExtension extension;
        if (type.equals((Object)OrderRootType.SOURCES)) {
            if (includeProduction) {
                Collections.addAll(result, rootModel.getSourceRoots(includeTests));
            } else {
                result.addAll(rootModel.getSourceRoots(JavaModuleSourceRootTypes.TESTS));
            }
        } else if (type.equals((Object)OrderRootType.CLASSES) && (extension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)) != null) {
            if (this.myWithoutSelfModuleOutput && this.myOrderEnumerator.isRootModuleModel(rootModel)) {
                if (includeTests && includeProduction) {
                    Collections.addAll(result, extension.getOutputRoots(false));
                }
            } else if (includeProduction) {
                Collections.addAll(result, extension.getOutputRoots(includeTests));
            } else {
                ContainerUtil.addIfNotNull(result, (Object)extension.getCompilerOutputPathForTests());
            }
        }
        this.myOrderEnumerator.addCustomRootsForModule(type, rootModel, result, includeProduction, includeTests, customHandlers);
    }

    private void collectModuleRootsUrls(OrderRootType type, ModuleRootModel rootModel, Collection<String> result, boolean includeProduction, boolean includeTests) {
        CompilerModuleExtension extension;
        if (type.equals((Object)OrderRootType.SOURCES)) {
            if (includeProduction) {
                Collections.addAll(result, rootModel.getSourceRootUrls(includeTests));
            } else {
                for (ContentEntry entry : rootModel.getContentEntries()) {
                    for (SourceFolder folder : entry.getSourceFolders(JavaModuleSourceRootTypes.TESTS)) {
                        result.add(folder.getUrl());
                    }
                }
            }
        } else if (type.equals((Object)OrderRootType.CLASSES) && (extension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)) != null) {
            if (this.myWithoutSelfModuleOutput && this.myOrderEnumerator.isRootModuleModel(rootModel)) {
                if (includeTests && includeProduction) {
                    Collections.addAll(result, extension.getOutputRootUrls(false));
                }
            } else if (includeProduction) {
                Collections.addAll(result, extension.getOutputRootUrls(includeTests));
            } else {
                ContainerUtil.addIfNotNull(result, (Object)extension.getCompilerOutputUrlForTests());
            }
        }
    }

    private OrderRootType getRootType(OrderEntry e) {
        return this.myRootType != null ? this.myRootType : (OrderRootType)this.myRootTypeProvider.fun((Object)e);
    }
}

