/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnnotateRevisionActionBase
extends AnAction {
    public AnnotateRevisionActionBase(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    @Nullable
    protected abstract AbstractVcs getVcs(@NotNull AnActionEvent var1);

    @Nullable
    protected abstract VirtualFile getFile(@NotNull AnActionEvent var1);

    @Nullable
    protected abstract VcsFileRevision getFileRevision(@NotNull AnActionEvent var1);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase", "update"));
        }
        e.getPresentation().setEnabled(this.isEnabled(e));
    }

    public boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase", "isEnabled"));
        }
        if (e.getProject() == null) {
            return false;
        }
        VcsFileRevision fileRevision = this.getFileRevision(e);
        if (fileRevision == null) {
            return false;
        }
        VirtualFile file2 = this.getFile(e);
        if (file2 == null) {
            return false;
        }
        AbstractVcs vcs = this.getVcs(e);
        if (vcs == null) {
            return false;
        }
        AnnotationProvider provider = vcs.getCachingAnnotationProvider();
        if (provider == null || !provider.isAnnotationValid(fileRevision)) {
            return false;
        }
        return !AnnotateRevisionActionBase.getBackgroundableLock(vcs.getProject(), file2).isLocked();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase", "actionPerformed"));
        }
        final VcsFileRevision fileRevision = this.getFileRevision(e);
        final VirtualFile file2 = this.getFile(e);
        final AbstractVcs vcs = this.getVcs(e);
        assert (vcs != null);
        assert (file2 != null);
        assert (fileRevision != null);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        final CharSequence oldContent = editor == null ? null : editor.getDocument().getImmutableCharSequence();
        final int oldLine = editor == null ? 0 : editor.getCaretModel().getLogicalPosition().line;
        final AnnotationProvider annotationProvider = vcs.getCachingAnnotationProvider();
        assert (annotationProvider != null);
        final Ref fileAnnotationRef = new Ref();
        final Ref newLineRef = new Ref();
        final Ref exceptionRef = new Ref();
        AnnotateRevisionActionBase.getBackgroundableLock(vcs.getProject(), file2).lock();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(vcs.getProject(), VcsBundle.message((String)"retrieving.annotations", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase$1", "run"));
                }
                try {
                    FileAnnotation fileAnnotation = annotationProvider.annotate(file2, fileRevision);
                    int newLine = oldLine;
                    if (oldContent != null) {
                        String content = fileAnnotation.getAnnotatedContent();
                        try {
                            newLine = Diff.translateLine((CharSequence)oldContent, (CharSequence)content, (int)oldLine, (boolean)true);
                        }
                        catch (FilesTooBigForDiffException filesTooBigForDiffException) {
                            // empty catch block
                        }
                    }
                    fileAnnotationRef.set((Object)fileAnnotation);
                    newLineRef.set((Object)newLine);
                }
                catch (VcsException e) {
                    exceptionRef.set((Object)e);
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                AnnotateRevisionActionBase.getBackgroundableLock(vcs.getProject(), file2).unlock();
                if (!exceptionRef.isNull()) {
                    AbstractVcsHelper.getInstance((Project)this.myProject).showError((VcsException)((Object)exceptionRef.get()), VcsBundle.message((String)"operation.name.annotate", (Object[])new Object[0]));
                }
                if (fileAnnotationRef.isNull()) {
                    return;
                }
                AbstractVcsHelper.getInstance((Project)this.myProject).showAnnotation((FileAnnotation)fileAnnotationRef.get(), file2, vcs, ((Integer)newLineRef.get()).intValue());
            }
        });
    }

    @NotNull
    private static BackgroundableActionLock getBackgroundableLock(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase", "getBackgroundableLock"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase", "getBackgroundableLock"));
        }
        BackgroundableActionLock backgroundableActionLock = AnnotateToggleAction.getBackgroundableLock(project2, file2);
        if (backgroundableActionLock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase", "getBackgroundableLock"));
        }
        return backgroundableActionLock;
    }
}

