/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ControlledCycle;
import com.intellij.openapi.vcs.changes.RemoteRevisionsNumbersCache;
import com.intellij.openapi.vcs.changes.RemoteRevisionsStateCache;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.Consumer;
import com.intellij.util.PlusMinus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class RemoteRevisionsCache
implements PlusMinus<Pair<String, AbstractVcs>>,
VcsListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.RemoteRevisionsCache");
    public static Topic<Runnable> REMOTE_VERSION_CHANGED = new Topic("REMOTE_VERSION_CHANGED", Runnable.class);
    public static final int DEFAULT_REFRESH_INTERVAL = 180000;
    private final RemoteRevisionsNumbersCache myRemoteRevisionsNumbersCache;
    private final RemoteRevisionsStateCache myRemoteRevisionsStateCache;
    private final ProjectLevelVcsManager myVcsManager;
    private final RemoteStatusChangeNodeDecorator myChangeDecorator;
    private final Project myProject;
    private final Object myLock;
    private final Map<String, RemoteDifferenceStrategy> myKinds;
    private final ControlledCycle myControlledCycle;

    public static RemoteRevisionsCache getInstance(Project project2) {
        return (RemoteRevisionsCache)PeriodicalTasksCloser.getInstance().safeGetService(project2, RemoteRevisionsCache.class);
    }

    private RemoteRevisionsCache(Project project2) {
        this.myProject = project2;
        this.myLock = new Object();
        this.myRemoteRevisionsNumbersCache = new RemoteRevisionsNumbersCache(this.myProject);
        this.myRemoteRevisionsStateCache = new RemoteRevisionsStateCache(this.myProject);
        this.myChangeDecorator = new RemoteStatusChangeNodeDecorator(this);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, (Object)this);
        this.myKinds = new HashMap<String, RemoteDifferenceStrategy>();
        final VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myControlledCycle = new ControlledCycle(project2, new Getter<Boolean>(){

            public Boolean get() {
                boolean shouldBeDone;
                boolean bl = shouldBeDone = vcsConfiguration.isChangedOnServerEnabled() && RemoteRevisionsCache.this.myVcsManager.hasActiveVcss();
                if (shouldBeDone) {
                    boolean somethingChanged = RemoteRevisionsCache.this.myRemoteRevisionsNumbersCache.updateStep();
                    if (somethingChanged |= RemoteRevisionsCache.this.myRemoteRevisionsStateCache.updateStep()) {
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                if (!RemoteRevisionsCache.this.myProject.isDisposed()) {
                                    ((Runnable)RemoteRevisionsCache.this.myProject.getMessageBus().syncPublisher(REMOTE_VERSION_CHANGED)).run();
                                }
                            }
                        });
                    }
                }
                return shouldBeDone;
            }
        }, "Finishing \"changed on server\" update", 180000);
        this.updateRoots();
        if (!this.myProject.isDefault() && vcsConfiguration.isChangedOnServerEnabled()) {
            ((ProjectLevelVcsManagerImpl)this.myVcsManager).addInitializationRequest(VcsInitObject.REMOTE_REVISIONS_CACHE, new Runnable(){

                @Override
                public void run() {
                    if (!RemoteRevisionsCache.this.myVcsManager.hasActiveVcss() || !vcsConfiguration.isChangedOnServerEnabled()) {
                        return;
                    }
                    RemoteRevisionsCache.this.myControlledCycle.startIfNotStarted(-1);
                }
            });
        }
    }

    public void updateAutomaticRefreshAlarmState(boolean remoteCacheStateChanged) {
        this.manageAlarm();
    }

    private void manageAlarm() {
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        if (!this.myProject.isDefault() && this.myVcsManager.hasActiveVcss() && vcsConfiguration.isChangedOnServerEnabled()) {
            this.myControlledCycle.startIfNotStarted(-1);
        } else {
            this.myControlledCycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRoots() {
        VcsRoot[] roots = this.myVcsManager.getAllVcsRoots();
        Object object = this.myLock;
        synchronized (object) {
            for (VcsRoot root : roots) {
                AbstractVcs vcs = root.getVcs();
                if (this.myKinds.containsKey(vcs.getName())) continue;
                this.myKinds.put(vcs.getName(), vcs.getRemoteDifferenceStrategy());
            }
        }
    }

    public void directoryMappingChanged() {
        if (!VcsConfiguration.getInstance((Project)this.myProject).isChangedOnServerEnabled()) {
            this.manageAlarm();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        RemoteRevisionsCache.this.updateRoots();
                        RemoteRevisionsCache.this.myRemoteRevisionsNumbersCache.directoryMappingChanged();
                        RemoteRevisionsCache.this.myRemoteRevisionsStateCache.directoryMappingChanged();
                        RemoteRevisionsCache.this.manageAlarm();
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void plus(Pair<String, AbstractVcs> pair) {
        AbstractVcs vcs = (AbstractVcs)pair.getSecond();
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)vcs.getRemoteDifferenceStrategy())) {
            this.myRemoteRevisionsStateCache.plus(pair);
        } else {
            this.myRemoteRevisionsNumbersCache.plus(pair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(UpdatedFiles updatedFiles) {
        HashMap<String, RemoteDifferenceStrategy> strategyMap;
        Object object = this.myLock;
        synchronized (object) {
            strategyMap = new HashMap<String, RemoteDifferenceStrategy>(this.myKinds);
        }
        final LinkedList<String> newForTree = new LinkedList<String>();
        final LinkedList<String> newForUsual = new LinkedList<String>();
        UpdateFilesHelper.iterateAffectedFiles(updatedFiles, new Consumer<Couple<String>>(){

            public void consume(Couple<String> pair) {
                String vcsName = (String)pair.getSecond();
                RemoteDifferenceStrategy strategy = (RemoteDifferenceStrategy)strategyMap.get(vcsName);
                if (strategy == null) {
                    AbstractVcs vcs = RemoteRevisionsCache.this.myVcsManager.findVcsByName(vcsName);
                    if (vcs == null) {
                        return;
                    }
                    strategy = vcs.getRemoteDifferenceStrategy();
                }
                if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)strategy)) {
                    newForTree.add(pair.getFirst());
                } else {
                    newForUsual.add(pair.getFirst());
                }
            }
        });
        this.myRemoteRevisionsStateCache.invalidate(newForTree);
        this.myRemoteRevisionsNumbersCache.invalidate(newForUsual);
    }

    public void minus(Pair<String, AbstractVcs> pair) {
        AbstractVcs vcs = (AbstractVcs)pair.getSecond();
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)vcs.getRemoteDifferenceStrategy())) {
            this.myRemoteRevisionsStateCache.minus(pair);
        } else {
            this.myRemoteRevisionsNumbersCache.minus(pair);
        }
    }

    public boolean isUpToDate(Change change) {
        AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)change, (Project)this.myProject);
        if (vcs == null) {
            return true;
        }
        RemoteDifferenceStrategy strategy = vcs.getRemoteDifferenceStrategy();
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)strategy)) {
            return this.myRemoteRevisionsStateCache.isUpToDate(change);
        }
        return this.myRemoteRevisionsNumbersCache.isUpToDate(change);
    }

    public RemoteStatusChangeNodeDecorator getChangesNodeDecorator() {
        return this.myChangeDecorator;
    }
}

