/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesPanel;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;

public class ClearCommittedAction
extends AnAction
implements DumbAware {
    public ClearCommittedAction() {
        super("Clear", "Clears cached revisions", AllIcons.Vcs.Remove);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        CommittedChangesPanel panel = ChangesViewContentManager.getInstance(project2).getActiveComponent(CommittedChangesPanel.class);
        assert (panel != null);
        if (panel.isInLoad()) {
            return;
        }
        if (panel.getRepositoryLocation() == null) {
            panel.clearCaches();
        }
    }

    public void update(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 != null) {
            CommittedChangesPanel panel = ChangesViewContentManager.getInstance(project2).getActiveComponent(CommittedChangesPanel.class);
            RepositoryLocation rl = panel == null ? null : panel.getRepositoryLocation();
            e.getPresentation().setVisible(rl == null);
            e.getPresentation().setEnabled(panel != null && !panel.isInLoad());
        } else {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
        }
    }
}

