/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterKey;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterPriority;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureFilteringStrategy
implements ChangeListFilteringStrategy {
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private MyUI myUI;
    private final Project myProject;
    private final List<FilePath> mySelection = new ArrayList<FilePath>();

    public StructureFilteringStrategy(Project project2) {
        this.myProject = project2;
    }

    public CommittedChangesFilterKey getKey() {
        return new CommittedChangesFilterKey(this.toString(), CommittedChangesFilterPriority.STRUCTURE);
    }

    public String toString() {
        return VcsBundle.message((String)"filter.structure.name", (Object[])new Object[0]);
    }

    @Nullable
    public JComponent getFilterUI() {
        if (this.myUI == null) {
            this.myUI = new MyUI();
        }
        return this.myUI.getComponent();
    }

    public void setFilterBase(List<CommittedChangeList> changeLists) {
        if (this.myUI == null) {
            this.myUI = new MyUI();
        }
        this.myUI.reset();
        this.myUI.append(changeLists);
    }

    public void addChangeListener(ChangeListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeChangeListener(ChangeListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void resetFilterBase() {
        this.myUI.reset();
    }

    public void appendFilterBase(List<CommittedChangeList> changeLists) {
        this.myUI.append(changeLists);
    }

    @NotNull
    public List<CommittedChangeList> filterChangeLists(List<CommittedChangeList> changeLists) {
        if (this.mySelection.size() == 0) {
            List<CommittedChangeList> list = changeLists;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/StructureFilteringStrategy", "filterChangeLists"));
            }
            return list;
        }
        ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
        for (CommittedChangeList list : changeLists) {
            if (!this.listMatchesSelection(list)) continue;
            result.add(list);
        }
        ArrayList<CommittedChangeList> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/StructureFilteringStrategy", "filterChangeLists"));
        }
        return arrayList;
    }

    private boolean listMatchesSelection(CommittedChangeList list) {
        for (Change change : list.getChanges()) {
            FilePath path = ChangesUtil.getFilePath((Change)change);
            for (FilePath selPath : this.mySelection) {
                if (!path.isUnder(selPath, false)) continue;
                return true;
            }
        }
        return false;
    }

    private class MyUI {
        private final JComponent myScrollPane;
        private final Tree myStructureTree = new Tree();
        private boolean myRendererInitialized;
        private final TreeModelBuilder myBuilder;
        private TreeState myState;

        public MyUI() {
            this.myStructureTree.setRootVisible(false);
            this.myStructureTree.setShowsRootHandles(true);
            this.myStructureTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    ArrayList filePaths = new ArrayList(StructureFilteringStrategy.this.mySelection);
                    StructureFilteringStrategy.this.mySelection.clear();
                    TreePath[] selectionPaths = MyUI.this.myStructureTree.getSelectionPaths();
                    if (selectionPaths != null) {
                        for (TreePath selectionPath : selectionPaths) {
                            Collections.addAll(StructureFilteringStrategy.this.mySelection, ((ChangesBrowserNode)selectionPath.getLastPathComponent()).getFilePathsUnder());
                        }
                    }
                    if (Comparing.haveEqualElements(filePaths, (Collection)StructureFilteringStrategy.this.mySelection)) {
                        return;
                    }
                    for (ChangeListener listener2 : StructureFilteringStrategy.this.myListeners) {
                        listener2.stateChanged(new ChangeEvent(this));
                    }
                }
            });
            this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myStructureTree);
            this.myBuilder = new TreeModelBuilder(StructureFilteringStrategy.this.myProject, false);
        }

        public void initRenderer() {
            if (!this.myRendererInitialized) {
                this.myRendererInitialized = true;
                this.myStructureTree.setCellRenderer((TreeCellRenderer)((Object)new ChangesBrowserNodeRenderer(StructureFilteringStrategy.this.myProject, false, false)));
            }
        }

        public JComponent getComponent() {
            return this.myScrollPane;
        }

        public void reset() {
            this.myState = TreeState.createOn((JTree)this.myStructureTree, (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myStructureTree.getModel().getRoot()));
            this.myStructureTree.setModel((TreeModel)this.myBuilder.clearAndGetModel());
        }

        public void append(List<CommittedChangeList> changeLists) {
            TreeState localState = this.myState != null && this.myBuilder.isEmpty() ? this.myState : TreeState.createOn((JTree)this.myStructureTree, (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myStructureTree.getModel().getRoot()));
            HashSet<FilePath> filePaths = new HashSet<FilePath>();
            for (CommittedChangeList changeList : changeLists) {
                for (Change change : changeList.getChanges()) {
                    FilePath path = ChangesUtil.getFilePath((Change)change);
                    if (path.getParentPath() == null) continue;
                    filePaths.add(path.getParentPath());
                }
            }
            DefaultTreeModel model = this.myBuilder.buildModelFromFilePaths(filePaths);
            this.myStructureTree.setModel((TreeModel)model);
            localState.applyTo((JTree)this.myStructureTree, (DefaultMutableTreeNode)this.myStructureTree.getModel().getRoot());
            this.myStructureTree.revalidate();
            this.myStructureTree.repaint();
            this.initRenderer();
        }
    }
}

