/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.dbCommitted;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.CollectionSplitter;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.changes.dbCommitted.CacheJdbcConnection;
import com.intellij.openapi.vcs.changes.dbCommitted.ChangeTypeEnum;
import com.intellij.openapi.vcs.changes.dbCommitted.DbSettings;
import com.intellij.openapi.vcs.changes.dbCommitted.KnownRepositoryLocations;
import com.intellij.openapi.vcs.changes.dbCommitted.PathState;
import com.intellij.openapi.vcs.changes.dbCommitted.RevisionId;
import com.intellij.openapi.vcs.changes.dbCommitted.SelectListsQueryHelper;
import com.intellij.openapi.vcs.changes.dbCommitted.SqliteTables;
import com.intellij.openapi.vcs.changes.dbCommitted.SqliteUtil;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.DataOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class VcsSqliteLayer {
    private static final int ourLastPathRevisionBatchSize = 10;
    private final KnownRepositoryLocations myKnownRepositoryLocations;
    private final CacheJdbcConnection myConnection;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.dbCommitted.VcsSqliteLayer");

    public VcsSqliteLayer(Project project2, KnownRepositoryLocations locations) {
        this.myKnownRepositoryLocations = locations;
        this.myConnection = new CacheJdbcConnection(DbSettings.getDbFilePath(project2), new ThrowableConsumer<Connection, VcsException>(){

            public void consume(Connection connection) throws VcsException {
                VcsSqliteLayer.this.initDb(connection);
            }
        });
    }

    private void initDb(Connection connection) throws VcsException {
        try {
            connection.createStatement().execute(VcsSqliteLayer.createStatementForTable(SqliteTables.KNOWN_VCS));
            connection.createStatement().execute(VcsSqliteLayer.createStatementForTable(SqliteTables.ROOT));
            connection.createStatement().execute(VcsSqliteLayer.createStatementForTable(SqliteTables.AUTHOR));
            connection.createStatement().execute(VcsSqliteLayer.createStatementForTable(SqliteTables.REVISION));
            connection.createStatement().execute(VcsSqliteLayer.createStatementForTable(SqliteTables.PATHS));
            connection.createStatement().execute(VcsSqliteLayer.createStatementForTable(SqliteTables.PATHS_2_REVS));
            connection.createStatement().execute(VcsSqliteLayer.createStatementForTable(SqliteTables.INCOMING_PATHS));
            connection.createStatement().execute("CREATE INDEX IDX_ROOT_URL ON ROOT (URL)");
            connection.createStatement().execute("CREATE INDEX VCS_FK ON ROOT (VCS_FK)");
            connection.createStatement().execute("CREATE INDEX IDX_AUTHOR_NAME ON AUTHOR (NAME)");
            connection.createStatement().execute("CREATE INDEX IDX_REVISION_DATE ON REVISION (DATE)");
            connection.createStatement().execute("CREATE INDEX IDX_REVISION_NUMBER_INT ON REVISION (NUMBER_INT)");
            connection.createStatement().execute("CREATE INDEX IDX_PATHS_PATH ON PATHS (PATH)");
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public void checkVcsRootsAreTracked(MultiMap<String, String> vcses) throws VcsException {
        Set<Long> rootIdsToCheck;
        if (vcses.isEmpty()) {
            return;
        }
        MultiMap copy = new MultiMap();
        copy.putAllValues(vcses);
        if (!this.checkForInMemory((MultiMap<String, String>)copy)) {
            return;
        }
        HashSet<String> vcsNamesSet = new HashSet<String>(vcses.keySet());
        Iterator iterator = vcsNamesSet.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!this.myKnownRepositoryLocations.exists(key)) continue;
            iterator.remove();
        }
        if (!vcsNamesSet.isEmpty()) {
            this.ensureVcsAreInDB(vcsNamesSet);
        }
        if (!(rootIdsToCheck = this.ensurePathsAreInDB((MultiMap<String, String>)copy)).isEmpty()) {
            this.updateLastRevisions(rootIdsToCheck);
        }
    }

    private void updateLastRevisions(Set<Long> rootIdsToCheck) throws VcsException {
        PreparedStatement maxStatement = this.myConnection.getOrCreatePreparedStatement("PREPARED_SELECT_MAX_REVISION", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

            public PreparedStatement convert(Connection connection) throws SQLException {
                String num = SqliteTables.REVISION.NUMBER_INT;
                return connection.prepareStatement("SELECT " + num + "MAX_REV, " + SqliteTables.REVISION.DATE + "MAX_DATE FROM " + SqliteTables.REVISION.TABLE_NAME + " WHERE MAX_REV=(" + " SELECT MAX(" + num + ")  FROM " + SqliteTables.REVISION.TABLE_NAME + " WHERE " + SqliteTables.REVISION.ROOT_FK + " =?");
            }
        });
        PreparedStatement minStatement = this.myConnection.getOrCreatePreparedStatement("PREPARED_SELECT_MIN_REVISION", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

            public PreparedStatement convert(Connection connection) throws SQLException {
                String num = SqliteTables.REVISION.NUMBER_INT;
                return connection.prepareStatement("SELECT " + num + "MIN_REV, " + SqliteTables.REVISION.DATE + "MIN_DATE FROM " + SqliteTables.REVISION.TABLE_NAME + " WHERE MIN_REV=(" + " SELECT MIN(" + num + ")  FROM " + SqliteTables.REVISION.TABLE_NAME + " WHERE " + SqliteTables.REVISION.ROOT_FK + " =?");
            }
        });
        try {
            for (final Long id : rootIdsToCheck) {
                maxStatement.setLong(1, id);
                final ResultSet set = maxStatement.executeQuery();
                SqliteUtil.readSelectResults(set, new ThrowableRunnable<SQLException>(){

                    public void run() throws SQLException {
                        long max = set.getLong(1);
                        long time = set.getLong(2);
                        if (max > 0L) {
                            VcsSqliteLayer.this.myKnownRepositoryLocations.setLastRevision(id, new RevisionId(max, time));
                        }
                    }
                });
                minStatement.setLong(1, id);
                final ResultSet setMin = minStatement.executeQuery();
                SqliteUtil.readSelectResults(setMin, new ThrowableRunnable<SQLException>(){

                    public void run() throws SQLException {
                        long min = setMin.getLong(1);
                        long time = setMin.getLong(2);
                        if (min > 0L) {
                            VcsSqliteLayer.this.myKnownRepositoryLocations.setFirstRevision(id, new RevisionId(min, time));
                        }
                    }
                });
            }
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private Set<Long> ensurePathsAreInDB(final MultiMap<String, String> copy) throws VcsException {
        final HashSet<Long> idsToCheck = new HashSet<Long>();
        PreparedStatement select = this.myConnection.getOrCreatePreparedStatement("PREPARED_SELECT_ROOTS", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

            public PreparedStatement convert(Connection connection) throws SQLException {
                return connection.prepareStatement("SELECT * FROM " + SqliteTables.ROOT.TABLE_NAME + " WHERE VCS_FK=?");
            }
        });
        try {
            for (final String vcsName : copy.keySet()) {
                select.setLong(1, this.myKnownRepositoryLocations.getVcsKey(vcsName));
                final ResultSet set = select.executeQuery();
                SqliteUtil.readSelectResults(set, new ThrowableRunnable<SQLException>(){

                    public void run() throws SQLException {
                        long id = set.getLong(SqliteTables.ROOT.ID);
                        String url = set.getString(SqliteTables.ROOT.URL);
                        VcsSqliteLayer.this.myKnownRepositoryLocations.add(vcsName, url, id);
                        copy.remove((Object)vcsName, (Object)url);
                        if (VcsSqliteLayer.this.myKnownRepositoryLocations.getLastRevision(id) == null) {
                            idsToCheck.add(id);
                        }
                    }
                });
            }
            if (copy.isEmpty()) {
                return idsToCheck;
            }
            PreparedStatement insert = this.myConnection.getOrCreatePreparedStatement("PREPARED_INSERT_ROOT", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

                public PreparedStatement convert(Connection connection) throws SQLException {
                    return connection.prepareStatement("INSERT INTO " + SqliteTables.ROOT.TABLE_NAME + " ( " + SqliteTables.ROOT.VCS_FK + ", " + SqliteTables.ROOT.URL + ") VALUES (?,?)", 1);
                }
            });
            for (String vcsName : copy.keySet()) {
                insert.setLong(1, this.myKnownRepositoryLocations.getVcsKey(vcsName));
                for (String path : copy.get((Object)vcsName)) {
                    insert.setString(2, path);
                    long id = SqliteUtil.insert(insert);
                    this.myKnownRepositoryLocations.add(vcsName, path, id);
                }
            }
            this.myConnection.commit();
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
        return idsToCheck;
    }

    private void ensureVcsAreInDB(final HashSet<String> vcsNamesSet) throws VcsException {
        PreparedStatement readVcses = this.myConnection.getOrCreatePreparedStatement("PREPARED_SELECT_VCS", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

            public PreparedStatement convert(Connection o) throws SQLException {
                return o.prepareStatement("SELECT * FROM VCS");
            }
        });
        try {
            final ResultSet set = readVcses.executeQuery();
            SqliteUtil.readSelectResults(set, new ThrowableRunnable<SQLException>(){

                public void run() throws SQLException {
                    long id = set.getLong(SqliteTables.KNOWN_VCS.ID);
                    String name = set.getString(SqliteTables.KNOWN_VCS.NAME);
                    VcsSqliteLayer.this.myKnownRepositoryLocations.addVcs(name, id);
                    vcsNamesSet.remove(name);
                }
            });
            if (vcsNamesSet.isEmpty()) {
                return;
            }
            PreparedStatement insertStatement = this.myConnection.getOrCreatePreparedStatement("PREPARED_INSERT_VCS", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

                public PreparedStatement convert(Connection o) throws SQLException {
                    return o.prepareStatement("INSERT INTO " + SqliteTables.KNOWN_VCS.TABLE_NAME + " (" + SqliteTables.KNOWN_VCS.NAME + ") VALUES (?)", 1);
                }
            });
            for (String name : vcsNamesSet) {
                insertStatement.setString(1, name);
                long id = SqliteUtil.insert(insertStatement);
                this.myKnownRepositoryLocations.addVcs(name, id);
            }
            this.myConnection.commit();
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private boolean checkForInMemory(MultiMap<String, String> map) {
        for (String vcsName : map.keySet()) {
            Collection paths = map.get((Object)vcsName);
            Iterator iterator = paths.iterator();
            while (iterator.hasNext()) {
                String path = (String)iterator.next();
                if (!this.myKnownRepositoryLocations.exists(vcsName, path)) continue;
                iterator.remove();
            }
        }
        for (String paths : map.values()) {
            if (paths.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static String createStatementForTable(SqliteTables.BaseTable baseTable) {
        return "CREATE TABLE " + baseTable.TABLE_NAME + " ( ID INTEGER PRIMARY KEY, " + baseTable.getCreateTableStatement() + ");";
    }

    public void appendLists(AbstractVcs vcs, String root, List<CommittedChangeList> lists) throws VcsException {
        if (lists.isEmpty()) {
            return;
        }
        assert (this.myKnownRepositoryLocations.exists(vcs.getName(), root));
        long locationId = this.myKnownRepositoryLocations.getLocationId(vcs.getName(), root);
        long maxRev = -1L;
        long minRev = Long.MAX_VALUE;
        long maxTime = -1L;
        long minTime = -1L;
        RevisionId firstRevData = this.myKnownRepositoryLocations.getFirstRevision(locationId);
        Long firstRevision = firstRevData == null ? null : Long.valueOf(firstRevData.getNumber());
        RevisionId lastRevData = this.myKnownRepositoryLocations.getLastRevision(locationId);
        Long lastRevision = lastRevData == null ? null : Long.valueOf(lastRevData.getNumber());
        List split = new CollectionSplitter(20).split(lists);
        HashMap<String, Long> knowPaths = new HashMap<String, Long>();
        for (List changeLists : split) {
            HashSet<String> names = new HashSet<String>();
            HashSet<String> paths = new HashSet<String>();
            Iterator iterator = changeLists.iterator();
            while (iterator.hasNext()) {
                CommittedChangeList list = (CommittedChangeList)iterator.next();
                long number = list.getNumber();
                if (lastRevision != null && number <= lastRevision && number >= firstRevision) {
                    iterator.remove();
                    continue;
                }
                if (number > maxRev) {
                    maxRev = number;
                    maxTime = list.getCommitDate().getTime();
                }
                if (number < minRev) {
                    minRev = number;
                    minTime = list.getCommitDate().getTime();
                }
                names.add(list.getCommitterName());
                for (Change change : list.getChangesWithMovedTrees()) {
                    if (change.getBeforeRevision() != null) {
                        paths.add(this.getPath(change.getBeforeRevision()));
                    }
                    if (change.getAfterRevision() == null) continue;
                    paths.add(this.getPath(change.getAfterRevision()));
                }
            }
            Map<String, Long> knownAuthors = this.myKnownRepositoryLocations.filterKnownAuthors(names);
            this.checkAndAddAuthors(names, knownAuthors);
            this.checkAndAddPaths(paths, knowPaths, locationId);
            this.insertChangeListsIfNotExists(vcs, knownAuthors, changeLists, locationId, knowPaths);
            if (firstRevision == null || minRev < firstRevision) {
                this.myKnownRepositoryLocations.setFirstRevision(locationId, new RevisionId(minRev, minTime));
            }
            if (lastRevision != null && maxRev <= lastRevision) continue;
            this.myKnownRepositoryLocations.setLastRevision(locationId, new RevisionId(maxRev, maxTime));
        }
    }

    private String getPath(ContentRevision revision) {
        String path = FileUtil.toSystemIndependentName((String)revision.getFile().getPath());
        return path.endsWith("/") ? path : path + "/";
    }

    private Map<Long, CommittedChangeList> insertChangeListsIfNotExists(AbstractVcs vcs, Map<String, Long> authors, List<CommittedChangeList> lists, long locationId, Map<String, Long> knowPaths) throws VcsException {
        PreparedStatement statement2 = this.myConnection.getOrCreatePreparedStatement("PREPARED_INSERT_REVISION", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

            public PreparedStatement convert(Connection connection) throws SQLException {
                return connection.prepareStatement("INSERT INTO " + SqliteTables.REVISION.TABLE_NAME + " ( " + StringUtil.join(Arrays.asList(SqliteTables.REVISION.ROOT_FK, SqliteTables.REVISION.AUTHOR_FK, SqliteTables.REVISION.DATE, SqliteTables.REVISION.NUMBER_INT, SqliteTables.REVISION.NUMBER_STR, SqliteTables.REVISION.COMMENT, SqliteTables.REVISION.COUNT, SqliteTables.REVISION.RAW_DATA), (String)", ") + ") VALUES (?,?,?,?,?,?,?,?)", 1);
            }
        });
        HashMap<Long, CommittedChangeList> result = new HashMap<Long, CommittedChangeList>();
        CachingCommittedChangesProvider provider = (CachingCommittedChangesProvider)vcs.getCommittedChangesProvider();
        try {
            statement2.setLong(1, locationId);
            for (CommittedChangeList list : lists) {
                statement2.setLong(2, authors.get(list.getCommitterName()));
                statement2.setLong(3, list.getCommitDate().getTime());
                statement2.setLong(4, list.getNumber());
                statement2.setString(5, String.valueOf(list.getNumber()));
                statement2.setString(6, list.getComment());
                statement2.setLong(7, list.getChanges().size());
                BufferExposingByteArrayOutputStream stream = new BufferExposingByteArrayOutputStream();
                provider.writeChangeList((DataOutput)new DataOutputStream((OutputStream)stream), list);
                statement2.setBytes(8, stream.toByteArray());
                long id = SqliteUtil.insert(statement2);
                result.put(id, list);
                this.insertPathsChanges(knowPaths, list, id);
            }
            this.myConnection.commit();
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
        return result;
    }

    private void insertPathsChanges(Map<String, Long> paths, CommittedChangeList list, long listId) throws VcsException {
        PreparedStatement insert = this.myConnection.getOrCreatePreparedStatement("PREPARED_INSERT_PATH_2_REVS", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

            public PreparedStatement convert(Connection connection) throws SQLException {
                return connection.prepareStatement("INSERT INTO " + SqliteTables.PATHS_2_REVS.TABLE_NAME + " ( " + StringUtil.join(Arrays.asList(SqliteTables.PATHS_2_REVS.PATH_FK, SqliteTables.PATHS_2_REVS.REVISION_FK, SqliteTables.PATHS_2_REVS.TYPE, SqliteTables.PATHS_2_REVS.COPY_PATH_ID, SqliteTables.PATHS_2_REVS.DELETE_PATH_ID, SqliteTables.PATHS_2_REVS.VISIBLE), (String)" , ") + ") VALUES (?,?,?,?,?,?)", 1);
            }
        });
        try {
            insert.setLong(2, listId);
            Collection withMoved = list.getChangesWithMovedTrees();
            HashSet simple = new HashSet(list.getChanges());
            for (Change change : withMoved) {
                this.insertOneChange(paths, insert, change, simple.contains(change));
            }
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private void insertOneChange(Map<String, Long> paths, PreparedStatement insert, Change change, boolean visible) throws SQLException {
        insert.setLong(6, visible ? 1L : 0L);
        ChangeTypeEnum type = ChangeTypeEnum.getChangeType(change);
        if (change.getBeforeRevision() == null) {
            insert.setLong(1, paths.get(this.getPath(change.getAfterRevision())));
            insert.setLong(3, type.getCode());
            SqliteUtil.insert(insert);
        } else if (ChangeTypeEnum.MOVE.equals((Object)type)) {
            Long beforeId = paths.get(this.getPath(change.getBeforeRevision()));
            insert.setLong(1, beforeId);
            insert.setLong(3, ChangeTypeEnum.DELETE.getCode());
            SqliteUtil.insert(insert);
            insert.setLong(1, paths.get(this.getPath(change.getAfterRevision())));
            insert.setLong(4, beforeId);
            insert.setLong(3, type.getCode());
            SqliteUtil.insert(insert);
        } else if (change.getAfterRevision() == null) {
            insert.setLong(1, paths.get(this.getPath(change.getBeforeRevision())));
            insert.setLong(3, type.getCode());
            SqliteUtil.insert(insert);
        } else {
            insert.setLong(1, paths.get(this.getPath(change.getAfterRevision())));
            insert.setLong(3, type.getCode());
            SqliteUtil.insert(insert);
        }
    }

    private void checkAndAddPaths(Set<String> paths, final Map<String, Long> known, Long locationId) throws VcsException {
        PreparedStatement select = this.myConnection.getOrCreatePreparedStatement("PREPARED_READ_PATH", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

            public PreparedStatement convert(Connection connection) throws SQLException {
                return connection.prepareStatement("SELECT " + SqliteTables.PATHS.ID + " FROM " + SqliteTables.PATHS.TABLE_NAME + " WHERE " + SqliteTables.PATHS.ROOT_FK + " = ? AND " + SqliteTables.PATHS.PATH + " = ?");
            }
        });
        try {
            select.setLong(1, locationId);
            for (final String path : paths) {
                select.setString(2, path);
                final ResultSet set = select.executeQuery();
                SqliteUtil.readSelectResults(set, new ThrowableRunnable<SQLException>(){

                    public void run() throws SQLException {
                        known.put(path, set.getLong(1));
                    }
                });
            }
            paths.removeAll(known.keySet());
            if (paths.isEmpty()) {
                return;
            }
            PreparedStatement insert = this.myConnection.getOrCreatePreparedStatement("PREPARED_INSERT_PATH", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

                public PreparedStatement convert(Connection connection) throws SQLException {
                    return connection.prepareStatement("INSERT INTO " + SqliteTables.PATHS.TABLE_NAME + " ( " + SqliteTables.PATHS.ROOT_FK + " , " + SqliteTables.PATHS.PATH + " ) VALUES (?,?)", 1);
                }
            });
            insert.setLong(1, locationId);
            for (String path : paths) {
                insert.setString(2, path);
                long id = SqliteUtil.insert(insert);
                known.put(path, id);
            }
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private void checkAndAddAuthors(Set<String> names, final Map<String, Long> known) throws VcsException {
        PreparedStatement statement2 = this.myConnection.getOrCreatePreparedStatement("PREPARED_FILTER_KNOWN_AUTHORS", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

            public PreparedStatement convert(Connection connection) throws SQLException {
                return connection.prepareStatement("SELECT " + SqliteTables.AUTHOR.ID + ", " + SqliteTables.AUTHOR.NAME + " FROM " + SqliteTables.AUTHOR.TABLE_NAME + " WHERE " + SqliteTables.AUTHOR.NAME + "=?");
            }
        });
        try {
            final Iterator<String> iterator = names.iterator();
            while (iterator.hasNext()) {
                final String name = iterator.next();
                statement2.setString(1, name);
                final ResultSet set = statement2.executeQuery();
                SqliteUtil.readSelectResults(set, new ThrowableRunnable<SQLException>(){

                    public void run() throws SQLException {
                        long id = set.getLong(SqliteTables.AUTHOR.ID);
                        VcsSqliteLayer.this.myKnownRepositoryLocations.addKnownAuthor(name, id);
                        known.put(name, id);
                        iterator.remove();
                    }
                });
            }
            if (names.isEmpty()) {
                return;
            }
            PreparedStatement insertAuthor = this.myConnection.getOrCreatePreparedStatement("PREPARED_ADD_AUTHOR", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

                public PreparedStatement convert(Connection connection) throws SQLException {
                    return connection.prepareStatement("INSERT INTO " + SqliteTables.AUTHOR.TABLE_NAME + " ( " + SqliteTables.AUTHOR.NAME + ") VALUES (?)", 1);
                }
            });
            for (String name : names) {
                insertAuthor.setString(1, name);
                long id = SqliteUtil.insert(insertAuthor);
                this.myKnownRepositoryLocations.addKnownAuthor(name, id);
                known.put(name, id);
            }
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @NotNull
    public RevisionId getFirstRevision(AbstractVcs vcs, String root) {
        String systemIndependent = FileUtil.toSystemIndependentName((String)root);
        if (!this.myKnownRepositoryLocations.exists(vcs.getName(), systemIndependent)) {
            RevisionId revisionId = RevisionId.FAKE;
            if (revisionId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/dbCommitted/VcsSqliteLayer", "getFirstRevision"));
            }
            return revisionId;
        }
        long locationId = this.myKnownRepositoryLocations.getLocationId(vcs.getName(), systemIndependent);
        RevisionId revisionId = this.myKnownRepositoryLocations.getFirstRevision(locationId);
        if (revisionId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/dbCommitted/VcsSqliteLayer", "getFirstRevision"));
        }
        return revisionId;
    }

    @NotNull
    public RevisionId getLastRevision(AbstractVcs vcs, String root) {
        String systemIndependent = FileUtil.toSystemIndependentName((String)root);
        if (!this.myKnownRepositoryLocations.exists(vcs.getName(), systemIndependent)) {
            RevisionId revisionId = RevisionId.FAKE;
            if (revisionId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/dbCommitted/VcsSqliteLayer", "getLastRevision"));
            }
            return revisionId;
        }
        long locationId = this.myKnownRepositoryLocations.getLocationId(vcs.getName(), systemIndependent);
        RevisionId revisionId = this.myKnownRepositoryLocations.getLastRevision(locationId);
        if (revisionId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/dbCommitted/VcsSqliteLayer", "getLastRevision"));
        }
        return revisionId;
    }

    public List<ReceivedChangeList> selectIncoming(AbstractVcs vcs, final RepositoryLocation location) throws VcsException {
        final HashMap full = new HashMap();
        final TreeMap incomingPaths = new TreeMap();
        long locationId = this.getLocationId(vcs, location);
        PreparedStatement select = this.myConnection.getOrCreatePreparedStatement("PREPARED_SELECT_INCOMING", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

            public PreparedStatement convert(Connection connection) throws SQLException {
                return connection.prepareStatement("SELECT R." + SqliteTables.REVISION.NUMBER_INT + " , R." + SqliteTables.REVISION.RAW_DATA + " , P." + SqliteTables.PATHS.PATH + " FROM " + SqliteTables.INCOMING_PATHS.TABLE_NAME + "I INNER JOIN " + SqliteTables.PATHS_2_REVS.TABLE_NAME + "PR ON I." + SqliteTables.INCOMING_PATHS.PR_FK + " = PR." + SqliteTables.PATHS_2_REVS.ID + ", " + SqliteTables.REVISION.TABLE_NAME + " R ON PR." + SqliteTables.PATHS_2_REVS.REVISION_FK + " = R." + SqliteTables.REVISION.ID + " , " + SqliteTables.PATHS_2_REVS.TABLE_NAME + "P ON PR." + SqliteTables.PATHS_2_REVS.PATH_FK + " = P." + SqliteTables.PATHS.ID + " WHERE R." + SqliteTables.REVISION.ROOT_FK + "=?");
            }
        });
        final CachingCommittedChangesProvider provider = vcs.getCachingCommittedChangesProvider();
        try {
            select.setLong(1, locationId);
            final ResultSet set = select.executeQuery();
            SqliteUtil.readSelectResults(set, new ThrowableRunnable<SQLException>(){

                public void run() throws SQLException {
                    long revNum = set.getLong("R." + SqliteTables.REVISION.NUMBER_INT);
                    HashSet<String> paths = (HashSet<String>)incomingPaths.get(revNum);
                    if (paths == null) {
                        byte[] bytes = set.getBytes("R." + SqliteTables.REVISION.RAW_DATA);
                        CommittedChangeList nativeList = VcsSqliteLayer.this.readListByProvider(bytes, provider, location);
                        full.put(revNum, nativeList);
                        paths = new HashSet<String>();
                        incomingPaths.put(revNum, paths);
                    }
                    String path = set.getString("P." + SqliteTables.PATHS.PATH);
                    paths.add(path);
                }
            });
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
        ArrayList result = new ArrayList();
        for (Map.Entry entry : incomingPaths.entrySet()) {
            Long l = (Long)entry.getKey();
        }
        return null;
    }

    private long getLocationId(AbstractVcs vcs, RepositoryLocation location) {
        String normalizedLocation = this.normalizeLocation(location);
        if (!this.myKnownRepositoryLocations.exists(vcs.getName(), normalizedLocation)) assert (false);
        return this.myKnownRepositoryLocations.getLocationId(vcs.getName(), normalizedLocation);
    }

    public void insertIncoming(AbstractVcs vcs, RepositoryLocation location, long pathId, long lastRev, long oldRev) throws VcsException {
        assert (lastRev > 0L || oldRev > 0L);
        long locationId = this.getLocationId(vcs, location);
        if (lastRev > 0L && oldRev > 0L) {
            PreparedStatement insertBoth = this.myConnection.getOrCreatePreparedStatement("PREPARED_INSERT_INCOMING", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

                public PreparedStatement convert(Connection connection) throws SQLException {
                    return connection.prepareStatement("INSERT INTO " + SqliteTables.INCOMING_PATHS.TABLE_NAME + " ( " + SqliteTables.INCOMING_PATHS.PR_FK + " ) VALUES (SELECT " + SqliteTables.PATHS_2_REVS.ID + " FROM " + SqliteTables.PATHS_2_REVS.TABLE_NAME + "PR INNER JOIN " + SqliteTables.REVISION.TABLE_NAME + " R ON R." + SqliteTables.REVISION.ID + "=PR." + SqliteTables.PATHS_2_REVS.REVISION_FK + " WHERE R." + SqliteTables.REVISION.NUMBER_INT + "<=? AND R." + SqliteTables.REVISION.NUMBER_INT + ">=? AND R." + SqliteTables.REVISION.ROOT_FK + "=? AND PR." + SqliteTables.PATHS_2_REVS.PATH_FK + "=?)");
                }
            });
            try {
                insertBoth.setLong(1, lastRev);
                insertBoth.setLong(2, oldRev);
                insertBoth.setLong(3, locationId);
                insertBoth.setLong(4, pathId);
                int numRows = insertBoth.executeUpdate();
                return;
            }
            catch (SQLException e) {
                throw new VcsException((Throwable)e);
            }
        }
        if (lastRev > 0L) {
            PreparedStatement insertOnlyLast = this.myConnection.getOrCreatePreparedStatement("PREPARED_INSERT_INCOMING", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

                public PreparedStatement convert(Connection connection) throws SQLException {
                    return connection.prepareStatement("INSERT INTO " + SqliteTables.INCOMING_PATHS.TABLE_NAME + " ( " + SqliteTables.INCOMING_PATHS.PR_FK + " ) VALUES (SELECT " + SqliteTables.PATHS_2_REVS.ID + " FROM " + SqliteTables.PATHS_2_REVS.TABLE_NAME + "PR INNER JOIN " + SqliteTables.REVISION.TABLE_NAME + " R ON R." + SqliteTables.REVISION.ID + "=PR." + SqliteTables.PATHS_2_REVS.REVISION_FK + " WHERE R." + SqliteTables.REVISION.NUMBER_INT + "<=? AND R." + SqliteTables.REVISION.ROOT_FK + "=? AND PR." + SqliteTables.PATHS_2_REVS.PATH_FK + "=?)");
                }
            });
            try {
                insertOnlyLast.setLong(1, lastRev);
                insertOnlyLast.setLong(2, locationId);
                insertOnlyLast.setLong(3, pathId);
                int numRows = insertOnlyLast.executeUpdate();
                return;
            }
            catch (SQLException e) {
                throw new VcsException((Throwable)e);
            }
        }
        PreparedStatement insertOnlyFirst = this.myConnection.getOrCreatePreparedStatement("PREPARED_INSERT_INCOMING", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

            public PreparedStatement convert(Connection connection) throws SQLException {
                return connection.prepareStatement("INSERT INTO " + SqliteTables.INCOMING_PATHS.TABLE_NAME + " ( " + SqliteTables.INCOMING_PATHS.PR_FK + " ) VALUES (SELECT " + SqliteTables.PATHS_2_REVS.ID + " FROM " + SqliteTables.PATHS_2_REVS.TABLE_NAME + "PR INNER JOIN " + SqliteTables.REVISION.TABLE_NAME + " R ON R." + SqliteTables.REVISION.ID + "=PR." + SqliteTables.PATHS_2_REVS.REVISION_FK + " WHERE R." + SqliteTables.REVISION.NUMBER_INT + ">=? AND R." + SqliteTables.REVISION.ROOT_FK + "=? AND PR." + SqliteTables.PATHS_2_REVS.PATH_FK + "=?)");
            }
        });
        try {
            insertOnlyFirst.setLong(1, oldRev);
            insertOnlyFirst.setLong(2, locationId);
            insertOnlyFirst.setLong(3, pathId);
            int numRows = insertOnlyFirst.executeUpdate();
            return;
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public List<CommittedChangeList> readLists(AbstractVcs vcs, final RepositoryLocation location, RevisionId last, RevisionId old, String subfolder) throws VcsException {
        String root = this.normalizeLocation(location);
        RevisionId lastExisitngData = this.getLastRevision(vcs, root);
        RevisionId firstExistingData = this.getFirstRevision(vcs, root);
        if (lastExisitngData.isFake() || firstExistingData.isFake()) {
            return Collections.emptyList();
        }
        SelectListsQueryHelper helper = new SelectListsQueryHelper(this.myConnection, lastExisitngData, firstExistingData, last, old, this.getLocationId(vcs, location), subfolder);
        final ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
        try {
            PreparedStatement statement2 = helper.createStatement();
            final CachingCommittedChangesProvider provider = (CachingCommittedChangesProvider)vcs.getCommittedChangesProvider();
            final ResultSet set = statement2.executeQuery();
            final HashSet controlSet = new HashSet();
            SqliteUtil.readSelectResults(set, new ThrowableRunnable<SQLException>(){

                public void run() throws SQLException {
                    long number = set.getLong(SqliteTables.REVISION.NUMBER_INT);
                    if (controlSet.contains(number)) {
                        return;
                    }
                    controlSet.add(number);
                    byte[] bytes = set.getBytes(SqliteTables.REVISION.RAW_DATA);
                    CommittedChangeList list = VcsSqliteLayer.this.readListByProvider(bytes, provider, location);
                    result.add(list);
                }
            });
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
        return result;
    }

    public List<CommittedChangeList> readLists(AbstractVcs vcs, final RepositoryLocation location, long lastRev, long oldRev) throws VcsException {
        String root = this.normalizeLocation(location);
        long lastExisting = this.getLastRevision(vcs, root).getNumber();
        long firstExisting = this.getFirstRevision(vcs, root).getNumber();
        if (lastExisting == -1L || firstExisting == -1L) {
            return Collections.emptyList();
        }
        long operatingFirst = oldRev == -1L ? firstExisting : oldRev;
        long operatingLast = lastRev == -1L ? lastExisting : lastRev;
        PreparedStatement statement2 = this.myConnection.getOrCreatePreparedStatement("PREPARED_SELECT_REVISIONS", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

            public PreparedStatement convert(Connection connection) throws SQLException {
                return connection.prepareStatement("SELECT * FROM " + SqliteTables.REVISION.TABLE_NAME + " WHERE " + SqliteTables.REVISION.NUMBER_INT + ">=? AND " + SqliteTables.REVISION.NUMBER_INT + "<=? ORDER BY " + SqliteTables.REVISION.NUMBER_INT + " DESC");
            }
        });
        final ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
        try {
            statement2.setLong(1, operatingFirst);
            statement2.setLong(2, operatingLast);
            final CachingCommittedChangesProvider provider = (CachingCommittedChangesProvider)vcs.getCommittedChangesProvider();
            final ResultSet set = statement2.executeQuery();
            SqliteUtil.readSelectResults(set, new ThrowableRunnable<SQLException>(){

                public void run() throws SQLException {
                    byte[] bytes = set.getBytes(SqliteTables.REVISION.RAW_DATA);
                    CommittedChangeList list = VcsSqliteLayer.this.readListByProvider(bytes, provider, location);
                    result.add(list);
                }
            });
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
        return result;
    }

    private CommittedChangeList readListByProvider(byte[] bytes, CachingCommittedChangesProvider provider, RepositoryLocation location) throws SQLException {
        CommittedChangeList list;
        try {
            list = provider.readChangeList(location, (DataInput)new DataInputStream(new ByteArrayInputStream(bytes)));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return list;
    }

    public PathState getPathState(AbstractVcs vcs, RepositoryLocation location, String path) throws VcsException {
        String normalizedPath = FileUtil.toSystemIndependentName((String)path);
        normalizedPath = normalizedPath.endsWith("/") ? normalizedPath : normalizedPath + "/";
        String normalizedLocation = this.normalizeLocation(location);
        if (!this.myKnownRepositoryLocations.exists(vcs.getName(), normalizedLocation)) {
            return null;
        }
        PreparedStatement maxStatement = this.myConnection.getOrCreatePreparedStatement("PREPARED_SELECT_PATH_DATA", new ThrowableConvertor<Connection, PreparedStatement, SQLException>(){

            public PreparedStatement convert(Connection connection) throws SQLException {
                String innerQuery = "SELECT MAX(R." + SqliteTables.REVISION.NUMBER_INT + ") MAX FROM " + SqliteTables.PATHS_2_REVS.TABLE_NAME + " PR INNER JOIN " + SqliteTables.REVISION.TABLE_NAME + " R, " + SqliteTables.PATHS.TABLE_NAME + " P ON PR." + SqliteTables.PATHS_2_REVS.REVISION_FK + "=R." + SqliteTables.REVISION.ID + " AND PR." + SqliteTables.PATHS_2_REVS.PATH_FK + "=P." + SqliteTables.PATHS.ID + " WHERE P." + SqliteTables.PATHS.PATH + "=? AND R." + SqliteTables.REVISION.ROOT_FK + "=?";
                return connection.prepareStatement("SELECT R." + SqliteTables.REVISION.NUMBER_INT + " REV_NU, PR." + SqliteTables.PATHS_2_REVS.TYPE + " TYPE FROM " + SqliteTables.PATHS_2_REVS.TABLE_NAME + " PR INNER JOIN " + SqliteTables.REVISION.TABLE_NAME + " R, " + SqliteTables.PATHS.TABLE_NAME + " P ON PR." + SqliteTables.PATHS_2_REVS.REVISION_FK + "=R." + SqliteTables.REVISION.ID + " AND PR." + SqliteTables.PATHS_2_REVS.PATH_FK + "=P." + SqliteTables.PATHS.ID + " WHERE P." + SqliteTables.PATHS.PATH + "=? AND R." + SqliteTables.REVISION.ROOT_FK + "=? AND R." + SqliteTables.REVISION.NUMBER_INT + " = (" + innerQuery + ")");
            }
        });
        try {
            maxStatement.setString(1, normalizedPath);
            maxStatement.setString(3, normalizedPath);
            long locationId = this.myKnownRepositoryLocations.getLocationId(vcs.getName(), normalizedLocation);
            maxStatement.setLong(2, locationId);
            maxStatement.setLong(4, locationId);
            final long[] type = new long[1];
            final long[] maxRev = new long[]{-1L};
            final ResultSet set = maxStatement.executeQuery();
            SqliteUtil.readSelectResults(set, new ThrowableRunnable<SQLException>(){

                public void run() throws SQLException {
                    maxRev[0] = set.getLong("REV_NU");
                    type[0] = set.getLong("TYPE");
                }
            });
            if (maxRev[0] <= 0L) {
                return null;
            }
            if (type[0] == -100L) {
                return null;
            }
            ChangeTypeEnum changeType = ChangeTypeEnum.getChangeType(type[0]);
            if (changeType == null) {
                return null;
            }
            return new PathState(maxRev[0], !ChangeTypeEnum.DELETE.equals((Object)changeType));
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private String normalizeLocation(RepositoryLocation location) {
        return FileUtil.toSystemIndependentName((String)location.toPresentableString());
    }
}

