/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class StaticFilePath {
    private final String myKey;
    private final String myPath;
    private final boolean myIsDirectory;
    private final VirtualFile myVf;

    public StaticFilePath(boolean isDirectory, String path, VirtualFile vf) {
        this.myIsDirectory = isDirectory;
        this.myPath = path;
        this.myVf = vf;
        this.myKey = FilePathsHelper.convertPath((String)path);
    }

    private StaticFilePath(boolean isDirectory, String path, String key, VirtualFile vf) {
        this.myIsDirectory = isDirectory;
        this.myPath = path;
        this.myVf = vf;
        this.myKey = key;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getKey() {
        return this.myKey;
    }

    public VirtualFile getVf() {
        return this.myVf;
    }

    @Nullable
    public StaticFilePath getParent() {
        int idx = this.myKey.lastIndexOf(47);
        return idx == -1 || idx == 0 ? null : new StaticFilePath(true, this.myPath.substring(0, idx), this.myKey.substring(0, idx), this.myVf == null ? null : this.myVf.getParent());
    }
}

