/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import com.intellij.openapi.vcs.checkout.ProjectCheckoutListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectCheckoutListener
implements CheckoutListener {
    private static final Logger LOG = Logger.getInstance(NewProjectCheckoutListener.class);

    public boolean processCheckedOutDirectory(Project project2, File directory) {
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(directory);
        LOG.assertTrue(file2 != null, (Object)("Can't find " + directory));
        int rc = Messages.showYesNoDialog((Project)project2, (String)VcsBundle.message((String)"checkout.create.project.prompt", (Object[])new Object[]{ProjectCheckoutListener.getProductNameWithArticle(), directory.getAbsolutePath()}), (String)VcsBundle.message((String)"checkout.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (rc == 0) {
            AddModuleWizard wizard = this.createImportWizard(file2);
            if (wizard == null) {
                return false;
            }
            if (wizard.showAndGet()) {
                ImportModuleAction.createFromWizard(null, wizard);
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected AddModuleWizard createImportWizard(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/checkout/NewProjectCheckoutListener", "createImportWizard"));
        }
        return ImportModuleAction.createImportWizard(null, null, file2, (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions());
    }

    public void processOpenedProject(Project lastOpenedProject) {
    }
}

