/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.TransactionProvider;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.committed.ChangesBrowserDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesPanel;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTableModel;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCache;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.SelectFilePathsDialog;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.FileHistoryRefresher;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.impl.VcsErrorViewPanel;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.BufferedListConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ConfirmationDialog;
import com.intellij.util.ui.ErrorTreeView;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractVcsHelperImpl
extends AbstractVcsHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl");
    private Consumer<VcsException> myCustomHandler;

    protected AbstractVcsHelperImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "<init>"));
        }
        super(project2);
        this.myCustomHandler = null;
    }

    public void openMessagesView(final VcsErrorViewPanel errorTreeView, final String tabDisplayName) {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                final MessageView messageView = MessageView.SERVICE.getInstance(AbstractVcsHelperImpl.this.myProject);
                messageView.runWhenInitialized(new Runnable(){

                    @Override
                    public void run() {
                        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)errorTreeView, tabDisplayName, true);
                        messageView.getContentManager().addContent(content);
                        Disposer.register((Disposable)content, (Disposable)errorTreeView);
                        messageView.getContentManager().setSelectedContent(content);
                        AbstractVcsHelperImpl.this.removeContents(content, tabDisplayName);
                        ToolWindowManager.getInstance((Project)AbstractVcsHelperImpl.this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW).activate(null);
                    }
                });
            }
        }, VcsBundle.message((String)"command.name.open.error.message.view", (Object[])new Object[0]), null);
    }

    public void showFileHistory(@NotNull VcsHistoryProvider historyProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs, @Nullable String repositoryPath) {
        if (historyProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "historyProvider", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showFileHistory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showFileHistory"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showFileHistory"));
        }
        this.showFileHistory(historyProvider, vcs.getAnnotationProvider(), path, repositoryPath, vcs);
    }

    public void showFileHistory(@NotNull VcsHistoryProvider historyProvider, @Nullable AnnotationProvider annotationProvider, @NotNull FilePath path, @Nullable String repositoryPath, @NotNull AbstractVcs vcs) {
        if (historyProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "historyProvider", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showFileHistory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showFileHistory"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showFileHistory"));
        }
        FileHistoryRefresherI refresher = FileHistoryRefresher.findOrCreate(historyProvider, path, vcs);
        refresher.run(false, true);
    }

    public void showFileHistory(@NotNull VcsHistoryProviderEx historyProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs, @Nullable VcsRevisionNumber startingRevisionNumber) {
        if (historyProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "historyProvider", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showFileHistory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showFileHistory"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showFileHistory"));
        }
        FileHistoryRefresherI refresher = FileHistoryRefresher.findOrCreate(historyProvider, path, vcs, startingRevisionNumber);
        refresher.run(false, true);
    }

    public void showRollbackChangesDialog(List<Change> changes) {
        RollbackChangesDialog.rollbackChanges(this.myProject, changes);
    }

    @Nullable
    public Collection<VirtualFile> selectFilesToProcess(List<VirtualFile> files, String title, @Nullable String prompt, String singleFileTitle, String singleFilePromptTemplate, VcsShowConfirmationOption confirmationOption) {
        if (files == null || files.isEmpty()) {
            return null;
        }
        if (files.size() == 1 && singleFilePromptTemplate != null) {
            String filePrompt = MessageFormat.format(singleFilePromptTemplate, files.get(0).getPresentableUrl());
            if (ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)confirmationOption, (Project)this.myProject, (String)filePrompt, (String)singleFileTitle, (Icon)Messages.getQuestionIcon())) {
                return files;
            }
            return null;
        }
        SelectFilesDialog dlg = SelectFilesDialog.init(this.myProject, files, prompt, confirmationOption, true, true, false);
        dlg.setTitle(title);
        if (!confirmationOption.isPersistent()) {
            dlg.setDoNotAskOption(null);
        }
        if (dlg.showAndGet()) {
            Collection<VirtualFile> selection = dlg.getSelectedFiles();
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
            for (VirtualFile file2 : files) {
                if (!selection.contains(file2)) continue;
                result.add(file2);
            }
            return result;
        }
        return null;
    }

    @Nullable
    public Collection<FilePath> selectFilePathsToProcess(List<FilePath> files, String title, @Nullable String prompt, String singleFileTitle, String singleFilePromptTemplate, VcsShowConfirmationOption confirmationOption, @Nullable String okActionName, @Nullable String cancelActionName) {
        if (files.size() == 1 && singleFilePromptTemplate != null) {
            String filePrompt = MessageFormat.format(singleFilePromptTemplate, files.get(0).getPresentableUrl());
            if (ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)confirmationOption, (Project)this.myProject, (String)filePrompt, (String)singleFileTitle, (Icon)Messages.getQuestionIcon(), (String)okActionName, (String)cancelActionName)) {
                return files;
            }
            return null;
        }
        SelectFilePathsDialog dlg = new SelectFilePathsDialog(this.myProject, files, prompt, confirmationOption, okActionName, cancelActionName, true);
        dlg.setTitle(title);
        if (!confirmationOption.isPersistent()) {
            dlg.setDoNotAskOption(null);
        }
        return dlg.showAndGet() ? dlg.getSelectedFiles() : null;
    }

    @Nullable
    public Collection<FilePath> selectFilePathsToProcess(List<FilePath> files, String title, @Nullable String prompt, String singleFileTitle, String singleFilePromptTemplate, VcsShowConfirmationOption confirmationOption) {
        return this.selectFilePathsToProcess(files, title, prompt, singleFileTitle, singleFilePromptTemplate, confirmationOption, null, null);
    }

    public void showErrors(final List<VcsException> abstractVcsExceptions, @NotNull String tabDisplayName) {
        if (tabDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showErrors"));
        }
        this.showErrorsImpl(abstractVcsExceptions.isEmpty(), new Getter<VcsException>(){

            public VcsException get() {
                return (VcsException)((Object)abstractVcsExceptions.get(0));
            }
        }, tabDisplayName, new Consumer<VcsErrorViewPanel>(){

            public void consume(VcsErrorViewPanel vcsErrorViewPanel) {
                AbstractVcsHelperImpl.addDirectMessages(vcsErrorViewPanel, abstractVcsExceptions);
            }
        });
    }

    public boolean commitChanges(@NotNull Collection<Change> changes, @NotNull LocalChangeList initialChangeList, @NotNull String commitMessage, @Nullable CommitResultHandler customResultHandler) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "commitChanges"));
        }
        if (initialChangeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialChangeList", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "commitChanges"));
        }
        if (commitMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "commitChanges"));
        }
        return CommitChangeListDialog.commitChanges(this.myProject, changes, initialChangeList, CommitChangeListDialog.collectExecutors(this.myProject, changes), true, commitMessage, customResultHandler);
    }

    private static void addDirectMessages(VcsErrorViewPanel vcsErrorViewPanel, List<VcsException> abstractVcsExceptions) {
        for (VcsException exception : abstractVcsExceptions) {
            String[] messages = AbstractVcsHelperImpl.getExceptionMessages(exception);
            vcsErrorViewPanel.addMessage(AbstractVcsHelperImpl.getErrorCategory(exception), messages, exception.getVirtualFile(), -1, -1, null);
        }
    }

    private static String[] getExceptionMessages(VcsException exception) {
        String[] messages = exception.getMessages();
        if (messages.length == 0) {
            messages = new String[]{VcsBundle.message((String)"exception.text.unknown.error", (Object[])new Object[0])};
        }
        ArrayList list = new ArrayList();
        for (String message : messages) {
            list.addAll(StringUtil.split((String)StringUtil.convertLineSeparators((String)message), (String)"\n"));
        }
        return ArrayUtil.toStringArray(list);
    }

    private void showErrorsImpl(final boolean isEmpty, Getter<VcsException> firstGetter, final @NotNull String tabDisplayName, final Consumer<VcsErrorViewPanel> viewFiller) {
        if (tabDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showErrorsImpl"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            VcsException exception;
            if (!isEmpty && !this.handleCustom(exception = (VcsException)((Object)firstGetter.get()))) {
                throw new RuntimeException(exception);
            }
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AbstractVcsHelperImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (isEmpty) {
                    AbstractVcsHelperImpl.this.removeContents(null, tabDisplayName);
                    return;
                }
                VcsErrorViewPanel errorTreeView = new VcsErrorViewPanel(AbstractVcsHelperImpl.this.myProject);
                AbstractVcsHelperImpl.this.openMessagesView(errorTreeView, tabDisplayName);
                viewFiller.consume((Object)errorTreeView);
            }
        });
    }

    public boolean handleCustom(VcsException exception) {
        if (this.myCustomHandler != null) {
            this.myCustomHandler.consume((Object)exception);
            return true;
        }
        return false;
    }

    public void showErrors(final Map<HotfixData, List<VcsException>> exceptionGroups, @NotNull String tabDisplayName) {
        if (tabDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showErrors"));
        }
        this.showErrorsImpl(exceptionGroups.isEmpty(), new Getter<VcsException>(){

            public VcsException get() {
                List exceptionList = (List)exceptionGroups.values().iterator().next();
                return exceptionList == null ? null : (exceptionList.isEmpty() ? null : (VcsException)((Object)exceptionList.get(0)));
            }
        }, tabDisplayName, new Consumer<VcsErrorViewPanel>(){

            public void consume(VcsErrorViewPanel vcsErrorViewPanel) {
                for (Map.Entry entry : exceptionGroups.entrySet()) {
                    if (entry.getKey() == null) {
                        AbstractVcsHelperImpl.addDirectMessages(vcsErrorViewPanel, (List)entry.getValue());
                        continue;
                    }
                    List exceptionList = (List)entry.getValue();
                    ArrayList<SimpleErrorData> list = new ArrayList<SimpleErrorData>(exceptionList.size());
                    for (VcsException exception : exceptionList) {
                        String[] messages = AbstractVcsHelperImpl.getExceptionMessages(exception);
                        list.add(new SimpleErrorData(ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)AbstractVcsHelperImpl.getErrorCategory(exception)), messages, exception.getVirtualFile()));
                    }
                    vcsErrorViewPanel.addHotfixGroup((HotfixData)entry.getKey(), list);
                }
            }
        });
    }

    private static int getErrorCategory(VcsException exception) {
        if (exception.isWarning()) {
            return 5;
        }
        return 4;
    }

    protected void removeContents(Content notToRemove, String tabDisplayName) {
        Content[] contents;
        MessageView messageView = MessageView.SERVICE.getInstance(this.myProject);
        for (Content content : contents = messageView.getContentManager().getContents()) {
            ErrorTreeView listErrorView;
            LOG.assertTrue(content != null);
            if (content.isPinned() || !tabDisplayName.equals(content.getDisplayName()) || content == notToRemove || (listErrorView = (ErrorTreeView)content.getComponent()) == null || !messageView.getContentManager().removeContent(content, true)) continue;
            content.release();
        }
    }

    public List<VcsException> runTransactionRunnable(AbstractVcs vcs, TransactionRunnable runnable2, Object vcsParameters) {
        boolean transactionSupported;
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        TransactionProvider transactionProvider = vcs.getTransactionProvider();
        boolean bl = transactionSupported = transactionProvider != null;
        if (transactionSupported) {
            try {
                transactionProvider.startTransaction(vcsParameters);
            }
            catch (VcsException e) {
                return Collections.singletonList(e);
            }
        }
        runnable2.run(exceptions);
        if (transactionSupported) {
            if (exceptions.isEmpty()) {
                try {
                    transactionProvider.commitTransaction(vcsParameters);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                    transactionProvider.rollbackTransaction(vcsParameters);
                }
            } else {
                transactionProvider.rollbackTransaction(vcsParameters);
            }
        }
        return exceptions;
    }

    public void showAnnotation(FileAnnotation annotation, VirtualFile file2, AbstractVcs vcs) {
        this.showAnnotation(annotation, file2, vcs, 0);
    }

    public void showAnnotation(FileAnnotation annotation, VirtualFile file2, AbstractVcs vcs, int line) {
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this.myProject, file2, line, 0);
        Editor editor = FileEditorManager.getInstance((Project)this.myProject).openTextEditor(openFileDescriptor, true);
        if (editor == null) {
            Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.open.editor", (Object[])new Object[]{file2.getPresentableUrl()}), (String)VcsBundle.message((String)"message.title.cannot.open.editor", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            return;
        }
        AnnotateToggleAction.doAnnotate(editor, this.myProject, file2, annotation, vcs);
    }

    public void showDifferences(VcsFileRevision version1, VcsFileRevision version2, File file2) {
        try {
            byte[] byteContent1 = VcsHistoryUtil.loadRevisionContent(version1);
            byte[] byteContent2 = VcsHistoryUtil.loadRevisionContent(version2);
            if (Comparing.equal((Object)byteContent1, (Object)byteContent2)) {
                Messages.showInfoMessage((String)VcsBundle.message((String)"message.text.versions.are.identical", (Object[])new Object[0]), (String)VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
            }
            SimpleDiffRequest request = new SimpleDiffRequest(this.myProject, file2.getAbsolutePath());
            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getName());
            if (fileType.isBinary()) {
                Messages.showInfoMessage((String)VcsBundle.message((String)"message.text.binary.versions.differ", (Object[])new Object[0]), (String)VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
                return;
            }
            DiffContent content1 = AbstractVcsHelperImpl.getContentForVersion(version1, file2);
            DiffContent content2 = AbstractVcsHelperImpl.getContentForVersion(version2, file2);
            if (version2.getRevisionNumber().compareTo((Object)version1.getRevisionNumber()) > 0) {
                request.setContents(content2, content1);
                request.setContentTitles(version2.getRevisionNumber().asString(), version1.getRevisionNumber().asString());
            } else {
                request.setContents(content1, content2);
                request.setContentTitles(version1.getRevisionNumber().asString(), version2.getRevisionNumber().asString());
            }
            DiffManager.getInstance().getDiffTool().show((DiffRequest)request);
        }
        catch (VcsException e) {
            this.showError(e, VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
        }
        catch (IOException e) {
            this.showError(new VcsException((Throwable)e), VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
        }
    }

    public void showChangesBrowser(List<CommittedChangeList> changelists) {
        this.showChangesBrowser(changelists, null);
    }

    public void showChangesBrowser(List<CommittedChangeList> changelists, @Nls String title) {
        this.showChangesBrowser(new CommittedChangesTableModel(changelists, false), title, false, null);
    }

    private ChangesBrowserDialog createChangesBrowserDialog(CommittedChangesTableModel changelists, String title, boolean showSearchAgain, @Nullable Component parent, Consumer<ChangesBrowserDialog> initRunnable) {
        ChangesBrowserDialog dlg;
        ChangesBrowserDialog.Mode mode = showSearchAgain ? ChangesBrowserDialog.Mode.Browse : ChangesBrowserDialog.Mode.Simple;
        ChangesBrowserDialog changesBrowserDialog = dlg = parent != null ? new ChangesBrowserDialog(this.myProject, parent, changelists, mode, initRunnable) : new ChangesBrowserDialog(this.myProject, changelists, mode, initRunnable);
        if (title != null) {
            dlg.setTitle(title);
        }
        return dlg;
    }

    private void showChangesBrowser(CommittedChangesTableModel changelists, String title, boolean showSearchAgain, @Nullable Component parent) {
        ChangesBrowserDialog dlg;
        ChangesBrowserDialog.Mode mode = showSearchAgain ? ChangesBrowserDialog.Mode.Browse : ChangesBrowserDialog.Mode.Simple;
        ChangesBrowserDialog changesBrowserDialog = dlg = parent != null ? new ChangesBrowserDialog(this.myProject, parent, changelists, mode, null) : new ChangesBrowserDialog(this.myProject, changelists, mode, null);
        if (title != null) {
            dlg.setTitle(title);
        }
        dlg.show();
    }

    public void showChangesListBrowser(CommittedChangeList changelist, @Nullable VirtualFile toSelect, @Nls String title) {
        ChangeListViewerDialog dlg = new ChangeListViewerDialog(this.myProject, changelist, toSelect);
        if (title != null) {
            dlg.setTitle(title);
        }
        dlg.show();
    }

    public void showChangesListBrowser(CommittedChangeList changelist, @Nls String title) {
        this.showChangesListBrowser(changelist, null, title);
    }

    public void showWhatDiffersBrowser(Component parent, Collection<Change> changes, @Nls String title) {
        ChangeListViewerDialog dlg = parent != null ? new ChangeListViewerDialog(parent, this.myProject, changes, false) : new ChangeListViewerDialog(this.myProject, changes, false);
        if (title != null) {
            dlg.setTitle(title);
        }
        dlg.show();
    }

    public void showChangesBrowser(final CommittedChangesProvider provider, final RepositoryLocation location, @Nls String title, Component parent) {
        boolean ok;
        ChangesBrowserSettingsEditor filterUI = provider.createFilterUI(true);
        ChangeBrowserSettings settings = provider.createDefaultSettings();
        if (filterUI != null) {
            CommittedChangesFilterDialog dlg = new CommittedChangesFilterDialog(this.myProject, filterUI, settings);
            dlg.show();
            ok = dlg.getExitCode() == 0;
            settings = dlg.getSettings();
        } else {
            ok = true;
        }
        if (ok) {
            if (this.myProject.isDefault() || ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss().length == 0 || !ModalityState.NON_MODAL.equals(ModalityState.current())) {
                ArrayList<CommittedChangeList> versions = new ArrayList<CommittedChangeList>();
                if (parent == null || !parent.isValid()) {
                    parent = WindowManager.getInstance().suggestParentWindow(this.myProject);
                }
                CommittedChangesTableModel model = new CommittedChangesTableModel(versions, true);
                final AsynchronousListsLoader[] task = new AsynchronousListsLoader[1];
                final ChangeBrowserSettings finalSettings = settings;
                ChangesBrowserDialog dlg = this.createChangesBrowserDialog(model, title, filterUI != null, parent, new Consumer<ChangesBrowserDialog>(){

                    public void consume(ChangesBrowserDialog changesBrowserDialog) {
                        task[0] = new AsynchronousListsLoader(AbstractVcsHelperImpl.this.myProject, provider, location, finalSettings, changesBrowserDialog);
                        ProgressManager.getInstance().run((Task)task[0]);
                    }
                });
                dlg.startLoading();
                dlg.show();
                if (task[0] != null) {
                    task[0].cancel();
                    List<VcsException> exceptions = task[0].getExceptions();
                    if (!exceptions.isEmpty()) {
                        Messages.showErrorDialog((Project)this.myProject, (String)VcsBundle.message((String)"browse.changes.error.message", (Object[])new Object[]{exceptions.get(0).getMessage()}), (String)VcsBundle.message((String)"browse.changes.error.title", (Object[])new Object[0]));
                        return;
                    }
                    if (!task[0].isRevisionsReturned()) {
                        Messages.showInfoMessage((Project)this.myProject, (String)VcsBundle.message((String)"browse.changes.nothing.found", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.nothing.found.title", (Object[])new Object[0]));
                    }
                }
            } else {
                this.openCommittedChangesTab(provider, location, settings, 0, title);
            }
        }
    }

    @Nullable
    public <T extends CommittedChangeList, U extends ChangeBrowserSettings> T chooseCommittedChangeList(@NotNull CommittedChangesProvider<T, U> provider, RepositoryLocation location) {
        List changes;
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "chooseCommittedChangeList"));
        }
        try {
            changes = provider.getCommittedChanges(provider.createDefaultSettings(), location, 0);
        }
        catch (VcsException e) {
            return null;
        }
        ChangesBrowserDialog dlg = new ChangesBrowserDialog(this.myProject, new CommittedChangesTableModel(changes, provider.getColumns(), false), ChangesBrowserDialog.Mode.Choose, null);
        if (dlg.showAndGet()) {
            return (T)dlg.getSelectedChangeList();
        }
        return null;
    }

    @NotNull
    public List<VirtualFile> showMergeDialog(@NotNull List<VirtualFile> files, @NotNull MergeProvider provider, @NotNull MergeDialogCustomizer mergeDialogCustomizer) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showMergeDialog"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showMergeDialog"));
        }
        if (mergeDialogCustomizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeDialogCustomizer", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showMergeDialog"));
        }
        if (files.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showMergeDialog"));
            }
            return list;
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])((VirtualFile[])ArrayUtil.toObjectArray(files, VirtualFile.class)));
        MultipleFileMergeDialog fileMergeDialog = new MultipleFileMergeDialog(this.myProject, files, provider, mergeDialogCustomizer);
        fileMergeDialog.show();
        List<VirtualFile> list = fileMergeDialog.getProcessedFiles();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "showMergeDialog"));
        }
        return list;
    }

    private static DiffContent getContentForVersion(VcsFileRevision version, File file2) throws IOException, VcsException {
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file2);
        if (vFile != null && version instanceof CurrentRevision && !vFile.getFileType().isBinary()) {
            return new DocumentContent(FileDocumentManager.getInstance().getDocument(vFile), vFile.getFileType());
        }
        return new SimpleContent(VcsHistoryUtil.loadRevisionContentGuessEncoding(version, vFile, null), FileTypeManager.getInstance().getFileTypeByFileName(file2.getName()));
    }

    public void openCommittedChangesTab(AbstractVcs vcs, VirtualFile root, ChangeBrowserSettings settings, int maxCount, String title) {
        RepositoryLocationCache cache = CommittedChangesCache.getInstance(this.myProject).getLocationCache();
        RepositoryLocation location = cache.getLocation(vcs, VcsUtil.getFilePath((VirtualFile)root), false);
        this.openCommittedChangesTab(vcs.getCommittedChangesProvider(), location, settings, maxCount, title);
    }

    public void openCommittedChangesTab(CommittedChangesProvider provider, RepositoryLocation location, ChangeBrowserSettings settings, int maxCount, String title) {
        DefaultActionGroup extraActions = new DefaultActionGroup();
        CommittedChangesPanel panel = new CommittedChangesPanel(this.myProject, provider, settings, location, (ActionGroup)extraActions);
        panel.setMaxCount(maxCount);
        panel.refreshChanges(false);
        ContentFactory factory = ContentFactory.SERVICE.getInstance();
        if (title == null && location != null) {
            title = VcsBundle.message((String)"browse.changes.content.title", (Object[])new Object[]{location.toPresentableString()});
        }
        final Content content = factory.createContent((JComponent)panel, title, false);
        final ChangesViewContentI contentManager = ChangesViewContentManager.getInstance(this.myProject);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content);
        extraActions.add((AnAction)new CloseTabToolbarAction(){

            public void actionPerformed(AnActionEvent e) {
                contentManager.removeContent(content);
            }
        });
        ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        if (!window.isVisible()) {
            window.activate(null);
        }
    }

    public void loadAndShowCommittedChangesDetails(final @NotNull Project project2, final @NotNull VcsRevisionNumber revision, final @NotNull VirtualFile virtualFile, @NotNull VcsKey vcsKey, final @Nullable RepositoryLocation location, final boolean isNonLocal) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "loadAndShowCommittedChangesDetails"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "loadAndShowCommittedChangesDetails"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "loadAndShowCommittedChangesDetails"));
        }
        if (vcsKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsKey", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "loadAndShowCommittedChangesDetails"));
        }
        final AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project2).findVcsByName(vcsKey.getName());
        if (vcs == null) {
            return;
        }
        final CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
        if (provider == null) {
            return;
        }
        if (isNonLocal && provider.getForNonLocal(virtualFile) == null) {
            return;
        }
        final String title = VcsBundle.message((String)"paths.affected.in.revision", (Object[])new Object[]{revision instanceof ShortVcsRevisionNumber ? ((ShortVcsRevisionNumber)revision).toShortString() : revision.asString()});
        final CommittedChangeList[] list = new CommittedChangeList[1];
        final FilePath[] targetPath = new FilePath[1];
        final VcsException[] exc = new VcsException[1];
        final BackgroundableActionLock lock = BackgroundableActionLock.getLock(project2, new Object[]{VcsBackgroundableActions.COMMITTED_CHANGES_DETAILS, revision, virtualFile.getPath()});
        if (lock.isLocked()) {
            return;
        }
        lock.lock();
        Task.Backgroundable task = new Task.Backgroundable(project2, title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl$9", "run"));
                }
                try {
                    if (!isNonLocal) {
                        Pair pair = provider.getOneList(virtualFile, revision);
                        if (pair != null) {
                            list[0] = (CommittedChangeList)pair.getFirst();
                            targetPath[0] = (FilePath)pair.getSecond();
                        }
                    } else if (location != null) {
                        ChangeBrowserSettings settings = provider.createDefaultSettings();
                        settings.USE_CHANGE_BEFORE_FILTER = true;
                        settings.CHANGE_BEFORE = revision.asString();
                        List changes = provider.getCommittedChanges(settings, location, 1);
                        if (changes != null && changes.size() == 1) {
                            list[0] = (CommittedChangeList)changes.get(0);
                        }
                    } else {
                        list[0] = AbstractVcsHelperImpl.getRemoteList(vcs, revision, virtualFile);
                    }
                }
                catch (VcsException e) {
                    exc[0] = e;
                }
            }

            public void onCancel() {
                lock.unlock();
            }

            public void onSuccess() {
                lock.unlock();
                if (exc[0] != null) {
                    AbstractVcsHelperImpl.this.showError(exc[0], AbstractVcsHelperImpl.failedText(virtualFile, revision));
                } else if (list[0] == null) {
                    Messages.showErrorDialog((Project)project2, (String)AbstractVcsHelperImpl.failedText(virtualFile, revision), (String)this.getTitle());
                } else {
                    VcsVirtualFile navigateToFile = targetPath[0] != null ? new VcsVirtualFile(targetPath[0].getPath(), null, (VirtualFileSystem)VcsFileSystem.getInstance()) : virtualFile;
                    AbstractVcsHelperImpl.this.showChangesListBrowser(list[0], (VirtualFile)navigateToFile, title);
                }
            }
        };
        CoreProgressManager progressManager = (CoreProgressManager)ProgressManager.getInstance();
        progressManager.runProcessWithProgressAsynchronously(task, new BackgroundableProcessIndicator(task), null, ModalityState.current());
    }

    @Nullable
    public static CommittedChangeList getRemoteList(@NotNull AbstractVcs vcs, @NotNull VcsRevisionNumber revision, @NotNull VirtualFile nonLocal) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "getRemoteList"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "getRemoteList"));
        }
        if (nonLocal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonLocal", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "getRemoteList"));
        }
        CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
        RepositoryLocation local = provider.getForNonLocal(nonLocal);
        if (local != null) {
            String number = revision.asString();
            ChangeBrowserSettings settings = provider.createDefaultSettings();
            List changes = provider.getCommittedChanges(settings, local, provider.getUnlimitedCountValue());
            if (changes != null) {
                for (CommittedChangeList change : changes) {
                    if (!number.equals(String.valueOf(change.getNumber()))) continue;
                    return change;
                }
            }
        }
        return null;
    }

    @NotNull
    private static String failedText(@NotNull VirtualFile virtualFile, @NotNull VcsRevisionNumber revision) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "failedText"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "failedText"));
        }
        String string = "Show all affected files for " + virtualFile.getPath() + " at " + revision.asString() + " failed";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl", "failedText"));
        }
        return string;
    }

    public static void setCustomExceptionHandler(Project project2, Consumer<VcsException> customHandler) {
        ((AbstractVcsHelperImpl)AbstractVcsHelperImpl.getInstance((Project)project2)).myCustomHandler = customHandler;
    }

    private static class AsynchronousListsLoader
    extends Task.Backgroundable {
        private final CommittedChangesProvider myProvider;
        private final RepositoryLocation myLocation;
        private final ChangeBrowserSettings mySettings;
        private final ChangesBrowserDialog myDlg;
        private final List<VcsException> myExceptions;
        private volatile boolean myCanceled;
        private boolean myRevisionsReturned;

        private AsynchronousListsLoader(@Nullable Project project2, CommittedChangesProvider provider, RepositoryLocation location, ChangeBrowserSettings settings, ChangesBrowserDialog dlg) {
            super(project2, VcsBundle.message((String)"browse.changes.progress.title", (Object[])new Object[0]), true);
            this.myProvider = provider;
            this.myLocation = location;
            this.mySettings = settings;
            this.myDlg = dlg;
            this.myExceptions = new LinkedList<VcsException>();
        }

        public void cancel() {
            this.myCanceled = true;
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl$AsynchronousListsLoader", "run"));
            }
            final AsynchConsumer<List<CommittedChangeList>> appender = this.myDlg.getAppender();
            final BufferedListConsumer<CommittedChangeList> bufferedListConsumer = new BufferedListConsumer<CommittedChangeList>(10, (Consumer<List<CommittedChangeList>>)appender, -1);
            final Application application = ApplicationManager.getApplication();
            try {
                this.myProvider.loadCommittedChanges(this.mySettings, this.myLocation, 0, (AsynchConsumer)new AsynchConsumer<CommittedChangeList>(){

                    public void consume(CommittedChangeList committedChangeList) {
                        myRevisionsReturned = true;
                        bufferedListConsumer.consumeOne(committedChangeList);
                        if (myCanceled) {
                            indicator.cancel();
                        }
                    }

                    public void finished() {
                        bufferedListConsumer.flush();
                        appender.finished();
                        if (!myRevisionsReturned) {
                            application.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    myDlg.close(-1);
                                }
                            }, ModalityState.stateForComponent((Component)myDlg.getWindow()));
                        }
                    }
                });
            }
            catch (VcsException e) {
                this.myExceptions.add(e);
                application.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        myDlg.close(-1);
                    }
                }, ModalityState.stateForComponent((Component)this.myDlg.getWindow()));
            }
        }

        public List<VcsException> getExceptions() {
            return this.myExceptions;
        }

        public boolean isRevisionsReturned() {
            return this.myRevisionsReturned;
        }
    }
}

