/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import org.jetbrains.annotations.NotNull;

public class BackgroundableActionLock {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object[] myKeys;

    BackgroundableActionLock(@NotNull Project project2, @NotNull Object[] keys) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "<init>"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "<init>"));
        }
        this.myProject = project2;
        this.myKeys = keys;
    }

    public boolean isLocked() {
        return BackgroundableActionLock.isLocked(this.myProject, this.myKeys);
    }

    public void lock() {
        BackgroundableActionLock.lock(this.myProject, this.myKeys);
    }

    public void unlock() {
        BackgroundableActionLock.unlock(this.myProject, this.myKeys);
    }

    @NotNull
    public static BackgroundableActionLock getLock(@NotNull Project project2, Object ... keys) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "getLock"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "getLock"));
        }
        BackgroundableActionLock backgroundableActionLock = new BackgroundableActionLock(project2, keys);
        if (backgroundableActionLock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "getLock"));
        }
        return backgroundableActionLock;
    }

    public static boolean isLocked(@NotNull Project project2, Object ... keys) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "isLocked"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "isLocked"));
        }
        return BackgroundableActionLock.getManager(project2).isBackgroundTaskRunning(keys);
    }

    public static void lock(@NotNull Project project2, Object ... keys) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "lock"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "lock"));
        }
        BackgroundableActionLock.getManager(project2).startBackgroundTask(keys);
    }

    public static void unlock(@NotNull Project project2, Object ... keys) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "unlock"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "unlock"));
        }
        BackgroundableActionLock.getManager(project2).stopBackgroundTask(keys);
    }

    @NotNull
    private static ProjectLevelVcsManagerImpl getManager(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "getManager"));
        }
        ProjectLevelVcsManagerImpl projectLevelVcsManagerImpl = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)project2);
        if (projectLevelVcsManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "getManager"));
        }
        return projectLevelVcsManagerImpl;
    }
}

