/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;

public class VcsKeymapExtension
implements KeymapExtension {
    public KeymapGroup createGroup(Condition<AnAction> filtered, Project project2) {
        AnAction[] generalActions;
        KeymapGroup result = KeymapGroupFactory.getInstance().createGroup(KeyMapBundle.message((String)"version.control.group.title", (Object[])new Object[0]));
        AnAction[] versionControlsGroups = VcsKeymapExtension.getActions("VcsGroup");
        AnAction[] keymapGroups = VcsKeymapExtension.getActions("Vcs.KeymapGroup");
        for (AnAction action : ContainerUtil.concat((Object[][])new AnAction[][]{versionControlsGroups, keymapGroups})) {
            VcsKeymapExtension.addAction(result, action, filtered, false);
        }
        for (AnAction action : generalActions = VcsKeymapExtension.getActions("VcsGeneral.KeymapGroup")) {
            VcsKeymapExtension.addAction(result, action, filtered, true);
        }
        if (result instanceof Group) {
            ((Group)result).normalizeSeparators();
        }
        return result;
    }

    private static void addAction(KeymapGroup result, AnAction action, Condition<AnAction> filtered, boolean forceNonPopup) {
        if (action instanceof ActionGroup) {
            if (forceNonPopup) {
                AnAction[] actions;
                for (AnAction childAction : actions = VcsKeymapExtension.getActions((ActionGroup)action)) {
                    VcsKeymapExtension.addAction(result, childAction, filtered, true);
                }
            } else {
                Group subGroup = ActionsTreeUtil.createGroup((ActionGroup)action, false, filtered);
                if (subGroup.getSize() > 0) {
                    result.addGroup((KeymapGroup)subGroup);
                }
            }
        } else if (action instanceof Separator) {
            if (result instanceof Group) {
                ((Group)result).addSeparator();
            }
        } else if (filtered == null || filtered.value((Object)action)) {
            String id = action instanceof ActionStub ? ((ActionStub)action).getId() : ActionManager.getInstance().getId(action);
            result.addActionId(id);
        }
    }

    private static AnAction[] getActions(String actionGroup) {
        return VcsKeymapExtension.getActions((ActionGroup)ActionManager.getInstance().getActionOrStub(actionGroup));
    }

    private static AnAction[] getActions(ActionGroup group) {
        return group instanceof DefaultActionGroup ? ((DefaultActionGroup)group).getChildActionsOrStubs() : group.getChildren(null);
    }
}

