/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MappingsToRoots {
    private final NewMappings myMappings;
    private final Project myProject;

    public MappingsToRoots(NewMappings mappings, Project project2) {
        this.myMappings = mappings;
        this.myProject = project2;
    }

    @NotNull
    public VirtualFile[] getRootsUnderVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/impl/projectlevelman/MappingsToRoots", "getRootsUnderVcs"));
        }
        List result = this.myMappings.getMappingsAsFilesUnderVcs(vcs);
        AbstractVcs.RootsConvertor convertor = vcs.getCustomConvertor();
        if (convertor != null) {
            result = convertor.convertRoots(result);
        }
        Collections.sort(result, FilePathComparator.getInstance());
        if (!vcs.allowsNestedRoots()) {
            final FileIndexFacade facade = (FileIndexFacade)PeriodicalTasksCloser.getInstance().safeGetService(this.myProject, FileIndexFacade.class);
            final List finalResult = result;
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    int i = 1;
                    while (i < finalResult.size()) {
                        VirtualFile current;
                        VirtualFile previous = (VirtualFile)finalResult.get(i - 1);
                        if (facade.isValidAncestor(previous, current = (VirtualFile)finalResult.get(i))) {
                            finalResult.remove(i);
                            continue;
                        }
                        ++i;
                    }
                }
            });
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray((Collection)result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/projectlevelman/MappingsToRoots", "getRootsUnderVcs"));
        }
        return virtualFileArray;
    }

    public List<VirtualFile> getDetailedVcsMappings(AbstractVcs vcs) {
        final List<VirtualFile> result = this.myMappings.getMappingsAsFilesUnderVcs(vcs);
        boolean addInnerModules = true;
        String vcsName = vcs.getName();
        List<VcsDirectoryMapping> directoryMappings = this.myMappings.getDirectoryMappings(vcsName);
        for (VcsDirectoryMapping directoryMapping : directoryMappings) {
            if (!directoryMapping.isDefaultMapping()) continue;
            addInnerModules = false;
            break;
        }
        Collections.sort(result, FilePathComparator.getInstance());
        if (addInnerModules) {
            final FileIndexFacade facade = (FileIndexFacade)PeriodicalTasksCloser.getInstance().safeGetService(this.myProject, FileIndexFacade.class);
            DefaultVcsRootPolicy defaultVcsRootPolicy = DefaultVcsRootPolicy.getInstance(this.myProject);
            final ArrayList<VirtualFile> modules = new ArrayList<VirtualFile>();
            defaultVcsRootPolicy.addDefaultVcsRoots(this.myMappings, vcsName, modules);
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    Iterator iterator = modules.iterator();
                    while (iterator.hasNext()) {
                        VirtualFile module2 = (VirtualFile)iterator.next();
                        boolean included = false;
                        for (VirtualFile root : result) {
                            if (!facade.isValidAncestor(root, module2)) continue;
                            included = true;
                            break;
                        }
                        if (included) continue;
                        iterator.remove();
                    }
                }
            });
            result.addAll(modules);
        }
        return result;
    }
}

