/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.local;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CoreLocalVirtualFile
extends VirtualFile {
    private final CoreLocalFileSystem myFileSystem;
    private final File myIoFile;
    private VirtualFile[] myChildren;
    private final boolean isDirectory;

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull File ioFile) {
        if (fileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystem", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "<init>"));
        }
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "<init>"));
        }
        this(fileSystem, ioFile, ioFile.isDirectory());
    }

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull File ioFile, boolean isDirectory) {
        if (fileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystem", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "<init>"));
        }
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "<init>"));
        }
        this.myFileSystem = fileSystem;
        this.myIoFile = ioFile;
        this.isDirectory = isDirectory;
    }

    @NotNull
    public String getName() {
        String string = this.myIoFile.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "getName"));
        }
        return string;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        CoreLocalFileSystem coreLocalFileSystem = this.myFileSystem;
        if (coreLocalFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "getFileSystem"));
        }
        return coreLocalFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = FileUtil.toSystemIndependentName((String)this.myIoFile.getAbsolutePath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "getPath"));
        }
        return string;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        File parentFile = this.myIoFile.getParentFile();
        return parentFile != null ? new CoreLocalVirtualFile(this.myFileSystem, parentFile) : null;
    }

    public VirtualFile[] getChildren() {
        VirtualFile[] answer = this.myChildren;
        if (answer == null) {
            ArrayList<CoreLocalVirtualFile> result = new ArrayList<CoreLocalVirtualFile>();
            File[] files = this.myIoFile.listFiles();
            if (files == null) {
                answer = EMPTY_ARRAY;
            } else {
                for (File file2 : files) {
                    result.add(new CoreLocalVirtualFile(this.myFileSystem, file2));
                }
                answer = result.toArray(new VirtualFile[result.size()]);
            }
            this.myChildren = answer;
        }
        return answer;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        byte[] byArray = FileUtil.loadFileBytes((File)this.myIoFile);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "contentsToByteArray"));
        }
        return byArray;
    }

    public long getTimeStamp() {
        return this.myIoFile.lastModified();
    }

    public long getLength() {
        return this.myIoFile.length();
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.inputStreamSkippingBOM((InputStream)new BufferedInputStream(new FileInputStream(this.myIoFile)), (VirtualFile)this);
    }

    public long getModificationStamp() {
        return 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CoreLocalVirtualFile that = (CoreLocalVirtualFile)((Object)o);
        return this.myIoFile.equals(that.myIoFile);
    }

    public int hashCode() {
        return this.myIoFile.hashCode();
    }
}

