/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.actions.ResizeToolWindowAction;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.InternalDecoratorListener;
import com.intellij.openapi.wm.impl.ToolWindowHeader;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Producer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InternalDecorator
extends JPanel
implements Queryable,
DataProvider {
    private Project myProject;
    private WindowInfoImpl myInfo;
    private final ToolWindowImpl myToolWindow;
    private final MyDivider myDivider;
    private final EventDispatcher<InternalDecoratorListener> myDispatcher;
    private final TogglePinnedModeAction myToggleAutoHideModeAction;
    private final ToggleDockModeAction myToggleDockModeAction;
    private final ToggleFloatingModeAction myToggleFloatingModeAction;
    private final ToggleWindowedModeAction myToggleWindowedModeAction;
    private final ToggleSideModeAction myToggleSideModeAction;
    private final ToggleContentUiTypeAction myToggleContentUiTypeAction;
    private final RemoveStripeButtonAction myHideStripeButtonAction;
    private ActionGroup myAdditionalGearActions;
    @NonNls
    private static final String HIDE_ACTIVE_WINDOW_ACTION_ID = "HideActiveWindow";
    @NonNls
    public static final String TOGGLE_PINNED_MODE_ACTION_ID = "TogglePinnedMode";
    @NonNls
    public static final String TOGGLE_DOCK_MODE_ACTION_ID = "ToggleDockMode";
    @NonNls
    public static final String TOGGLE_FLOATING_MODE_ACTION_ID = "ToggleFloatingMode";
    @NonNls
    public static final String TOGGLE_WINDOWED_MODE_ACTION_ID = "ToggleWindowedMode";
    @NonNls
    public static final String TOGGLE_SIDE_MODE_ACTION_ID = "ToggleSideMode";
    @NonNls
    private static final String TOGGLE_CONTENT_UI_TYPE_ACTION_ID = "ToggleContentUiTypeMode";
    private ToolWindowHeader myHeader;
    private ActionGroup myToggleToolbarGroup;

    InternalDecorator(Project project2, @NotNull WindowInfoImpl info, ToolWindowImpl toolWindow) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/InternalDecorator", "<init>"));
        }
        super(new BorderLayout());
        this.myDispatcher = EventDispatcher.create(InternalDecoratorListener.class);
        this.myProject = project2;
        this.myToolWindow = toolWindow;
        this.myToolWindow.setDecorator(this);
        this.myDivider = new MyDivider();
        this.myToggleFloatingModeAction = new ToggleFloatingModeAction();
        this.myToggleWindowedModeAction = new ToggleWindowedModeAction();
        this.myToggleSideModeAction = new ToggleSideModeAction();
        this.myToggleDockModeAction = new ToggleDockModeAction();
        this.myToggleAutoHideModeAction = new TogglePinnedModeAction();
        this.myToggleContentUiTypeAction = new ToggleContentUiTypeAction();
        this.myHideStripeButtonAction = new RemoveStripeButtonAction();
        this.myToggleToolbarGroup = ToggleToolbarAction.createToggleToolbarGroup(this.myProject, this.myToolWindow);
        this.setFocusable(false);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.myHeader = new ToolWindowHeader(toolWindow, info, (Producer)new Producer<ActionGroup>(){

            public ActionGroup produce() {
                return InternalDecorator.this.createPopupGroup(true);
            }
        }){

            @Override
            protected boolean isActive() {
                return InternalDecorator.this.isFocused();
            }

            @Override
            protected void hideToolWindow() {
                InternalDecorator.this.fireHidden();
            }

            @Override
            protected void toolWindowTypeChanged(ToolWindowType type) {
                InternalDecorator.this.fireTypeChanged(type);
            }

            @Override
            protected void sideHidden() {
                InternalDecorator.this.fireHiddenSide();
            }
        };
        this.init();
        this.apply(info);
    }

    public boolean isFocused() {
        IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
        Component component = fm.getFocusedDescendantFor((Component)this.myToolWindow.getComponent());
        if (component != null) {
            return true;
        }
        Component owner = fm.getLastFocusedFor(WindowManager.getInstance().getIdeFrame(this.myProject));
        return owner != null && SwingUtilities.isDescendingFrom(owner, this.myToolWindow.getComponent());
    }

    public final void apply(@NotNull WindowInfoImpl info) {
        FloatingDecorator floatingDecorator;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/InternalDecorator", "apply"));
        }
        if (Comparing.equal((Object)this.myInfo, (Object)info) || this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        this.myInfo = info;
        ToolWindowAnchor anchor = this.myInfo.getAnchor();
        if (info.isSliding()) {
            this.myDivider.invalidate();
            if (ToolWindowAnchor.TOP == anchor) {
                this.add((Component)this.myDivider, "South");
            } else if (ToolWindowAnchor.LEFT == anchor) {
                this.add((Component)this.myDivider, "East");
            } else if (ToolWindowAnchor.BOTTOM == anchor) {
                this.add((Component)this.myDivider, "North");
            } else if (ToolWindowAnchor.RIGHT == anchor) {
                this.add((Component)this.myDivider, "West");
            }
            this.myDivider.setPreferredSize(new Dimension(0, 0));
        } else {
            this.remove(this.myDivider);
        }
        this.validate();
        this.repaint();
        if (this.myInfo.isFloating() && this.myInfo.isVisible() && (floatingDecorator = (FloatingDecorator)SwingUtilities.getAncestorOfClass(FloatingDecorator.class, this)) != null) {
            floatingDecorator.apply(this.myInfo);
        }
        this.myToolWindow.getContentUI().setType(this.myInfo.getContentUiType());
        this.setBorder(new InnerPanelBorder(this.myToolWindow));
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.TOOL_WINDOW.is(dataId)) {
            return this.myToolWindow;
        }
        return null;
    }

    final void addInternalDecoratorListener(InternalDecoratorListener l) {
        this.myDispatcher.addListener((EventListener)l);
    }

    final void removeInternalDecoratorListener(InternalDecoratorListener l) {
        this.myDispatcher.removeListener((EventListener)l);
    }

    final void dispose() {
        this.removeAll();
        Disposer.dispose((Disposable)this.myHeader);
        this.myHeader = null;
        this.myProject = null;
    }

    private void fireAnchorChanged(ToolWindowAnchor anchor) {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).anchorChanged(this, anchor);
    }

    private void fireAutoHideChanged(boolean autoHide) {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).autoHideChanged(this, autoHide);
    }

    final void fireHidden() {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).hidden(this);
    }

    final void fireHiddenSide() {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).hiddenSide(this);
    }

    final void fireActivated() {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).activated(this);
    }

    private void fireTypeChanged(ToolWindowType type) {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).typeChanged(this, type);
    }

    final void fireResized() {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).resized(this);
    }

    private void fireSideStatusChanged(boolean isSide) {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).sideStatusChanged(this, isSide);
    }

    private void fireContentUiTypeChanges(ToolWindowContentUiType type) {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).contentUiTypeChanges(this, type);
    }

    private void fireVisibleOnPanelChanged(boolean visibleOnPanel) {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).visibleStripeButtonChanged(this, visibleOnPanel);
    }

    private void init() {
        this.enableEvents(1L);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)this.myHeader, "North");
        JPanel innerPanel = new JPanel(new BorderLayout());
        JComponent toolWindowComponent = this.myToolWindow.getComponent();
        innerPanel.add((Component)toolWindowComponent, "Center");
        NonOpaquePanel inner = new NonOpaquePanel((JComponent)innerPanel);
        contentPane.add((Component)inner, "Center");
        this.add((Component)contentPane, "Center");
        if (SystemInfo.isMac) {
            this.setBackground((Color)new JBColor((Color)Gray._200, (Color)Gray._90));
        }
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolWindowManager.getInstance((Project)InternalDecorator.this.myProject).activateEditorComponent();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    public void setTitleActions(AnAction[] actions) {
        this.myHeader.setAdditionalTitleActions(actions);
    }

    public final ActionGroup createPopupGroup() {
        return this.createPopupGroup(false);
    }

    public final ActionGroup createPopupGroup(boolean skipHideAction) {
        DefaultActionGroup group = this.createGearPopupGroup();
        if (!ToolWindowId.PREVIEW.equals(this.myInfo.getId())) {
            group.add((AnAction)this.myToggleContentUiTypeAction);
        }
        DefaultActionGroup moveGroup = new DefaultActionGroup(UIBundle.message((String)"tool.window.move.to.action.group.name", (Object[])new Object[0]), true);
        ToolWindowAnchor anchor = this.myInfo.getAnchor();
        if (anchor != ToolWindowAnchor.TOP) {
            ChangeAnchorAction topAction = new ChangeAnchorAction(UIBundle.message((String)"tool.window.move.to.top.action.name", (Object[])new Object[0]), ToolWindowAnchor.TOP);
            moveGroup.add((AnAction)topAction);
        }
        if (anchor != ToolWindowAnchor.LEFT) {
            ChangeAnchorAction leftAction = new ChangeAnchorAction(UIBundle.message((String)"tool.window.move.to.left.action.name", (Object[])new Object[0]), ToolWindowAnchor.LEFT);
            moveGroup.add((AnAction)leftAction);
        }
        if (anchor != ToolWindowAnchor.BOTTOM) {
            ChangeAnchorAction bottomAction = new ChangeAnchorAction(UIBundle.message((String)"tool.window.move.to.bottom.action.name", (Object[])new Object[0]), ToolWindowAnchor.BOTTOM);
            moveGroup.add((AnAction)bottomAction);
        }
        if (anchor != ToolWindowAnchor.RIGHT) {
            ChangeAnchorAction rightAction = new ChangeAnchorAction(UIBundle.message((String)"tool.window.move.to.right.action.name", (Object[])new Object[0]), ToolWindowAnchor.RIGHT);
            moveGroup.add((AnAction)rightAction);
        }
        group.add((AnAction)moveGroup);
        DefaultActionGroup resize = new DefaultActionGroup(ActionsBundle.groupText((String)"ResizeToolWindowGroup"), true);
        resize.add((AnAction)new ResizeToolWindowAction.Left(this.myToolWindow, this));
        resize.add((AnAction)new ResizeToolWindowAction.Right(this.myToolWindow, this));
        resize.add((AnAction)new ResizeToolWindowAction.Up(this.myToolWindow, this));
        resize.add((AnAction)new ResizeToolWindowAction.Down(this.myToolWindow, this));
        resize.add(ActionManager.getInstance().getAction("MaximizeToolWindow"));
        group.add((AnAction)resize);
        if (!skipHideAction) {
            group.addSeparator();
            group.add((AnAction)new HideAction());
        }
        return group;
    }

    private DefaultActionGroup createGearPopupGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        if (this.myAdditionalGearActions != null) {
            InternalDecorator.addSorted(group, this.myAdditionalGearActions);
            group.addSeparator();
        }
        group.addAction((AnAction)this.myToggleToolbarGroup).setAsSecondary(true);
        if (this.myInfo.isDocked()) {
            group.add((AnAction)this.myToggleAutoHideModeAction);
            group.add((AnAction)this.myToggleDockModeAction);
            group.add((AnAction)this.myToggleFloatingModeAction);
            group.add((AnAction)this.myToggleWindowedModeAction);
            group.add((AnAction)this.myToggleSideModeAction);
        } else if (this.myInfo.isFloating()) {
            group.add((AnAction)this.myToggleAutoHideModeAction);
            group.add((AnAction)this.myToggleFloatingModeAction);
            group.add((AnAction)this.myToggleWindowedModeAction);
        } else if (this.myInfo.isWindowed()) {
            group.add((AnAction)this.myToggleFloatingModeAction);
            group.add((AnAction)this.myToggleWindowedModeAction);
        } else if (this.myInfo.isSliding()) {
            if (!ToolWindowId.PREVIEW.equals(this.myInfo.getId())) {
                group.add((AnAction)this.myToggleDockModeAction);
            }
            group.add((AnAction)this.myToggleFloatingModeAction);
            group.add((AnAction)this.myToggleWindowedModeAction);
            group.add((AnAction)this.myToggleSideModeAction);
        }
        group.add((AnAction)this.myHideStripeButtonAction);
        return group;
    }

    private static void addSorted(DefaultActionGroup main, ActionGroup group) {
        AnAction[] children2 = group.getChildren(null);
        boolean hadSecondary = false;
        for (AnAction action : children2) {
            if (group.isPrimary(action)) {
                main.add(action);
                continue;
            }
            hadSecondary = true;
        }
        if (hadSecondary) {
            main.addSeparator();
            for (AnAction action : children2) {
                if (group.isPrimary(action)) continue;
                main.addAction(action).setAsSecondary(true);
            }
        }
        String separatorText = group.getTemplatePresentation().getText();
        if (children2.length > 0 && !StringUtil.isEmpty((String)separatorText)) {
            main.addAction((AnAction)new Separator(separatorText), Constraints.FIRST);
        }
    }

    final ToolWindowImpl getToolWindow() {
        return this.myToolWindow;
    }

    @NotNull
    final WindowInfoImpl getWindowInfo() {
        WindowInfoImpl windowInfoImpl = this.myInfo;
        if (windowInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/InternalDecorator", "getWindowInfo"));
        }
        return windowInfoImpl;
    }

    public int getHeaderHeight() {
        return this.myHeader.getPreferredSize().height;
    }

    @Override
    protected final void processComponentEvent(ComponentEvent e) {
        super.processComponentEvent(e);
        if (101 == e.getID()) {
            this.fireResized();
        }
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/InternalDecorator", "putInfo"));
        }
        info.put("toolWindowTitle", this.myToolWindow.getTitle());
        Content selection = this.myToolWindow.getContentManager().getSelectedContent();
        if (selection != null) {
            info.put("toolWindowTab", selection.getTabName());
        }
    }

    public void setAdditionalGearActions(@Nullable ActionGroup additionalGearActions) {
        this.myAdditionalGearActions = additionalGearActions;
    }

    private final class MyDivider
    extends JPanel {
        private boolean myDragging;
        private Point myLastPoint;
        private Disposable myDisposable;
        private IdeGlassPane myGlassPane;
        private final MouseAdapter myListener = new MyMouseAdapter();

        private MyDivider() {
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.myGlassPane = IdeGlassPaneUtil.find((Component)this);
            this.myDisposable = Disposer.newDisposable();
            this.myGlassPane.addMouseMotionPreprocessor((MouseMotionListener)this.myListener, this.myDisposable);
            this.myGlassPane.addMousePreprocessor((MouseListener)this.myListener, this.myDisposable);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            if (this.myDisposable != null && !Disposer.isDisposed((Disposable)this.myDisposable)) {
                Disposer.dispose((Disposable)this.myDisposable);
            }
        }

        boolean isInDragZone(MouseEvent e) {
            Point p = SwingUtilities.convertMouseEvent(e.getComponent(), e, this).getPoint();
            return Math.abs(InternalDecorator.this.myInfo.getAnchor().isHorizontal() ? p.y : p.x) < 6;
        }

        @Override
        @NotNull
        public Cursor getCursor() {
            boolean isVerticalCursor = InternalDecorator.this.myInfo.isDocked() ? InternalDecorator.this.myInfo.getAnchor().isSplitVertically() : InternalDecorator.this.myInfo.getAnchor().isHorizontal();
            Cursor cursor = isVerticalCursor ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11);
            if (cursor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/InternalDecorator$MyDivider", "getCursor"));
            }
            return cursor;
        }

        private class MyMouseAdapter
        extends MouseAdapter {
            private MyMouseAdapter() {
            }

            private void updateCursor(MouseEvent e) {
                if (MyDivider.this.isInDragZone(e)) {
                    MyDivider.this.myGlassPane.setCursor(MyDivider.this.getCursor(), (Object)MyDivider.this);
                    e.consume();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MyDivider.this.myDragging = MyDivider.this.isInDragZone(e);
                this.updateCursor(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.updateCursor(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.updateCursor(e);
                MyDivider.this.myDragging = false;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.updateCursor(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!MyDivider.this.myDragging) {
                    return;
                }
                MouseEvent event = SwingUtilities.convertMouseEvent(e.getComponent(), e, MyDivider.this);
                ToolWindowAnchor anchor = InternalDecorator.this.myInfo.getAnchor();
                Point point = event.getPoint();
                Container windowPane = InternalDecorator.this.getParent();
                MyDivider.this.myLastPoint = SwingUtilities.convertPoint(MyDivider.this, point, windowPane);
                ((MyDivider)MyDivider.this).myLastPoint.x = Math.min(Math.max(((MyDivider)MyDivider.this).myLastPoint.x, 0), windowPane.getWidth());
                ((MyDivider)MyDivider.this).myLastPoint.y = Math.min(Math.max(((MyDivider)MyDivider.this).myLastPoint.y, 0), windowPane.getHeight());
                Rectangle bounds = InternalDecorator.this.getBounds();
                if (anchor == ToolWindowAnchor.TOP) {
                    InternalDecorator.this.setBounds(0, 0, bounds.width, ((MyDivider)MyDivider.this).myLastPoint.y);
                } else if (anchor == ToolWindowAnchor.LEFT) {
                    InternalDecorator.this.setBounds(0, 0, ((MyDivider)MyDivider.this).myLastPoint.x, bounds.height);
                } else if (anchor == ToolWindowAnchor.BOTTOM) {
                    InternalDecorator.this.setBounds(0, ((MyDivider)MyDivider.this).myLastPoint.y, bounds.width, windowPane.getHeight() - ((MyDivider)MyDivider.this).myLastPoint.y);
                } else if (anchor == ToolWindowAnchor.RIGHT) {
                    InternalDecorator.this.setBounds(((MyDivider)MyDivider.this).myLastPoint.x, 0, windowPane.getWidth() - ((MyDivider)MyDivider.this).myLastPoint.x, bounds.height);
                }
                InternalDecorator.this.validate();
                e.consume();
            }
        }
    }

    private final class ToggleContentUiTypeAction
    extends ToggleAction
    implements DumbAware {
        private boolean myHadSeveralContents;

        private ToggleContentUiTypeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_CONTENT_UI_TYPE_ACTION_ID));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/InternalDecorator$ToggleContentUiTypeAction", "update"));
            }
            this.myHadSeveralContents = this.myHadSeveralContents || InternalDecorator.this.myToolWindow.getContentManager().getContentCount() > 1;
            super.update(e);
            e.getPresentation().setVisible(this.myHadSeveralContents);
        }

        public boolean isSelected(AnActionEvent e) {
            return InternalDecorator.this.myInfo.getContentUiType() == ToolWindowContentUiType.COMBO;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            InternalDecorator.this.fireContentUiTypeChanges(state ? ToolWindowContentUiType.COMBO : ToolWindowContentUiType.TABBED);
        }
    }

    private final class HideAction
    extends AnAction
    implements DumbAware {
        @NonNls
        public static final String HIDE_ACTIVE_WINDOW_ACTION_ID = "HideActiveWindow";

        public HideAction() {
            this.copyFrom(ActionManager.getInstance().getAction("HideActiveWindow"));
            this.getTemplatePresentation().setText(UIBundle.message((String)"tool.window.hide.action.name", (Object[])new Object[0]));
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/InternalDecorator$HideAction", "actionPerformed"));
            }
            InternalDecorator.this.fireHidden();
        }

        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/InternalDecorator$HideAction", "update"));
            }
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(InternalDecorator.this.myInfo.isVisible());
        }
    }

    private final class RemoveStripeButtonAction
    extends AnAction
    implements DumbAware {
        public RemoveStripeButtonAction() {
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(ActionsBundle.message((String)"action.RemoveStripeButton.text", (Object[])new Object[0]));
            presentation.setDescription(ActionsBundle.message((String)"action.RemoveStripeButton.description", (Object[])new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/InternalDecorator$RemoveStripeButtonAction", "update"));
            }
            e.getPresentation().setEnabledAndVisible(InternalDecorator.this.myInfo.isShowStripeButton());
        }

        public void actionPerformed(AnActionEvent e) {
            InternalDecorator.this.fireVisibleOnPanelChanged(false);
            if (InternalDecorator.this.getToolWindow().isActive()) {
                InternalDecorator.this.fireHidden();
            }
        }
    }

    private final class ToggleSideModeAction
    extends ToggleAction
    implements DumbAware {
        public ToggleSideModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_SIDE_MODE_ACTION_ID));
        }

        public final boolean isSelected(AnActionEvent event) {
            return InternalDecorator.this.myInfo.isSplit();
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            InternalDecorator.this.fireSideStatusChanged(flag);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/InternalDecorator$ToggleSideModeAction", "update"));
            }
            super.update(e);
        }
    }

    private final class ToggleWindowedModeAction
    extends ToggleAction
    implements DumbAware {
        public ToggleWindowedModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_WINDOWED_MODE_ACTION_ID));
        }

        public final boolean isSelected(AnActionEvent event) {
            return InternalDecorator.this.myInfo.isWindowed();
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            if (InternalDecorator.this.myInfo.isWindowed()) {
                InternalDecorator.this.fireTypeChanged(InternalDecorator.this.myInfo.getInternalType());
            } else {
                InternalDecorator.this.fireTypeChanged(ToolWindowType.WINDOWED);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/InternalDecorator$ToggleWindowedModeAction", "update"));
            }
            super.update(e);
            if (SystemInfo.isMac) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }
    }

    private final class ToggleFloatingModeAction
    extends ToggleAction
    implements DumbAware {
        public ToggleFloatingModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_FLOATING_MODE_ACTION_ID));
        }

        public final boolean isSelected(AnActionEvent event) {
            return InternalDecorator.this.myInfo.isFloating();
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            if (InternalDecorator.this.myInfo.isFloating()) {
                InternalDecorator.this.fireTypeChanged(InternalDecorator.this.myInfo.getInternalType());
            } else {
                InternalDecorator.this.fireTypeChanged(ToolWindowType.FLOATING);
            }
        }
    }

    private final class ToggleDockModeAction
    extends ToggleAction
    implements DumbAware {
        public ToggleDockModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_DOCK_MODE_ACTION_ID));
        }

        public final boolean isSelected(AnActionEvent event) {
            return InternalDecorator.this.myInfo.isDocked();
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            if (InternalDecorator.this.myInfo.isDocked()) {
                InternalDecorator.this.fireTypeChanged(ToolWindowType.SLIDING);
            } else if (InternalDecorator.this.myInfo.isSliding()) {
                InternalDecorator.this.fireTypeChanged(ToolWindowType.DOCKED);
            }
        }
    }

    private final class TogglePinnedModeAction
    extends ToggleAction
    implements DumbAware {
        public TogglePinnedModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_PINNED_MODE_ACTION_ID));
        }

        public final boolean isSelected(AnActionEvent event) {
            return !InternalDecorator.this.myInfo.isAutoHide();
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            InternalDecorator.this.fireAutoHideChanged(!InternalDecorator.this.myInfo.isAutoHide());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/InternalDecorator$TogglePinnedModeAction", "update"));
            }
            super.update(e);
            e.getPresentation().setVisible(InternalDecorator.this.myInfo.getType() != ToolWindowType.FLOATING && InternalDecorator.this.myInfo.getType() != ToolWindowType.WINDOWED);
        }
    }

    private final class ChangeAnchorAction
    extends AnAction
    implements DumbAware {
        private final ToolWindowAnchor myAnchor;

        public ChangeAnchorAction(String title, ToolWindowAnchor anchor) {
            super(title);
            this.myAnchor = anchor;
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/InternalDecorator$ChangeAnchorAction", "actionPerformed"));
            }
            InternalDecorator.this.fireAnchorChanged(this.myAnchor);
        }
    }

    private class InnerPanelBorder
    implements Border {
        private final ToolWindow myWindow;

        private InnerPanelBorder(ToolWindow window) {
            this.myWindow = window;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (UIUtil.isUnderDarcula()) {
                g.setColor((Color)Gray._40);
                this.doPaintBorder(c, g, x, y, width, height);
            } else {
                g.setColor((Color)(SystemInfo.isMac && UIUtil.isUnderIntelliJLaF() ? Gray.xC9 : Gray._155));
                this.doPaintBorder(c, g, x, y, width, height);
            }
        }

        private void doPaintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Insets insets = this.getBorderInsets(c);
            if (insets.top > 0) {
                UIUtil.drawLine((Graphics)g, (int)x, (int)(y + insets.top - 1), (int)(x + width - 1), (int)(y + insets.top - 1));
                UIUtil.drawLine((Graphics)g, (int)x, (int)(y + insets.top), (int)(x + width - 1), (int)(y + insets.top));
            }
            if (insets.left > 0) {
                UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)x, (int)(y + height));
                UIUtil.drawLine((Graphics)g, (int)(x + 1), (int)y, (int)(x + 1), (int)(y + height));
            }
            if (insets.right > 0) {
                UIUtil.drawLine((Graphics)g, (int)(x + width - 1), (int)(y + insets.top), (int)(x + width - 1), (int)(y + height));
                UIUtil.drawLine((Graphics)g, (int)(x + width), (int)(y + insets.top), (int)(x + width), (int)(y + height));
            }
            if (insets.bottom > 0) {
                UIUtil.drawLine((Graphics)g, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height - 1));
                UIUtil.drawLine((Graphics)g, (int)x, (int)(y + height), (int)(x + width), (int)(y + height));
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (InternalDecorator.this.myProject == null) {
                return new Insets(0, 0, 0, 0);
            }
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)InternalDecorator.this.myProject);
            if (!(toolWindowManager instanceof ToolWindowManagerImpl) || !((ToolWindowManagerImpl)toolWindowManager).isToolWindowRegistered(InternalDecorator.this.myInfo.getId()) || this.myWindow.getType() == ToolWindowType.FLOATING) {
                return new Insets(0, 0, 0, 0);
            }
            ToolWindowAnchor anchor = this.myWindow.getAnchor();
            Container component = this.myWindow.getComponent();
            Container parent = component.getParent();
            while (parent != null) {
                if (parent instanceof Splitter) {
                    Splitter splitter = (Splitter)parent;
                    boolean isFirst = splitter.getFirstComponent() == component;
                    boolean isVertical = splitter.isVertical();
                    return new Insets(0, anchor == ToolWindowAnchor.RIGHT || !isVertical && !isFirst ? 1 : 0, isVertical && isFirst ? 1 : 0, anchor == ToolWindowAnchor.LEFT || !isVertical && isFirst ? 1 : 0);
                }
                component = parent;
                parent = component.getParent();
            }
            return new Insets(0, anchor == ToolWindowAnchor.RIGHT ? 1 : 0, anchor == ToolWindowAnchor.TOP ? 1 : 0, anchor == ToolWindowAnchor.LEFT ? 1 : 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

