/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.Patches;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManagerListener;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.AWTUtilitiesWrapper;
import com.intellij.openapi.wm.impl.CommandProcessor;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.WindowWatcher;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.platform.WindowUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.FramePeer;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WindowManager", defaultStateAsResource=true, storages={@Storage(value="window.manager.xml", roamingType=RoamingType.DISABLED)})
public final class WindowManagerImpl
extends WindowManagerEx
implements NamedComponent,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.WindowManagerImpl");
    @NonNls
    public static final String FULL_SCREEN = "ide.frame.full.screen";
    @NonNls
    private static final String FOCUSED_WINDOW_PROPERTY_NAME = "focusedWindow";
    @NonNls
    private static final String X_ATTR = "x";
    @NonNls
    private static final String FRAME_ELEMENT = "frame";
    @NonNls
    private static final String Y_ATTR = "y";
    @NonNls
    private static final String WIDTH_ATTR = "width";
    @NonNls
    private static final String HEIGHT_ATTR = "height";
    @NonNls
    private static final String EXTENDED_STATE_ATTR = "extended-state";
    private static final int ORACLE_BUG_8007219_THRESHOLD = 5;
    private Boolean myAlphaModeSupported = null;
    private final EventDispatcher<WindowManagerListener> myEventDispatcher = EventDispatcher.create(WindowManagerListener.class);
    private final CommandProcessor myCommandProcessor;
    private final WindowWatcher myWindowWatcher;
    private final DesktopLayout myLayout;
    private final HashMap<Project, IdeFrameImpl> myProject2Frame;
    private final HashMap<Project, Set<JDialog>> myDialogsToDispose;
    private Rectangle myFrameBounds;
    private int myFrameExtendedState;
    private final WindowAdapter myActivationListener;
    private final DataManager myDataManager;
    private final ActionManagerEx myActionManager;

    public WindowManagerImpl(DataManager dataManager, ActionManagerEx actionManager, MessageBus bus) {
        Application application;
        this.myDataManager = dataManager;
        this.myActionManager = actionManager;
        if (this.myDataManager instanceof DataManagerImpl) {
            ((DataManagerImpl)this.myDataManager).setWindowManager(this);
        }
        if (!(application = ApplicationManager.getApplication()).isUnitTestMode()) {
            Disposer.register((Disposable)application, (Disposable)new Disposable(){

                public void dispose() {
                    WindowManagerImpl.this.disposeRootFrame();
                }
            });
        }
        this.myCommandProcessor = new CommandProcessor();
        this.myWindowWatcher = new WindowWatcher();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener(FOCUSED_WINDOW_PROPERTY_NAME, this.myWindowWatcher);
        this.myLayout = new DesktopLayout();
        this.myProject2Frame = new HashMap();
        this.myDialogsToDispose = new HashMap();
        this.myFrameExtendedState = 0;
        this.myActivationListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                Window activeWindow = e.getWindow();
                if (activeWindow instanceof IdeFrameImpl) {
                    WindowManagerImpl.this.proceedDialogDisposalQueue(((IdeFrameImpl)activeWindow).getProject());
                }
            }
        };
        bus.connect().subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            @Override
            public void appClosing() {
                Project[] openProjects;
                if (WindowManagerImpl.this.isFullScreenSupportedInCurrentOS() && GeneralSettings.getInstance().isReopenLastProject() && (openProjects = ProjectManager.getInstance().getOpenProjects()).length > 0) {
                    WindowManagerEx wm = WindowManagerEx.getInstanceEx();
                    for (Project project2 : openProjects) {
                        IdeFrameImpl frame = wm.getFrame(project2);
                        if (frame == null) continue;
                        frame.storeFullScreenStateIfNeeded();
                    }
                }
            }
        });
        if (UIUtil.hasLeakingAppleListeners()) {
            UIUtil.addAwtListener((AWTEventListener)new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (event.getID() == 300 && ((ContainerEvent)event).getChild() instanceof JViewport) {
                        UIUtil.removeLeakingAppleListeners();
                    }
                }
            }, (long)2L, (Disposable)application);
        }
    }

    @NotNull
    public IdeFrameImpl[] getAllProjectFrames() {
        Collection<IdeFrameImpl> ideFrames = this.myProject2Frame.values();
        IdeFrameImpl[] ideFrameImplArray = ideFrames.toArray(new IdeFrameImpl[ideFrames.size()]);
        if (ideFrameImplArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowManagerImpl", "getAllProjectFrames"));
        }
        return ideFrameImplArray;
    }

    public JFrame findVisibleFrame() {
        IdeFrameImpl[] frames = this.getAllProjectFrames();
        return frames.length > 0 ? frames[0] : (JFrame)WelcomeFrame.getInstance();
    }

    public void addListener(WindowManagerListener listener2) {
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public void removeListener(WindowManagerListener listener2) {
        this.myEventDispatcher.removeListener((EventListener)listener2);
    }

    @Override
    public final Rectangle getScreenBounds() {
        return ScreenUtil.getAllScreensRectangle();
    }

    @Override
    public Rectangle getScreenBounds(@NotNull Project project2) {
        GraphicsDevice[] devices;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/WindowManagerImpl", "getScreenBounds"));
        }
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point onScreen = this.getFrame(project2).getLocationOnScreen();
        for (GraphicsDevice device : devices = environment.getScreenDevices()) {
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            if (!bounds.contains(onScreen)) continue;
            return bounds;
        }
        return null;
    }

    public final boolean isInsideScreenBounds(int x, int y, int width) {
        return ScreenUtil.getAllScreensShape().contains(x, y, width, 1.0);
    }

    public final boolean isInsideScreenBounds(int x, int y) {
        return ScreenUtil.getAllScreensShape().contains(x, y);
    }

    public final boolean isAlphaModeSupported() {
        if (this.myAlphaModeSupported == null) {
            this.myAlphaModeSupported = WindowManagerImpl.calcAlphaModelSupported();
        }
        return this.myAlphaModeSupported;
    }

    private static boolean calcAlphaModelSupported() {
        if (AWTUtilitiesWrapper.isTranslucencyAPISupported()) {
            return AWTUtilitiesWrapper.isTranslucencySupported(AWTUtilitiesWrapper.TRANSLUCENT);
        }
        try {
            return WindowUtils.isWindowAlphaSupported();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public final void setAlphaModeRatio(Window window, float ratio) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
        if (ratio < 0.0f || ratio > 1.0f) {
            throw new IllegalArgumentException("ratio must be in [0..1] range. ratio=" + ratio);
        }
        if (!this.isAlphaModeSupported() || !this.isAlphaModeEnabled(window)) {
            return;
        }
        WindowManagerImpl.setAlphaMode(window, ratio);
    }

    private static void setAlphaMode(Window window, float ratio) {
        try {
            if (SystemInfo.isMacOSLeopard) {
                if (window instanceof JWindow) {
                    ((JWindow)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                } else if (window instanceof JDialog) {
                    ((JDialog)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                } else if (window instanceof JFrame) {
                    ((JFrame)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                }
            } else if (AWTUtilitiesWrapper.isTranslucencySupported(AWTUtilitiesWrapper.TRANSLUCENT)) {
                AWTUtilitiesWrapper.setWindowOpacity(window, 1.0f - ratio);
            } else {
                WindowUtils.setWindowAlpha((Window)window, (float)(1.0f - ratio));
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    @Override
    public void setWindowMask(Window window, @Nullable Shape mask) {
        try {
            if (AWTUtilitiesWrapper.isTranslucencySupported(AWTUtilitiesWrapper.PERPIXEL_TRANSPARENT)) {
                AWTUtilitiesWrapper.setWindowShape(window, mask);
            } else {
                WindowUtils.setWindowMask((Window)window, (Shape)mask);
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    @Override
    public void setWindowShadow(Window window, WindowManagerEx.WindowShadowMode mode) {
        if (window instanceof JWindow) {
            JRootPane root = ((JWindow)window).getRootPane();
            root.putClientProperty("Window.shadow", mode == WindowManagerEx.WindowShadowMode.DISABLED ? Boolean.FALSE : Boolean.TRUE);
            root.putClientProperty("Window.style", mode == WindowManagerEx.WindowShadowMode.SMALL ? "small" : null);
        }
    }

    @Override
    public void resetWindow(Window window) {
        try {
            if (!this.isAlphaModeSupported()) {
                return;
            }
            this.setWindowMask(window, null);
            WindowManagerImpl.setAlphaMode(window, 0.0f);
            this.setWindowShadow(window, WindowManagerEx.WindowShadowMode.NORMAL);
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    public final boolean isAlphaModeEnabled(Window window) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
        return this.isAlphaModeSupported();
    }

    public final void setAlphaModeEnabled(Window window, boolean state) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
    }

    @Override
    public void hideDialog(JDialog dialog, Project project2) {
        if (project2 == null) {
            dialog.dispose();
        } else {
            IdeFrameImpl frame = this.getFrame(project2);
            if (frame.isActive()) {
                dialog.dispose();
            } else {
                this.queueForDisposal(dialog, project2);
                dialog.setVisible(false);
            }
        }
    }

    @Override
    public void adjustContainerWindow(Component c, Dimension oldSize, Dimension newSize) {
        JBPopup popup;
        if (c == null) {
            return;
        }
        Window wnd = SwingUtilities.getWindowAncestor(c);
        if (wnd instanceof JWindow && (popup = (JBPopup)((JWindow)wnd).getRootPane().getClientProperty("JBPopup")) != null && oldSize.height < newSize.height) {
            Dimension size = popup.getSize();
            size.height += newSize.height - oldSize.height;
            popup.setSize(size);
            popup.moveToFitScreen();
        }
    }

    public final void doNotSuggestAsParent(Window window) {
        this.myWindowWatcher.doNotSuggestAsParent(window);
    }

    @Override
    public final void dispatchComponentEvent(ComponentEvent e) {
        this.myWindowWatcher.dispatchComponentEvent(e);
    }

    @Nullable
    public final Window suggestParentWindow(@Nullable Project project2) {
        return this.myWindowWatcher.suggestParentWindow(project2);
    }

    public final StatusBar getStatusBar(Project project2) {
        if (!this.myProject2Frame.containsKey(project2)) {
            return null;
        }
        IdeFrameImpl frame = this.getFrame(project2);
        LOG.assertTrue(frame != null);
        return frame.getStatusBar();
    }

    public StatusBar getStatusBar(@NotNull Component c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/WindowManagerImpl", "getStatusBar"));
        }
        return this.getStatusBar(c, null);
    }

    public StatusBar getStatusBar(@NotNull Component c, @Nullable Project project2) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/WindowManagerImpl", "getStatusBar"));
        }
        Component parent = UIUtil.findUltimateParent((Component)c);
        if (parent instanceof IdeFrame) {
            return ((IdeFrame)parent).getStatusBar().findChild(c);
        }
        IdeFrame frame = this.findFrameFor(project2);
        if (frame != null) {
            return frame.getStatusBar().findChild(c);
        }
        assert (false) : "Cannot find status bar for " + c;
        return null;
    }

    @Override
    public IdeFrame findFrameFor(@Nullable Project project2) {
        IdeFrame frame = null;
        if (project2 != null) {
            Object object = frame = project2.isDefault() ? WelcomeFrame.getInstance() : this.getFrame(project2);
            if (frame == null) {
                frame = this.myProject2Frame.get(null);
            }
        } else {
            for (Container eachParent = this.getMostRecentFocusedWindow(); eachParent != null; eachParent = eachParent.getParent()) {
                if (!(eachParent instanceof IdeFrame)) continue;
                frame = (IdeFrame)eachParent;
                break;
            }
            if (frame == null) {
                frame = WindowManagerImpl.tryToFindTheOnlyFrame();
            }
        }
        return frame;
    }

    private static IdeFrame tryToFindTheOnlyFrame() {
        Frame[] all;
        IdeFrame candidate = null;
        for (Frame each : all = Frame.getFrames()) {
            if (!(each instanceof IdeFrame)) continue;
            if (candidate == null) {
                candidate = (IdeFrame)each;
                continue;
            }
            candidate = null;
            break;
        }
        return candidate;
    }

    @Override
    public final IdeFrameImpl getFrame(@Nullable Project project2) {
        return this.myProject2Frame.get(project2);
    }

    public IdeFrame getIdeFrame(@Nullable Project project2) {
        Frame[] frames;
        if (project2 != null) {
            return this.getFrame(project2);
        }
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Component parent = UIUtil.findUltimateParent((Component)window);
        if (parent instanceof IdeFrame) {
            return (IdeFrame)parent;
        }
        for (Frame each : frames = Frame.getFrames()) {
            if (!(each instanceof IdeFrame)) continue;
            return (IdeFrame)each;
        }
        return null;
    }

    public void showFrame() {
        IdeFrameImpl frame = new IdeFrameImpl(ApplicationInfoEx.getInstanceEx(), this.myActionManager, this.myDataManager, ApplicationManager.getApplication());
        this.myProject2Frame.put(null, frame);
        if (this.myFrameBounds == null || !ScreenUtil.isVisible((Rectangle)this.myFrameBounds)) {
            this.myFrameBounds = ScreenUtil.getMainScreenBounds();
            int xOff = this.myFrameBounds.width / 8;
            int yOff = this.myFrameBounds.height / 8;
            JBInsets.removeFrom((Rectangle)this.myFrameBounds, (Insets)new Insets(yOff, xOff, yOff, xOff));
        }
        this.fixForOracleBug8007219(frame);
        frame.setBounds(this.myFrameBounds);
        frame.setExtendedState(this.myFrameExtendedState);
        frame.setVisible(true);
    }

    private void fixForOracleBug8007219(IdeFrameImpl frame) {
        if ((this.myFrameExtendedState & 6) > 0 && Patches.JDK_BUG_ID_8007219) {
            Rectangle screenBounds = ScreenUtil.getMainScreenBounds();
            Insets screenInsets = ScreenUtil.getScreenInsets((GraphicsConfiguration)frame.getGraphicsConfiguration());
            int leftGap = this.myFrameBounds.x - screenInsets.left;
            this.myFrameBounds.x = leftGap > 5 ? this.myFrameBounds.x : screenInsets.left + 5 + 1;
            int topGap = this.myFrameBounds.y - screenInsets.top;
            this.myFrameBounds.y = topGap > 5 ? this.myFrameBounds.y : screenInsets.top + 5 + 1;
            int maximumFrameWidth = screenBounds.width - screenInsets.right - this.myFrameBounds.x;
            int rightGap = maximumFrameWidth - this.myFrameBounds.width;
            this.myFrameBounds.width = rightGap > 5 ? this.myFrameBounds.width : maximumFrameWidth - 5 - 1;
            int maximumFrameHeight = screenBounds.height - screenInsets.bottom - this.myFrameBounds.y;
            int bottomGap = maximumFrameHeight - this.myFrameBounds.height;
            this.myFrameBounds.height = bottomGap > 5 ? this.myFrameBounds.height : -6;
        }
    }

    private IdeFrameImpl getDefaultEmptyIdeFrame() {
        return this.myProject2Frame.get(null);
    }

    @Override
    public final IdeFrameImpl allocateFrame(Project project2) {
        IdeFrameImpl frame;
        LOG.assertTrue(!this.myProject2Frame.containsKey(project2));
        if (this.myProject2Frame.containsKey(null)) {
            frame = this.getDefaultEmptyIdeFrame();
            this.myProject2Frame.remove(null);
            this.myProject2Frame.put(project2, frame);
            frame.setProject(project2);
        } else {
            frame = new IdeFrameImpl(ApplicationInfoEx.getInstanceEx(), this.myActionManager, this.myDataManager, ApplicationManager.getApplication());
            Rectangle bounds = ProjectFrameBounds.getInstance(project2).getBounds();
            if (bounds != null) {
                this.myFrameBounds = bounds;
            }
            if (this.myFrameBounds != null) {
                this.fixForOracleBug8007219(frame);
                frame.setBounds(this.myFrameBounds);
            }
            frame.setProject(project2);
            this.myProject2Frame.put(project2, frame);
            frame.setExtendedState(this.myFrameExtendedState);
            frame.setVisible(true);
        }
        frame.addWindowListener(this.myActivationListener);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(@NotNull ComponentEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/WindowManagerImpl$5", "componentMoved"));
                }
                WindowManagerImpl.this.updateFrameBounds(frame);
            }
        });
        ((WindowManagerListener)this.myEventDispatcher.getMulticaster()).frameCreated((IdeFrame)frame);
        return frame;
    }

    private void proceedDialogDisposalQueue(Project project2) {
        Set<JDialog> dialogs = this.myDialogsToDispose.get(project2);
        if (dialogs == null) {
            return;
        }
        for (JDialog dialog : dialogs) {
            dialog.dispose();
        }
        this.myDialogsToDispose.put(project2, null);
    }

    private void queueForDisposal(JDialog dialog, Project project2) {
        Set<JDialog> dialogs = this.myDialogsToDispose.get(project2);
        if (dialogs == null) {
            dialogs = new HashSet<JDialog>();
            this.myDialogsToDispose.put(project2, dialogs);
        }
        dialogs.add(dialog);
    }

    @Override
    public final void releaseFrame(IdeFrameImpl frame) {
        ((WindowManagerListener)this.myEventDispatcher.getMulticaster()).beforeFrameReleased((IdeFrame)frame);
        Project project2 = frame.getProject();
        LOG.assertTrue(project2 != null);
        frame.removeWindowListener(this.myActivationListener);
        this.proceedDialogDisposalQueue(project2);
        frame.setProject(null);
        frame.setTitle(null);
        frame.setFileTitle(null, null);
        this.myProject2Frame.remove(project2);
        if (this.myProject2Frame.isEmpty()) {
            this.myProject2Frame.put(null, frame);
        } else {
            Disposer.dispose((Disposable)frame.getStatusBar());
            frame.dispose();
        }
    }

    public final void disposeRootFrame() {
        IdeFrameImpl rootFrame;
        if (this.myProject2Frame.size() == 1 && (rootFrame = this.myProject2Frame.remove(null)) != null) {
            rootFrame.dispose();
        }
    }

    @Override
    public final Window getMostRecentFocusedWindow() {
        return this.myWindowWatcher.getFocusedWindow();
    }

    @Override
    public final Component getFocusedComponent(@NotNull Window window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/wm/impl/WindowManagerImpl", "getFocusedComponent"));
        }
        return this.myWindowWatcher.getFocusedComponent(window);
    }

    @Override
    @Nullable
    public final Component getFocusedComponent(@Nullable Project project2) {
        return this.myWindowWatcher.getFocusedComponent(project2);
    }

    @Override
    @NotNull
    public final CommandProcessor getCommandProcessor() {
        CommandProcessor commandProcessor = this.myCommandProcessor;
        if (commandProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowManagerImpl", "getCommandProcessor"));
        }
        return commandProcessor;
    }

    public void loadState(Element state) {
        Element desktopElement;
        Element frameElement = state.getChild(FRAME_ELEMENT);
        if (frameElement != null) {
            this.myFrameBounds = WindowManagerImpl.loadFrameBounds(frameElement);
            try {
                this.myFrameExtendedState = Integer.parseInt(frameElement.getAttributeValue(EXTENDED_STATE_ATTR));
                if ((this.myFrameExtendedState & 1) > 0) {
                    this.myFrameExtendedState = 0;
                }
            }
            catch (NumberFormatException ignored) {
                this.myFrameExtendedState = 0;
            }
        }
        if ((desktopElement = state.getChild("layout")) != null) {
            this.myLayout.readExternal(desktopElement);
        }
    }

    private static Rectangle loadFrameBounds(Element frameElement) {
        Rectangle bounds = new Rectangle();
        try {
            bounds.x = Integer.parseInt(frameElement.getAttributeValue(X_ATTR));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        try {
            bounds.y = Integer.parseInt(frameElement.getAttributeValue(Y_ATTR));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        try {
            bounds.width = Integer.parseInt(frameElement.getAttributeValue(WIDTH_ATTR));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        try {
            bounds.height = Integer.parseInt(frameElement.getAttributeValue(HEIGHT_ATTR));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        return bounds;
    }

    @Nullable
    public Element getState() {
        Element frameState = this.getFrameState();
        if (frameState == null) {
            return null;
        }
        Element state = new Element("state");
        state.addContent(frameState);
        Element layoutElement = new Element("layout");
        state.addContent(layoutElement);
        this.myLayout.writeExternal(layoutElement);
        return state;
    }

    private Element getFrameState() {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        if (projects.length == 0) {
            return null;
        }
        Project project2 = projects[0];
        IdeFrameImpl frame = this.getFrame(project2);
        if (frame == null) {
            return null;
        }
        int extendedState = this.updateFrameBounds(frame);
        Rectangle rectangle = this.myFrameBounds;
        Element frameElement = new Element(FRAME_ELEMENT);
        frameElement.setAttribute(X_ATTR, Integer.toString(rectangle.x));
        frameElement.setAttribute(Y_ATTR, Integer.toString(rectangle.y));
        frameElement.setAttribute(WIDTH_ATTR, Integer.toString(rectangle.width));
        frameElement.setAttribute(HEIGHT_ATTR, Integer.toString(rectangle.height));
        if (!frame.isInFullScreen() || !SystemInfo.isAppleJvm) {
            frameElement.setAttribute(EXTENDED_STATE_ATTR, Integer.toString(extendedState));
        }
        return frameElement;
    }

    private int updateFrameBounds(IdeFrameImpl frame) {
        boolean usePreviousBounds;
        ComponentPeer peer;
        int extendedState = frame.getExtendedState();
        if (SystemInfo.isMacOSLion && (peer = frame.getPeer()) instanceof FramePeer) {
            extendedState = ((FramePeer)peer).getState();
        }
        boolean isMaximized = extendedState == 6 || this.isFullScreenSupportedInCurrentOS() && frame.isInFullScreen();
        boolean bl = usePreviousBounds = isMaximized && this.myFrameBounds != null && frame.getBounds().contains(new Point((int)this.myFrameBounds.getCenterX(), (int)this.myFrameBounds.getCenterY()));
        if (!usePreviousBounds) {
            this.myFrameBounds = frame.getBounds();
        }
        return extendedState;
    }

    @Override
    public final DesktopLayout getLayout() {
        return this.myLayout;
    }

    @Override
    public final void setLayout(DesktopLayout layout) {
        this.myLayout.copyFrom(layout);
    }

    @NotNull
    public final String getComponentName() {
        if ("WindowManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowManagerImpl", "getComponentName"));
        }
        return "WindowManager";
    }

    public WindowWatcher getWindowWatcher() {
        return this.myWindowWatcher;
    }

    public boolean isFullScreenSupportedInCurrentOS() {
        return SystemInfo.isMacOSLion || SystemInfo.isWindows || SystemInfo.isXWindow && X11UiUtil.isFullScreenSupported();
    }

    public static boolean isFloatingMenuBarSupported() {
        return !SystemInfo.isMac && WindowManagerImpl.getInstance().isFullScreenSupportedInCurrentOS();
    }

    static {
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable t) {
            LOG.info("jawt failed to load", t);
        }
    }
}

