/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.util.Condition;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ArtifactModelBase
implements ArtifactModel {
    private Map<String, Artifact> myArtifactsMap;
    private Artifact[] myArtifactsArray;
    public static final Condition<Artifact> VALID_ARTIFACT_CONDITION = new Condition<Artifact>(){

        public boolean value(Artifact artifact) {
            return !(artifact instanceof InvalidArtifact);
        }
    };

    protected abstract List<? extends Artifact> getArtifactsList();

    @NotNull
    public Artifact[] getArtifacts() {
        if (this.myArtifactsArray == null) {
            List validArtifacts = ContainerUtil.findAll(this.getArtifactsList(), VALID_ARTIFACT_CONDITION);
            this.myArtifactsArray = validArtifacts.toArray(new Artifact[validArtifacts.size()]);
        }
        if (this.myArtifactsArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/ArtifactModelBase", "getArtifacts"));
        }
        return this.myArtifactsArray;
    }

    public List<? extends Artifact> getAllArtifactsIncludingInvalid() {
        return Collections.unmodifiableList(this.getArtifactsList());
    }

    public Artifact findArtifact(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/packaging/impl/artifacts/ArtifactModelBase", "findArtifact"));
        }
        if (this.myArtifactsMap == null) {
            this.myArtifactsMap = new HashMap<String, Artifact>();
            for (Artifact artifact : this.getArtifactsList()) {
                this.myArtifactsMap.put(artifact.getName(), artifact);
            }
        }
        return this.myArtifactsMap.get(name);
    }

    @NotNull
    public Artifact getArtifactByOriginal(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/artifacts/ArtifactModelBase", "getArtifactByOriginal"));
        }
        Artifact artifact2 = artifact;
        if (artifact2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/ArtifactModelBase", "getArtifactByOriginal"));
        }
        return artifact2;
    }

    @NotNull
    public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/artifacts/ArtifactModelBase", "getOriginalArtifact"));
        }
        Artifact artifact2 = artifact;
        if (artifact2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/ArtifactModelBase", "getOriginalArtifact"));
        }
        return artifact2;
    }

    @NotNull
    public Collection<? extends Artifact> getArtifactsByType(@NotNull ArtifactType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/packaging/impl/artifacts/ArtifactModelBase", "getArtifactsByType"));
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : this.getArtifacts()) {
            if (!artifact.getArtifactType().equals(type)) continue;
            result.add(artifact);
        }
        ArrayList<Artifact> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/ArtifactModelBase", "getArtifactsByType"));
        }
        return arrayList;
    }

    protected void artifactsChanged() {
        this.myArtifactsMap = null;
        this.myArtifactsArray = null;
    }
}

